/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GMessenger;
import g4p_controls.GWindow;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import processing.core.PApplet;

public final class GGroup
extends GAbstractControl {
    private static final int INVALID_ACTION = 0;
    private static final int ALPHA_TO = 1;
    private static final int ENABLE = 2;
    private static final int VISIBLE = 3;
    private static final int COLOR_SCHEME = 4;
    private List<Action> actions = new LinkedList<Action>();
    private int cTime;
    private int lTime;
    private int eTime;
    private int currentAlpha = this.targetAlpha = (n &= 0xFF);
    private int targetAlpha = 255;
    private float alpha = 255.0f;
    private float speed = 255.0f;

    public GGroup(PApplet pApplet) {
        this(pApplet, 255);
    }

    public GGroup(PApplet pApplet, int n) {
        super(pApplet);
        this.children = new LinkedList();
        this.registeredMethods = 4;
        this.eTime = 0;
        this.lTime = 0;
        this.cTime = 0;
        G4P.registerControl(this);
    }

    public GGroup(GWindow gWindow) {
        this(gWindow, 255);
    }

    public void fadeOut(int n, int n2) {
        n2 = n2 <= 0 ? 1 : n2;
        this.actions.add(new Action(1, n, 0, n2));
    }

    public void fadeIn(int n, int n2) {
        n2 = n2 <= 0 ? 1 : n2;
        this.actions.add(new Action(1, n, 255, n2));
    }

    public void fadeTo(int n, int n2, int n3) {
        n2 = n2 <= 0 ? 1 : n2;
        this.actions.add(new Action(1, n, n3 &= 0xFF, n2));
    }

    public void setEnabled(int n, boolean bl) {
        this.actions.add(new Action(2, n, bl));
    }

    public boolean isFading() {
        return this.currentAlpha != this.targetAlpha;
    }

    public int timeLeftFading() {
        if (this.currentAlpha == this.targetAlpha) {
            return 0;
        }
        return Math.round((float)(this.targetAlpha - this.currentAlpha) / this.speed);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEnabled(0, bl);
    }

    public void setVisible(int n, boolean bl) {
        this.actions.add(new Action(3, n, bl));
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisible(0, bl);
    }

    @Override
    public void setLocalColorScheme(int n) {
        this.setLocalColorScheme(0, n);
    }

    public void setLocalColorScheme(int n, int n2) {
        this.actions.add(new Action(4, n, n2 &= 0xF));
    }

    @Override
    public void pre() {
        if (this.lTime == 0) {
            this.cTime = this.lTime = (int)System.currentTimeMillis();
            return;
        }
        this.lTime = this.cTime;
        this.cTime = (int)System.currentTimeMillis();
        this.eTime = this.cTime - this.lTime;
        if (this.currentAlpha != this.targetAlpha) {
            this.peformFading();
        }
        if (!this.actions.isEmpty()) {
            this.processActions();
        }
    }

    private void peformFading() {
        float f = this.alpha + (float)this.eTime * this.speed;
        f = f < 0.0f ? 0.0f : f;
        f = f > 255.0f ? 255.0f : f;
        this.currentAlpha = (this.alpha - (float)this.targetAlpha) * (f - (float)this.targetAlpha) <= 0.0f ? this.targetAlpha : (int)f;
        this.alphaImpl(this.currentAlpha);
        this.alpha = f;
    }

    private void processActions() {
        Iterator<Action> iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            Action action = iterator.next();
            action.delay -= (long)this.eTime;
            if (action.delay > 0L) continue;
            iterator.remove();
            switch (action.type) {
                case 3: {
                    this.visibleImpl(action.bool);
                    break;
                }
                case 2: {
                    this.enableImpl(action.bool);
                    break;
                }
                case 4: {
                    this.colorImpl(action.target);
                    break;
                }
                case 1: {
                    if (action.duration <= 0) {
                        this.alphaImpl(action.target);
                        break;
                    }
                    this.speed = action.target - this.currentAlpha;
                    if (action.duration > 0) {
                        this.speed /= (float)action.duration;
                    }
                    this.alpha = this.currentAlpha;
                    this.targetAlpha = action.target;
                }
            }
        }
    }

    private void alphaImpl(int n) {
        for (GAbstractControl gAbstractControl : this.children) {
            gAbstractControl.setAlpha(n, true);
        }
    }

    private void colorImpl(int n) {
        n &= 0xFF;
        for (GAbstractControl gAbstractControl : this.children) {
            gAbstractControl.setLocalColorScheme(n, true);
        }
    }

    private void enableImpl(boolean bl) {
        for (GAbstractControl gAbstractControl : this.children) {
            gAbstractControl.setEnabled(bl);
        }
    }

    private void visibleImpl(boolean bl) {
        for (GAbstractControl gAbstractControl : this.children) {
            gAbstractControl.setVisible(bl);
        }
    }

    @Override
    public void addControls(GAbstractControl ... gAbstractControlArray) {
        if (gAbstractControlArray != null) {
            for (GAbstractControl gAbstractControl : gAbstractControlArray) {
                this.addControl(gAbstractControl);
            }
        }
    }

    @Override
    public void addControl(GAbstractControl gAbstractControl) {
        if (gAbstractControl != null) {
            if (!gAbstractControl.isSuitableForGroupControl(gAbstractControl)) {
                GMessenger.message(-16777213, new Object[]{this, gAbstractControl});
                return;
            }
            if (this.winApp != gAbstractControl.winApp) {
                GMessenger.message(-16777212, new Object[]{this, gAbstractControl});
                return;
            }
            gAbstractControl.setAlpha(this.currentAlpha, true);
            this.children.add(gAbstractControl);
        }
    }

    public void removeControls(GAbstractControl ... gAbstractControlArray) {
        if (gAbstractControlArray != null) {
            for (GAbstractControl gAbstractControl : gAbstractControlArray) {
                this.removeControl(gAbstractControl);
            }
        }
    }

    public void removeControl(GAbstractControl gAbstractControl) {
        if (gAbstractControl != null) {
            this.children.remove(gAbstractControl);
        }
    }

    private class Action {
        int type;
        long delay = 0L;
        int duration = 0;
        boolean bool = false;
        int target = 0;

        public Action(int n, long l, Object ... objectArray) {
            this.type = n;
            this.delay = l;
            switch (n) {
                case 2: 
                case 3: {
                    this.bool = (Boolean)objectArray[0];
                    break;
                }
                case 4: {
                    this.target = (Integer)objectArray[0];
                    break;
                }
                case 1: {
                    this.target = (Integer)objectArray[0];
                    this.duration = (Integer)objectArray[1];
                    break;
                }
                default: {
                    this.type = 0;
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            switch (this.type) {
                case 3: {
                    stringBuilder.append("VISIBLE       ");
                    break;
                }
                case 2: {
                    stringBuilder.append("ENABLE        ");
                    break;
                }
                case 4: {
                    stringBuilder.append("COLOR_SCHEME  ");
                    break;
                }
                case 1: {
                    stringBuilder.append("ALPHA_TO   over  ");
                    stringBuilder.append(this.duration + " millis  ");
                    break;
                }
                default: {
                    stringBuilder.append("INVALID       ");
                }
            }
            return stringBuilder.toString();
        }
    }
}

