/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GConstants;
import g4p_controls.GMessenger;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;

public class GCScheme
implements GConstants,
PConstants {
    private static Color[][] palettes = null;

    public static int[] getPalette(int n) {
        n = Math.abs(n) % 16;
        Color[] colorArray = palettes[n];
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = colorArray[i].getRGB();
        }
        return nArray;
    }

    public static void changePalette(int n, int[] nArray) {
        n = Math.abs(n) % 16;
        for (int i = 0; i < Math.min(16, nArray.length); ++i) {
            GCScheme.palettes[n][i] = new Color(nArray[i], true);
        }
        G4P.invalidateBuffers();
    }

    public static void copyPalette(int n, int n2) {
        if ((n = Math.abs(n) % 16) != (n2 = Math.abs(n2) % 16)) {
            int[] nArray = GCScheme.getPalette(n);
            GCScheme.changePalette(n2, nArray);
        }
    }

    public static void changePaletteColor(int n, int n2, int n3) {
        n = Math.abs(n) % 16;
        n2 = Math.abs(n2) % 16;
        GCScheme.palettes[n][n2] = new Color(n3, true);
        G4P.invalidateBuffers();
    }

    public static void savePalettes(PApplet pApplet) {
        GCScheme.savePalettes(pApplet, "user_gui_palette.png");
    }

    public static void savePalettes(PApplet pApplet, String string) {
        int n;
        int n2;
        PGraphics pGraphics = pApplet.createGraphics(256, 256, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.clear();
        pGraphics.noStroke();
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                pGraphics.fill(palettes[n2][n].getRGB());
                pGraphics.rect((float)(n * 16), (float)(n2 * 16), 16.0f, 16.0f);
            }
        }
        pGraphics.noFill();
        pGraphics.strokeWeight(2.0f);
        pGraphics.stroke(0);
        for (n2 = 0; n2 <= 16; ++n2) {
            n = n2 * 16;
            pGraphics.line(0.0f, (float)n, 256.0f, (float)n);
            pGraphics.line((float)n, 0.0f, (float)n, 256.0f);
        }
        pGraphics.endDraw();
        string = pApplet.dataPath("") + "/" + string;
        System.out.println(string);
        pGraphics.save(string);
    }

    public static void makeColorSchemes(PApplet pApplet) {
        if (palettes != null) {
            return;
        }
        PImage pImage = null;
        InputStream inputStream = pApplet.createInputRaw("user_gui_palette.png");
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            pImage = pApplet.loadImage("user_gui_palette.png");
            GMessenger.message(65794, null);
        } else {
            pImage = pApplet.loadImage("default_gui_palette.png");
        }
        palettes = new Color[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n = pImage.get(j * 16 + 8, i * 16 + 8);
                GCScheme.palettes[i][j] = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            }
        }
    }

    public static Color[] getJavaColor(int n) {
        n = Math.abs(n) % 16;
        return palettes[n];
    }

    public static void makeColorSchemes() {
        if (palettes != null) {
            return;
        }
        PImage pImage = new PImage(new ImageIcon(new GCScheme().getClass().getResource("/data/default_gui_palette.png")).getImage());
        palettes = new Color[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n = pImage.get(j * 16 + 8, i * 16 + 8);
                GCScheme.palettes[i][j] = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            }
        }
    }
}

