/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GIcon;
import g4p_controls.GTimer;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PImage;

public class GAnimIcon
extends GIcon {
    protected GTimer timer;
    protected Map<String, AnimClip> clips = new HashMap<String, AnimClip>();
    protected AnimClip anim_clip = null;

    protected GAnimIcon() {
    }

    public GAnimIcon(PApplet pApplet, String string, int n, int n2, int n3) {
        super(pApplet, string, n, n2);
        this.anim_clip = new AnimClip("ALL", 0, this.img.length - 1, n3);
        this.clips.put(this.anim_clip.id, this.anim_clip);
        this.timer = new GTimer(this.app, this, "advanceAnimationFrame", 10, n3);
    }

    public GAnimIcon(PApplet pApplet, PImage pImage, int n, int n2, int n3) {
        super(pApplet, pImage, n, n2);
        this.anim_clip = new AnimClip("ALL", 0, this.img.length - 1, n3);
        this.clips.put(this.anim_clip.id, this.anim_clip);
        this.timer = new GTimer(this.app, this, "advanceAnimationFrame", 10, n3);
    }

    @Override
    GAnimIcon me() {
        return this;
    }

    boolean hasClip(String string) {
        return this.clips.containsKey(string);
    }

    @Override
    public GAnimIcon copy() {
        GAnimIcon gAnimIcon = new GAnimIcon();
        gAnimIcon.app = this.app;
        gAnimIcon.img = this.img;
        gAnimIcon.width = this.width;
        gAnimIcon.height = this.height;
        gAnimIcon.nbrFrames = this.nbrFrames;
        gAnimIcon.clips = new HashMap<String, AnimClip>();
        for (String string : this.clips.keySet()) {
            gAnimIcon.clips.put(string, this.clips.get(string).copy());
        }
        gAnimIcon.anim_clip = gAnimIcon.clips.get(this.anim_clip.id);
        gAnimIcon.timer = new GTimer(this.app, gAnimIcon, "advanceAnimationFrame", 10, gAnimIcon.anim_clip.interval);
        return gAnimIcon;
    }

    public GAnimIcon storeAnim(String string, int n, int n2, int n3) {
        return this.storeAnim(string, n, n2, n3, 0);
    }

    public GAnimIcon storeAnim(String string, int n, int n2, int n3, int n4) {
        AnimClip animClip = new AnimClip(string, n, n2, n3, n4);
        this.clips.put(string, animClip);
        return this;
    }

    public GAnimIcon animate() {
        if (this.hasClip("ALL")) {
            this.animate("ALL");
        }
        return this;
    }

    public GAnimIcon animate(String string) {
        AnimClip animClip = this.clips.get(string);
        if (animClip != null) {
            this.timer.stop();
            this.anim_clip = animClip;
            this.currFrame = this.anim_clip.start;
            this.timer.setDelay(this.anim_clip.interval);
            this.timer.setNbrRepeats(this.anim_clip.size);
            this.timer.start(animClip.size);
        }
        return this;
    }

    public GAnimIcon setInterval(int n) {
        if (this.anim_clip != null) {
            this.anim_clip.interval = n;
            this.timer.setDelay(n);
        }
        return this;
    }

    public GAnimIcon setInterval(String string, int n) {
        AnimClip animClip = this.clips.get(string);
        if (animClip != null) {
            animClip.interval = n;
            if (animClip == this.anim_clip) {
                this.timer.setDelay(n);
            }
        }
        return this;
    }

    public GAnimIcon start() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
        return this;
    }

    public GAnimIcon stop() {
        this.timer.stop();
        return this;
    }

    @Override
    public GAnimIcon setFrame(int n) {
        if (!this.timer.isRunning()) {
            this.currFrame = Math.abs(n) % this.nbrFrames;
        }
        return this;
    }

    public void advanceAnimationFrame(GTimer gTimer) {
        int n = this.currFrame = this.currFrame == this.anim_clip.end ? this.anim_clip.start : this.currFrame + this.anim_clip.dir;
        if (this.owner != null) {
            this.owner.bufferInvalid = true;
        }
    }

    protected class AnimClip {
        String id;
        int start;
        int end;
        int interval;
        int dir;
        int nLoops;
        int size;

        AnimClip copy() {
            return new AnimClip(this.id, this.start, this.end, this.interval, this.nLoops);
        }

        public AnimClip(String string, int n, int n2, int n3) {
            this(string, n, n2, n3, 0);
        }

        public AnimClip(String string, int n, int n2, int n3, int n4) {
            n = Math.abs(n) % GAnimIcon.this.nbrFrames;
            n2 = Math.abs(n2) % GAnimIcon.this.nbrFrames;
            this.id = string;
            this.start = n;
            this.end = n2;
            this.interval = n3;
            this.nLoops = n4;
            this.dir = n2 == n ? 0 : (n2 - n > 0 ? 1 : -1);
            this.size = Math.abs(n2 - n) + 1;
            this.size = n4 <= 0 ? 0 : n4 * this.size - 1;
        }

        public String toString() {
            return this.id + "  [ " + this.start + " > " + this.end + "   step " + this.dir + "   interval " + this.interval + "ms ]";
        }
    }
}

