/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.fraktale;

import java.util.Vector;
import uibk.applets.fraktale.AppletFraktale;
import uibk.applets.fraktale.MyString;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MultiGraph2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.lang.Messages;

public class Fraktale {
    private final AppletFraktale main;
    protected MultiGraph2D graphflow = new MultiGraph2D();

    Fraktale(AppletFraktale main) {
        this.main = main;
        main.mathPanel2D.add(this.graphflow);
        main.mathPanel2D.getScene2d().axesequal(true);
    }

    public CoordinateRect2D paint(MyString wort, double p, double m, double winkel0, double faktor, CoordinateRect2D limitsIn) throws Exception {
        this.graphflow.clear();
        Graph2D graph = new Graph2D();
        this.graphflow.addGraph(graph);
        double x = 0.0;
        double y = 0.0;
        double winkel = winkel0;
        double laenge = 1.0 / faktor;
        graph.addPoint(x, y);
        Stack stack = new Stack();
        if (wort == null) {
            return null;
        }
        wort.initIterator();
        do {
            char zeichen = wort.getIterZeichen();
            switch (zeichen) {
                case 'f': {
                    graph.addPoint(x += (laenge *= faktor) * Math.cos(winkel), y += laenge * Math.sin(winkel));
                    MyString.checkMemory();
                    break;
                }
                case 'p': {
                    winkel += p;
                    break;
                }
                case 'm': {
                    winkel -= m;
                    break;
                }
                case 'e': {
                    if (stack.getAnz() == 0) {
                        throw new Exception(Messages.getString("uibk.applets.fraktale.messages", "Fraktale.1"));
                    }
                    laenge = stack.getLaenge();
                    winkel = stack.getWinkel();
                    graph = stack.getGraph();
                    x = graph.getLastPoint().x;
                    y = graph.getLastPoint().y;
                    stack.removeLastElement();
                    break;
                }
                case 'v': {
                    stack.addElement(winkel, graph, laenge);
                    MyString.checkMemory();
                    graph = new Graph2D();
                    MyString.checkMemory();
                    this.graphflow.addGraph(graph);
                    MyString.checkMemory();
                    graph.addPoint(x, y);
                    MyString.checkMemory();
                    break;
                }
            }
            MyString.checkMemory();
        } while (wort.next());
        CoordinateRect2D limits = this.graphflow.getLimits();
        if (limitsIn != null) {
            if (!limitsIn.contains(limits)) {
                limits = limits.combine(limitsIn);
                this.setLimits(limits);
            } else {
                limits = limitsIn;
            }
        } else {
            this.setLimits(limits);
        }
        this.main.mathPanel2D.repaint();
        return limits;
    }

    private void setLimits(CoordinateRect2D limits) {
        if (limits.getXRange() < 0.1) {
            limits.xmax += 0.05;
            limits.xmin -= 0.05;
        }
        if (limits.getYRange() < 0.1) {
            limits.ymax += 0.05;
            limits.ymin -= 0.05;
        }
        this.main.mathPanel2D.getScene2d().setLimits(limits);
    }

    public void loeschen() {
        this.graphflow.clear();
        this.main.mathPanel2D.repaint();
    }

    private class Stack {
        private Vector v = new Vector();

        private Stack() {
        }

        public void addElement(double winkel, Graph2D graph, double laenge) throws Exception {
            StackElement element = new StackElement(winkel, graph, laenge);
            MyString.checkMemory();
            this.v.add(element);
        }

        public void setWinkel(double winkel) {
            StackElement element = (StackElement)this.v.lastElement();
            element.winkel = winkel;
        }

        public void removeLastElement() {
            this.v.remove(this.v.lastElement());
        }

        public double getWinkel() {
            return ((StackElement)this.v.lastElement()).winkel;
        }

        public Graph2D getGraph() {
            return ((StackElement)this.v.lastElement()).graph;
        }

        public double getLaenge() {
            return ((StackElement)this.v.lastElement()).laenge;
        }

        public int getAnz() {
            return this.v.size();
        }

        private class StackElement {
            public double winkel;
            public Graph2D graph;
            public double laenge;

            StackElement(double winkel, Graph2D graph, double laenge) {
                this.winkel = winkel;
                this.graph = graph;
                this.laenge = laenge;
            }
        }
    }
}

