/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.base;

import uibk.mtk.lang.InputException;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.numberPanel.RationalNumber;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.TextField;

public class RationalNumberTextField
extends TextField {
    private Double min;
    private String name;
    private Double max;
    private RationalNumber value;
    private String oldinput = null;

    public RationalNumberTextField(int cols, Double min, Double max, String name) {
        super(cols);
        this.min = min;
        this.max = max;
        this.name = name;
    }

    public boolean hasChanged() {
        return this.oldinput == null || !this.getText().equals(this.oldinput);
    }

    public void evaluateInput() throws InputException, NotANumberException {
        if (this.hasChanged()) {
            this.value = Misc.parseRationalNumberValue(this.getText(), this.name, this.min, this.max);
            this.oldinput = this.getText();
        }
    }

    public RationalNumber getValue() throws InputException, NotANumberException {
        this.evaluateInput();
        return this.value;
    }
}

