/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.polynom;

import java.math.BigInteger;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.polynom.Variable;
import uibk.mtk.math.polynom.Variables;

public class Monom {
    private static final String BUNDLE_NAME = "uibk.mtk.math.polynom.messages";
    final Variables variables;
    BigInteger coefficient;

    public Monom(String var, BigInteger coefficient) {
        this.variables = new Variables(var);
        this.coefficient = coefficient;
    }

    public Monom(Variable var, BigInteger coefficient) {
        this.variables = new Variables(var);
        this.coefficient = coefficient;
    }

    public Monom(Variables variables, BigInteger coefficient) {
        this.variables = variables;
        this.coefficient = coefficient;
    }

    public Variables getVars() {
        return this.variables;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    public static Monom getZERO() {
        return new Monom(Variables.ONE, BigInteger.ZERO);
    }

    public void add(Monom c) throws PolynomException {
        if (!c.variables.equals(this.variables)) {
            throw new PolynomException(Messages.getString(BUNDLE_NAME, "Coefficient.0"), ExceptionLevel.ERROR);
        }
        this.coefficient = this.coefficient.add(c.coefficient);
    }

    public void subtract(Monom c) throws PolynomException {
        if (!c.variables.equals(this.variables)) {
            throw new PolynomException(Messages.getString(BUNDLE_NAME, "Coefficient.0"), ExceptionLevel.ERROR);
        }
        this.coefficient = this.coefficient.subtract(c.coefficient);
    }

    public void multiply(BigInteger i) {
        this.coefficient = this.coefficient.multiply(i);
    }

    public void multiply(Monom c) throws PolynomException {
        this.multiply(c.coefficient);
        for (Variable var2 : c.variables) {
            if (this.variables.contains(var2)) {
                this.variables.incrementVariable(var2);
                continue;
            }
            this.variables.addVariable(var2);
        }
    }

    public void divide(BigInteger i) {
        this.coefficient = this.coefficient.divide(i);
    }

    public String toString() {
        String ret = "";
        if (this.coefficient.equals(BigInteger.valueOf(0L))) {
            return ret;
        }
        if (!this.coefficient.equals(BigInteger.ONE)) {
            ret = this.coefficient.equals(BigInteger.valueOf(-1L)) && !this.variables.equals(Variables.ONE) ? String.valueOf(ret) + "-" : String.valueOf(ret) + this.coefficient.toString();
        }
        if ((ret = String.valueOf(ret) + this.variables).length() == 0) {
            ret = String.valueOf(ret) + "1";
        }
        return ret;
    }

    public Monom clone() {
        return new Monom(this.variables.clone(), this.coefficient.multiply(new BigInteger("1")));
    }
}

