/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import java.awt.Component;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.IrrationalNumber;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;
import uibk.mtk.math.numberPanel.RationalNumber;

public class MatrixPanelQR
extends MatrixPanel {
    static final String BUNDLE_NAME = "uibk.mtk.math.numberPanel.messages";
    public static final int HOUSHOLDER = 1;
    public static final int GIVENS = 2;
    private MatrixPanel Q = null;
    private MatrixPanel P = null;
    private int qrStepIndex = 0;
    private boolean isPivoting;
    private int calcType = 1;

    public MatrixPanelQR(MyNumber[][] data, boolean isPivotin, int precision, int calcType) throws ExtendedException {
        super(data);
        if (data != null && data.length < data[0].length) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.1"), ExceptionLevel.ERROR);
        }
        this.isPivoting = isPivotin;
        this.calcType = calcType;
    }

    public MatrixPanelQR(int rowDimension, int columnDimension, boolean isPivotin, int precision, int calcType) throws ExtendedException {
        super(rowDimension, columnDimension);
        if (rowDimension < columnDimension) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.1"), ExceptionLevel.ERROR);
        }
        this.isPivoting = isPivotin;
        this.calcType = calcType;
    }

    protected void intAlgorithm() throws ExtendedException {
        super.intAlgorithm();
        this.qrStepIndex = 0;
        this.indexPivot = 0;
    }

    public void setValueAt(int row, int column, MyNumber r) throws ExtendedException {
        MyNumber n = r;
        if (r instanceof RationalNumber) {
            n = new IrrationalNumber(r.getDoubleValue(), r.getView(), (Component)this, r.getPrecision());
        }
        super.setValueAt(row, column, n);
        this.setMatrixToIdentity(this.Q);
        this.setMatrixToIdentity(this.P);
    }

    public int qrStep() throws ExtendedException {
        if (this.calcType == 1) {
            MatrixPanel H;
            if (this.qrStepIndex == 0) {
                MatrixPanelQR tmp = this.clone();
                tmp.isPivoting = true;
                while (!tmp.isQR()) {
                    tmp.pivoting();
                    H = tmp.getHousholder();
                    tmp.applyHouseholder(H);
                }
                IrrationalNumber.setEPS(tmp.getVauleAt(0, 0).getDoubleValue() * 1.0E-15);
            }
            int indexMaxNorm = this.pivoting();
            H = this.getHousholder();
            this.applyHouseholder(H);
            return indexMaxNorm;
        }
        int[] ij = this.getNextIndecesForGivensRotation();
        MatrixPanel G = this.getGivens(ij[0], ij[0]);
        this.applyGivens(G);
        return ij[0];
    }

    public int[] getNextIndecesForGivensRotation() throws ExtendedException {
        if (this.isQR()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.3"), ExceptionLevel.INFO);
        }
        int[] ret = new int[2];
        boolean isZero = false;
        ret[1] = 0;
        while (ret[1] < this.columnDim) {
            ret[0] = ret[1] + 1;
            while (ret[0] < this.rowDim) {
                if (!this.getVauleAt(ret[0], ret[1]).isZero()) {
                    isZero = true;
                    break;
                }
                ret[0] = ret[0] + 1;
            }
            if (isZero) break;
            ret[1] = ret[1] + 1;
        }
        return ret;
    }

    public void applyHouseholder(MatrixPanel H) throws ExtendedException {
        this.mulLeft(H);
        this.getQ().mul(H);
        int i = this.qrStepIndex + 1;
        while (i < this.rowDim) {
            IrrationalNumber n = new IrrationalNumber(0.0, 2, (Component)this, this.data[i][this.qrStepIndex].getPrecision());
            this.setValueAtIntern(i, this.qrStepIndex, n);
            ++i;
        }
        ++this.qrStepIndex;
        ++this.indexPivot;
    }

    public MatrixPanel getHousholder() throws ExtendedException {
        if (this.calcType != 1) {
            throw new MatrixException("Interner Fehler: Unf\u00fcltiger calcType", ExceptionLevel.ERROR);
        }
        if (this.isQR()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.3"), ExceptionLevel.ERROR);
        }
        MatrixPanel H = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.precision, IrrationalNumber.class);
        double[] v = new double[this.rowDim - this.qrStepIndex];
        double norm2 = 0.0;
        int i = this.qrStepIndex;
        while (i < this.rowDim) {
            v[i - this.qrStepIndex] = this.getVauleAt(i, this.qrStepIndex).getDoubleValue();
            norm2 += v[i - this.qrStepIndex] * v[i - this.qrStepIndex];
            ++i;
        }
        if (this.isZero(norm2 = Math.sqrt(norm2))) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.2"), ExceptionLevel.ERROR);
        }
        double sgn = this.getVauleAt(this.qrStepIndex, this.qrStepIndex).getDoubleValue() == 0.0 ? 1.0 : Math.signum(this.getVauleAt(this.qrStepIndex, this.qrStepIndex).getDoubleValue());
        double alpha = -sgn * norm2;
        v[0] = v[0] - alpha;
        norm2 = 0.0;
        int i2 = 0;
        while (i2 < this.rowDim - this.qrStepIndex) {
            norm2 += v[i2] * v[i2];
            ++i2;
        }
        i2 = this.qrStepIndex;
        while (i2 < this.rowDim) {
            int j = this.qrStepIndex;
            while (j < this.rowDim) {
                MyNumber n = H.getVauleAt(i2, j);
                n = n.add(new IrrationalNumber(-2.0 * v[i2 - this.qrStepIndex] * v[j - this.qrStepIndex] / norm2, this.view, (Component)this, n.getPrecision()));
                H.setValueAtIntern(i2, j, n);
                ++j;
            }
            ++i2;
        }
        return H;
    }

    public MatrixPanel getGivens(int k, int l) throws ExtendedException {
        if (this.calcType != 2) {
            throw new MatrixException("Interner Fehler: Unf\u00fcltiger calcType", ExceptionLevel.ERROR);
        }
        if (this.isQR()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.3"), ExceptionLevel.ERROR);
        }
        this.checkIndexForGivens(k, l);
        MatrixPanel G = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.precision, IrrationalNumber.class);
        double ajj = this.getVauleAt(l, l).getDoubleValue();
        double aij = this.getVauleAt(k, l).getDoubleValue();
        if (this.isZero(ajj * ajj + aij * aij)) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.3"), ExceptionLevel.ERROR);
        }
        double sign = Math.signum(ajj) != 0.0 ? Math.signum(ajj) : 1.0;
        double rho = sign * Math.sqrt(ajj * ajj + aij * aij);
        double c = ajj / rho;
        double s = -aij / rho;
        G.setValueAt(k, k, new IrrationalNumber(c, this.view, (Component)this, this.precision));
        G.setValueAt(l, l, new IrrationalNumber(c, this.view, (Component)this, this.precision));
        G.setValueAt(k, l, new IrrationalNumber(s, this.view, (Component)this, this.precision));
        G.setValueAt(l, k, new IrrationalNumber(-s, this.view, (Component)this, this.precision));
        return G;
    }

    public void checkIndexForGivens(int k, int l) throws ExtendedException {
        if (k < l + 1 || k > this.rowDim || l < 0 || l > this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.5"), ExceptionLevel.INFO);
        }
        if (this.getVauleAt(k, l).isZero()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.4"), ExceptionLevel.INFO);
        }
    }

    public void applyGivens(MatrixPanel G) throws ExtendedException {
        this.mulLeft(G);
        this.getQ().mul(MatrixUtil.transpose(G));
    }

    public int getPivot() throws ExtendedException {
        if (this.isQR()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.3"), ExceptionLevel.ERROR);
        }
        int indexMaxNorm = this.qrStepIndex;
        if (this.isPivoting) {
            double max = -1.0;
            int i = this.qrStepIndex;
            while (i < this.columnDim) {
                double norm2 = 0.0;
                int j = this.qrStepIndex;
                while (j < this.rowDim) {
                    norm2 += this.getVauleAt(j, i).getDoubleValue() * this.getVauleAt(j, i).getDoubleValue();
                    ++j;
                }
                if (norm2 > max) {
                    max = norm2;
                    indexMaxNorm = i;
                }
                ++i;
            }
        }
        return indexMaxNorm;
    }

    public int pivoting() throws ExtendedException {
        if (this.isQR()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "MatrixPanelQR.3"), ExceptionLevel.INFO);
        }
        int indexMaxNorm = this.qrStepIndex;
        if (this.isPivoting) {
            indexMaxNorm = this.getPivot();
            this.getP().changeRows(this.qrStepIndex, indexMaxNorm);
            this.changeColumnsIntern(this.qrStepIndex, indexMaxNorm);
        }
        return indexMaxNorm;
    }

    public boolean isQR() throws ExtendedException {
        if (this.calcType == 1) {
            if (this.qrStepIndex >= this.columnDim) {
                return true;
            }
            int i = this.qrStepIndex + 1;
            while (i < this.rowDim) {
                int j = this.qrStepIndex;
                while (j < this.columnDim) {
                    if (!this.isZero(this.data[i][j].getDoubleValue())) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        int j = 0;
        while (j < this.columnDim) {
            int i = j + 1;
            while (i < this.rowDim) {
                if (!this.isZero(this.data[i][j].getDoubleValue())) {
                    return false;
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    public int getRank() throws ExtendedException {
        int rank = 0;
        if (this.isQR()) {
            int j = 0;
            while (j < this.rowDim) {
                int i = j;
                while (i < this.columnDim) {
                    if (!this.getVauleAt(j, i).isZero()) {
                        ++rank;
                        break;
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            MatrixPanelQR qr = this.clone();
            qr.calcType = 1;
            qr.isPivoting = true;
            while (!qr.isQR()) {
                qr.qrStep();
            }
            int j = 0;
            while (j < qr.rowDim) {
                int i = j;
                while (i < qr.columnDim) {
                    if (!qr.getVauleAt(j, i).isZero()) {
                        ++rank;
                        break;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return rank;
    }

    private boolean isZero(double val) {
        return val > -IrrationalNumber.getEPS() && val < IrrationalNumber.getEPS();
    }

    public MatrixPanel qrAlgorithmus() throws ExtendedException {
        while (!this.isQR()) {
            this.qrStep();
        }
        return this;
    }

    public MatrixPanel getQ() throws ExtendedException {
        if (this.Q == null) {
            this.Q = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.precision, this.getVauleAt(0, 0).getClass());
        }
        return this.Q;
    }

    public MatrixPanel getP() throws ExtendedException {
        if (!this.isPivoting) {
            this.P = null;
            return null;
        }
        if (this.P == null) {
            this.P = MatrixUtil.getIdentityMatrix(this.columnDim, this.columnDim, this.view, this, this.precision, this.getVauleAt(0, 0).getClass());
        }
        return this.P;
    }

    public MatrixPanelQR clone() {
        try {
            int j;
            int precision = this.data[0][0].getPrecision();
            MyNumber[][] data = new MyNumber[this.rowDim][this.columnDim];
            int i = 0;
            while (i < this.rowDim) {
                int j2 = 0;
                while (j2 < this.columnDim) {
                    data[i][j2] = this.getVauleAt(i, j2).clone();
                    ++j2;
                }
                ++i;
            }
            MatrixPanelQR r = new MatrixPanelQR(data, this.isPivoting, precision, this.calcType);
            r.indexPivot = this.indexPivot;
            if (this.Q != null) {
                MatrixPanel p;
                data = new MyNumber[this.Q.rowDim][this.Q.columnDim];
                int i2 = 0;
                while (i2 < this.Q.rowDim) {
                    j = 0;
                    while (j < this.Q.columnDim) {
                        data[i2][j] = this.Q.getVauleAt(i2, j).clone();
                        ++j;
                    }
                    ++i2;
                }
                r.Q = p = new MatrixPanel(data);
            }
            if (this.P != null) {
                MatrixPanel p;
                data = new MyNumber[this.P.rowDim][this.P.columnDim];
                int i3 = 0;
                while (i3 < this.P.rowDim) {
                    j = 0;
                    while (j < this.P.columnDim) {
                        data[i3][j] = this.P.getVauleAt(i3, j).clone();
                        ++j;
                    }
                    ++i3;
                }
                r.P = p = new MatrixPanel(data);
            }
            if (this.b != null) {
                MatrixPanel bneu;
                data = new MyNumber[this.b.rowDim][this.b.columnDim];
                int i4 = 0;
                while (i4 < this.b.rowDim) {
                    j = 0;
                    while (j < this.b.columnDim) {
                        data[i4][j] = this.b.getVauleAt(i4, j).clone();
                        ++j;
                    }
                    ++i4;
                }
                r.b = bneu = new MatrixPanel(data);
            }
            if (this.x != null) {
                MatrixPanel xNeu;
                data = new MyNumber[this.x.rowDim][this.x.columnDim];
                int i5 = 0;
                while (i5 < this.x.rowDim) {
                    j = 0;
                    while (j < this.x.columnDim) {
                        data[i5][j] = this.x.getVauleAt(i5, j).clone();
                        ++j;
                    }
                    ++i5;
                }
                r.x = xNeu = new MatrixPanel(data);
            }
            r.setPrecision(precision);
            r.qrStepIndex = this.qrStepIndex;
            r.nullRows = this.nullRows;
            r.isSolved = this.isSolved;
            return r;
        }
        catch (ExtendedException e) {
            return null;
        }
    }

    public MatrixPanel initXMatrix(MatrixPanel b) throws ExtendedException {
        return super.initXMatrix(b);
    }

    public int getQRStepIndex() {
        return this.qrStepIndex;
    }

    public void setPrecision(int i) {
        super.setPrecision(i);
        if (this.Q != null) {
            this.Q.setPrecision(i);
        }
        if (this.P != null) {
            this.P.setPrecision(i);
        }
    }
}

