/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

public class Complex {
    private double real;
    private double imag;

    public Complex() {
    }

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Complex(Complex z) {
        this.real = z.real;
        this.imag = z.imag;
    }

    public Complex add(Complex z) {
        return new Complex(this.real + z.real, this.imag + z.imag);
    }

    public Complex sub(Complex z) {
        return new Complex(this.real - z.real, this.imag - z.imag);
    }

    public Complex times(Complex z) {
        return new Complex(this.real * z.real - this.imag * z.imag, this.real * z.imag + this.imag * z.real);
    }

    public Complex times(double s) {
        return new Complex(this.real * s, this.imag * s);
    }

    public Complex div(Complex z) {
        return Complex.pdiv(this.real, this.imag, z.real, z.imag);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.real) || Double.isInfinite(this.imag);
    }

    public boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imag);
    }

    public double abs() {
        if (this.isZero()) {
            return 0.0;
        }
        if (Math.abs(this.real) > Math.abs(this.imag)) {
            double d = Math.abs(this.imag / this.real);
            return Math.abs(this.real) * Math.sqrt(1.0 + d * d);
        }
        double d = Math.abs(this.real / this.imag);
        return Math.abs(this.imag) * Math.sqrt(1.0 + d * d);
    }

    public Complex exp() {
        double s = Math.exp(this.real);
        return new Complex(s * Math.cos(this.imag), s * Math.sin(this.imag));
    }

    public Complex conjugate() {
        this.imag = -this.imag;
        return new Complex(this.real, -this.imag);
    }

    public String toString() {
        if (this.imag != 0.0) {
            String sign = this.imag < 0.0 ? "" : "+";
            return String.valueOf(String.valueOf(this.real)) + sign + String.valueOf(this.imag) + "i";
        }
        return String.valueOf(this.real);
    }

    public double getImag() {
        return this.imag;
    }

    public double getReal() {
        return this.real;
    }

    public Complex sqrt() {
        Complex ret = new Complex(this);
        Complex.psqrt(ret);
        return ret;
    }

    public Complex sin() {
        double e1 = Math.exp(-this.imag);
        double e2 = Math.exp(this.imag);
        double s1 = e1 + e2;
        double s2 = e1 - e2;
        return new Complex(0.5 * Math.sin(this.real) * s1, -0.5 * Math.cos(this.real) * s2);
    }

    public Complex cos() {
        double e1 = Math.exp(-this.imag);
        double e2 = Math.exp(this.imag);
        double s1 = e1 + e2;
        double s2 = e1 - e2;
        return new Complex(0.5 * Math.cos(this.real) * s1, 0.5 * Math.sin(this.real) * s2);
    }

    public Complex tan() {
        double e1 = Math.exp(-this.imag);
        double e2 = Math.exp(this.imag);
        double s1 = e1 + e2;
        double s2 = e1 - e2;
        double sinreal = 0.5 * Math.sin(this.real) * s1;
        double sinimag = -0.5 * Math.cos(this.real) * s2;
        double cosreal = 0.5 * Math.cos(this.real) * s1;
        double cosimag = 0.5 * Math.sin(this.real) * s2;
        return Complex.pdiv(sinreal, sinimag, cosreal, cosimag);
    }

    public double arg() {
        return Math.atan2(this.imag, this.real);
    }

    public Complex log() {
        return new Complex(Math.log(this.abs()), this.arg());
    }

    private static Complex pdiv(double a, double b, double c, double d) {
        if (Math.abs(c) >= Math.abs(d)) {
            double diff = d / c;
            double denom = c + d * (d / c);
            return new Complex((a + b * diff) / denom, (b - a * diff) / denom);
        }
        double diff = c / d;
        double denom = c * (c / d) + d;
        return new Complex((a * diff + b) / denom, (b * diff - a) / denom);
    }

    private static void psqrt(Complex z) {
        double w;
        double absimag;
        double real = z.real;
        double imag = z.imag;
        if (real == 0.0 && imag == 0.0) {
            z.real = 0.0;
            z.imag = 0.0;
            return;
        }
        double absreal = Math.abs(real);
        if (absreal >= (absimag = Math.abs(imag))) {
            double d = absimag / absreal;
            w = Math.sqrt(absreal) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d * d)));
        } else {
            double d = absreal / absimag;
            w = Math.sqrt(absimag) * Math.sqrt(0.5 * (d + Math.sqrt(1.0 + d * d)));
        }
        if (w == 0.0) {
            z.real = 0.0;
            z.imag = 0.0;
            return;
        }
        if (real >= 0.0) {
            z.real = w;
            z.imag = 0.5 * imag / w;
        } else if (imag >= 0.0) {
            z.real = 0.5 * Math.abs(imag) / w;
            z.imag = w;
        } else {
            z.real = 0.5 * Math.abs(imag) / w;
            z.imag = -w;
        }
    }

    public Complex acos() {
        double re = 1.0 - (this.real * this.real - this.imag * this.imag);
        double im = -(this.real * this.imag + this.imag * this.real);
        Complex ret = new Complex(re, im);
        Complex.psqrt(ret);
        re = -ret.imag;
        im = ret.real;
        ret.real = this.real + re;
        ret.imag = this.imag + im;
        re = Math.log(ret.abs());
        ret.real = im = ret.arg();
        ret.imag = -re;
        return ret;
    }

    public Complex asin() {
        double re = 1.0 - (this.real * this.real - this.imag * this.imag);
        double im = -(this.real * this.imag + this.imag * this.real);
        Complex ret = new Complex(re, im);
        Complex.psqrt(ret);
        ret.real = -this.imag + ret.real;
        ret.imag = this.real + ret.imag;
        re = Math.log(ret.abs());
        ret.real = im = ret.arg();
        ret.imag = -re;
        return ret;
    }

    public Complex atan() {
        Complex ret = Complex.pdiv(-this.real, 1.0 - this.imag, this.real, 1.0 + this.imag);
        double re = Math.log(ret.abs());
        double im = ret.arg();
        ret.real = im / 2.0;
        ret.imag = re / 2.0;
        return ret;
    }

    public Complex neg() {
        return new Complex(-this.real, -this.imag);
    }

    public void set(Complex z) {
        this.real = z.real;
        this.imag = z.imag;
    }

    public void set(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public boolean isZero() {
        return this.real == 0.0 && this.imag == 0.0;
    }

    public Complex pow(Complex exponent) {
        if (this.imag == 0.0 && exponent.getImag() == 0.0) {
            return new Complex(Math.pow(this.real, exponent.getReal()), 0.0);
        }
        double re = Math.log(this.abs());
        double im = this.arg();
        double re1 = re * exponent.real - im * exponent.imag;
        double im1 = re * exponent.imag + im * exponent.real;
        double s = Math.exp(re1);
        return new Complex(s * Math.cos(im1), s * Math.sin(im1));
    }

    public Object clone() {
        return new Complex(this.real, this.imag);
    }
}

