/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.choleskyAlgorithmus;

import java.awt.Color;
import java.awt.Component;
import uibk.applets.choleskyAlgorithmus.AppletCholeskyAlgorithmus;
import uibk.applets.choleskyAlgorithmus.PanelControl;
import uibk.applets.choleskyAlgorithmus.PanelMain;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixPanelCholesky;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;
import uibk.mtk.math.numberPanel.RationalNumber;
import uibk.mtk.swing.base.MPanel;

public class PanelMainRationalCholesky
extends PanelMain {
    private int index = 0;

    public PanelMainRationalCholesky(AppletCholeskyAlgorithmus main, PanelControl panelControl) {
        super(main, panelControl);
    }

    public synchronized void initGLS(boolean permutX) throws ExtendedException {
        this.initPanels();
        MPanel[] mPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            MPanel p = mPanelArray[n2];
            p.removeAll();
            ++n2;
        }
        if (this.A != null) {
            this.A.setFont(AppletCholeskyAlgorithmus.FONT);
            this.A.addMouseListener(this.mouseEvents);
            this.A.addMouseMotionListener(this.mouseEvents);
            this.A.setBackground(AppletCholeskyAlgorithmus.COLOR_EDIT);
            this.A.setBorderByIndex(this.A.getIndexRow() + 1, this.A.getIndexColumn(), Color.BLACK);
            this.panels[2].add(this.A);
            this.A.getLT().setFont(AppletCholeskyAlgorithmus.FONT);
            this.A.getLT().setBackground(AppletCholeskyAlgorithmus.COLOR_NO_EDIT);
            this.A.getL().setFont(AppletCholeskyAlgorithmus.FONT);
            this.A.getL().setBackground(AppletCholeskyAlgorithmus.COLOR_NO_EDIT);
            this.panels[0].add(this.A.getL());
        }
        this.setView(1);
        this.main.setMainPanel();
    }

    protected void solveStep() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        if (!MatrixUtil.isSymmetric(this.A)) {
            throw new MatrixException("Matrix nicht symmetrisch", ExceptionLevel.ERROR);
        }
        if (this.A.getIndexRow() < this.A.getColumnDim() - 1 || this.A.getIndexRow() < this.A.getColumnDim() - 1) {
            this.panels[2].add(this.A);
            if (this.A.getVauleAt(this.A.getIndexColumn(), this.A.getIndexColumn()).isZero()) {
                throw new MatrixException("Pivotelement ist 0", ExceptionLevel.ERROR);
            }
            this.addSteppToHistory(this.index, this.index, AppletCholeskyAlgorithmus.COLOR_SOLVE);
            this.solveStep(this.A);
            this.initGLS(false);
        } else {
            if (this.A.getVauleAt(this.A.getRowDim() - 1, this.A.getColumnDim() - 1).isZero()) {
                throw new MatrixException("Matrix singul\u00e4r", ExceptionLevel.ERROR);
            }
            this.A.setSolved(true);
        }
        ((PanelMain.History)this.history.lastElement()).A = this.A;
        ((PanelMain.History)this.history.lastElement()).index = this.index;
    }

    private void solveStep(MatrixPanelCholesky A) throws ExtendedException {
        int indexRow = A.getIndexRow() + 1;
        int indexColumn = A.getIndexColumn();
        if (A.getVauleAt(indexColumn, indexColumn).isZero()) {
            throw new MatrixException("Pivotelement ist 0", ExceptionLevel.ERROR);
        }
        MyNumber r = A.getVauleAt(indexRow, indexColumn).div(A.getVauleAt(indexColumn, indexColumn));
        A.getL().setValueAtIntern(indexRow, indexColumn, r.clone());
        A.getLT().setValueAtIntern(indexColumn, indexRow, r);
        MatrixPanel temp = MatrixUtil.getIdentityMatrix(A.getColumnDim(), A.getRowDim(), A.getView(), this.main, A.getVauleAt(0, 0).getClass());
        temp.setValueAt(indexColumn, indexRow, r.clone().mul(new RationalNumber(-1L, 1L, temp.getView(), (Component)this.main)));
        MatrixPanel temp2 = MatrixUtil.getIdentityMatrix(A.getColumnDim(), A.getRowDim(), A.getView(), this.main, A.getVauleAt(0, 0).getClass());
        temp2.setValueAt(indexRow, indexColumn, r.clone().mul(new RationalNumber(-1L, 1L, temp.getView(), (Component)this.A)));
        temp.mulLeft(A);
        temp.mulLeft(temp2);
        System.out.println(temp);
        int i = 0;
        while (i < A.getColumnDim()) {
            int j = 0;
            while (j < A.getRowDim()) {
                A.setValueAtIntern(j, i, temp.getVauleAt(j, i));
                ++j;
            }
            ++i;
        }
        if (indexRow + 1 == A.getColumnDim()) {
            A.setIndexColumn(indexColumn + 1);
            A.setIndexRow(indexColumn + 1);
        } else {
            A.setIndexRow(indexRow);
        }
        ++this.index;
    }

    protected void newGLSImpl() {
        this.index = 0;
    }

    protected void removeStepFromHistoryImpl() {
        this.index = ((PanelMain.History)this.history.lastElement()).index;
    }

    protected void addSteppToHistory() {
        ((PanelMain.History)this.history.lastElement()).index = this.index;
    }

    public void setBorder() {
        this.A.setBorderByIndex(this.A.getIndexRow() + 1, this.A.getIndexColumn(), Color.BLACK);
    }
}

