/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.swing.Messages;
import uibk.mtk.swing.base.ButtonNoFocus;
import uibk.mtk.swing.base.TitledPanel;

public class PanelEnlargeCoords2D
extends TitledPanel
implements ActionListener {
    ButtonNoFocus buttonUp;
    ButtonNoFocus buttonDown;
    ButtonNoFocus buttonLeft;
    ButtonNoFocus buttonRight;
    MathPanel2D mathpanel2d;
    static final double SCALEFACTOR = 0.1;

    public PanelEnlargeCoords2D(MathPanel2D mathpanel2d) {
        super(Messages.getString("PanelEnlargeCoords2D.0"));
        this.mathpanel2d = mathpanel2d;
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 110));
        URL urlIconDown = this.getClass().getResource("res/arrowdown.gif");
        URL urlIconUp = this.getClass().getResource("res/arrowup.gif");
        URL urlIconLeft = this.getClass().getResource("res/arrowleft.gif");
        URL urlIconRight = this.getClass().getResource("res/arrowright.gif");
        this.buttonDown = new ButtonNoFocus(new ImageIcon(urlIconDown), Messages.getString("PanelEnlargeCoords2D.1"), this, Messages.getString("PanelEnlargeCoords2D.6"));
        this.buttonUp = new ButtonNoFocus(new ImageIcon(urlIconUp), "up", this, Messages.getString("PanelEnlargeCoords2D.8"));
        this.buttonLeft = new ButtonNoFocus(new ImageIcon(urlIconLeft), "left", this, Messages.getString("PanelEnlargeCoords2D.10"));
        this.buttonRight = new ButtonNoFocus(new ImageIcon(urlIconRight), "right", this, Messages.getString("PanelEnlargeCoords2D.12"));
        this.add((Component)this.buttonUp, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 14, 5, 0), 0, 0));
        this.add((Component)this.buttonLeft, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.buttonRight, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.buttonDown, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 14, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        CoordinateRect2D coordrect;
        if (ev.getActionCommand().equals("down")) {
            coordrect = this.mathpanel2d.getScene2d().getOriginalLimits();
            coordrect.ymin -= Math.abs(coordrect.ymax - coordrect.ymin) * 0.1;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (ev.getActionCommand().equals("up")) {
            coordrect = this.mathpanel2d.getScene2d().getOriginalLimits();
            coordrect.ymax += Math.abs(coordrect.ymax - coordrect.ymin) * 0.1;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (ev.getActionCommand().equals("left")) {
            coordrect = this.mathpanel2d.getScene2d().getOriginalLimits();
            coordrect.xmin -= Math.abs(coordrect.xmax - coordrect.xmin) * 0.1;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (ev.getActionCommand().equals("right")) {
            coordrect = this.mathpanel2d.getScene2d().getOriginalLimits();
            coordrect.xmax += Math.abs(coordrect.xmax - coordrect.xmin) * 0.1;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        this.mathpanel2d.repaint();
    }
}

