/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import uibk.mtk.draw2d.objects.MathArrow2D;
import uibk.mtk.geom.Punkt2D;

public class FixedArrow2D
extends MathArrow2D {
    Punkt2D dir = new Punkt2D();
    double length;

    public FixedArrow2D() {
        this.length = 0.0;
    }

    public FixedArrow2D(Punkt2D base, Punkt2D dir, double length) {
        this.base.setLocation(base);
        this.dir.setLocation(dir);
        this.length = length;
    }

    @Override
    public void setBase(Punkt2D base) {
        this.base.setLocation(base);
    }

    public void setDirection(Punkt2D dir) {
        this.dir.setLocation(dir);
    }

    public void setLength(double length) {
        this.length = length;
    }

    @Override
    public void prepaintcompute() {
        this.basepix = this.scene2d.project(this.base);
        this.dir.normalize();
        if (Double.isNaN(this.dir.x) || Double.isInfinite(this.dir.x) || Double.isNaN(this.dir.y) || Double.isInfinite(this.dir.y) || this.dir.x == 0.0 && this.dir.y == 0.0) {
            this.draw = false;
        }
        double scale = Math.max(this.scene2d.getXRange(), this.scene2d.getYRange()) / 10.0;
        this.dir.scaleself(scale);
        Punkt2D zero = this.scene2d.projectdouble(new Punkt2D(0.0, 0.0));
        Punkt2D dirPix = this.scene2d.projectdouble(this.dir).sub(zero);
        dirPix.normalize();
        if (Double.isNaN(dirPix.x) || Double.isInfinite(dirPix.x) || Double.isNaN(dirPix.y) || Double.isInfinite(dirPix.y) || dirPix.x == 0.0 && dirPix.y == 0.0) {
            this.draw = false;
            return;
        }
        this.headpix.x = (int)((double)this.basepix.x + dirPix.x * this.length);
        this.headpix.y = (int)((double)this.basepix.y + dirPix.y * this.length);
        Punkt2D dirnormal = new Punkt2D(-dirPix.y, dirPix.x);
        this.leftwingpix.x = (int)((double)this.headpix.x - 6.0 * dirPix.x + 3.0 * dirnormal.x);
        this.leftwingpix.y = (int)((double)this.headpix.y - 6.0 * dirPix.y + 3.0 * dirnormal.y);
        this.rightwingpix.x = (int)((double)this.headpix.x - 6.0 * dirPix.x - 3.0 * dirnormal.x);
        this.rightwingpix.y = (int)((double)this.headpix.y - 6.0 * dirPix.y - 3.0 * dirnormal.y);
        this.draw = true;
    }
}

