/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.parametriccurve2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.parametriccurve2d.AppletParametricCurve2D;
import uibk.applets.parametriccurve2d.Messages;
import uibk.mtk.draw2d.objects.Zweibein;
import uibk.mtk.geom.Vector2D;
import uibk.mtk.math.Interval;
import uibk.mtk.swing.base.DoubleSlider;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.text.Formatter;

class PanelZweibein
extends TitledPanel
implements ActionListener {
    AppletParametricCurve2D main;
    ButtonGroup groupZweibeinOpt = new ButtonGroup();
    DoubleSlider slider = new DoubleSlider();
    JRadioButton optVelocity;
    JRadioButton optNothing;
    JRadioButton optVelocityAndNormal;
    JRadioButton optVelocityAndAccel;
    DoubleTextField texttime;
    JLabel label = new JLabel(Messages.getString("PanelZweibein.0"));
    Formatter formatter = new Formatter();

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.optNothing.setSelected(true);
            this.texttime.setEnabled(false);
            this.label.setEnabled(false);
            this.slider.setEnabled(false);
        }
    }

    public PanelZweibein(AppletParametricCurve2D main) {
        super(Messages.getString("PanelZweibein.1"));
        this.main = main;
        this.initComponents();
    }

    void initComponents() {
        this.setPreferredSize(new Dimension(2000, 210));
        this.setLayout(new GridBagLayout());
        this.optVelocity = new JRadioButton(Messages.getString("PanelZweibein.2"));
        this.optVelocity.setActionCommand("velocity");
        this.optVelocity.addActionListener(this);
        this.optVelocity.setToolTipText(Messages.getString("PanelZweibein.4"));
        this.optNothing = new JRadioButton(Messages.getString("PanelZweibein.5"));
        this.optNothing.setActionCommand("zweibein_nothing");
        this.optNothing.addActionListener(this);
        this.optNothing.setToolTipText(Messages.getString("PanelZweibein.7"));
        this.optVelocityAndNormal = new JRadioButton(Messages.getString("PanelZweibein.8"));
        this.optVelocityAndNormal.setActionCommand("velocity_normal");
        this.optVelocityAndNormal.addActionListener(this);
        this.optVelocityAndNormal.setToolTipText(Messages.getString("PanelZweibein.10"));
        this.optVelocityAndAccel = new JRadioButton(Messages.getString("PanelZweibein.11"));
        this.optVelocityAndAccel.setActionCommand("velocity_acceleration");
        this.optVelocityAndAccel.addActionListener(this);
        this.optVelocityAndAccel.setToolTipText(Messages.getString("PanelZweibein.13"));
        this.optNothing.setSelected(true);
        this.groupZweibeinOpt.add(this.optNothing);
        this.groupZweibeinOpt.add(this.optVelocityAndAccel);
        this.groupZweibeinOpt.add(this.optVelocity);
        this.groupZweibeinOpt.add(this.optVelocityAndNormal);
        this.slider.setToolTipText(Messages.getString("PanelZweibein.14"));
        this.slider.setValue(0);
        this.slider.setEnabled(false);
        this.label = new JLabel(Messages.getString("PanelZweibein.15"));
        this.texttime = new DoubleTextField(8, null, null, null, null);
        this.texttime.setActionCommand("goto");
        this.texttime.addActionListener(this);
        this.texttime.setToolTipText(Messages.getString("PanelZweibein.17"));
        this.add((Component)this.optNothing, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optVelocity, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optVelocityAndAccel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optVelocityAndNormal, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slider, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.texttime, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DoubleSlider slider = (DoubleSlider)evt.getSource();
                double value = slider.getDoubleValue();
                PanelZweibein.this.main.zweibein.setParameterPos(value);
                if (PanelZweibein.this.groupZweibeinOpt.getSelection().getActionCommand().equals("velocity")) {
                    PanelZweibein.this.main.zweibein.setMode(0);
                    try {
                        PanelZweibein.this.main.zweibein.prepaintcompute();
                        PanelZweibein.this.main.mathpanel2d.report(PanelZweibein.this.getReportString());
                    }
                    catch (Exception ex) {
                        PanelZweibein.this.main.mathpanel2d.reportError(ex);
                    }
                }
                if (PanelZweibein.this.groupZweibeinOpt.getSelection().getActionCommand().equals("velocity_normal")) {
                    PanelZweibein.this.main.zweibein.setMode(1);
                    try {
                        PanelZweibein.this.main.zweibein.prepaintcompute();
                        PanelZweibein.this.main.mathpanel2d.report(PanelZweibein.this.getReportString());
                    }
                    catch (Exception ex) {
                        PanelZweibein.this.main.mathpanel2d.reportError(ex);
                    }
                }
                if (PanelZweibein.this.groupZweibeinOpt.getSelection().getActionCommand().equals("velocity_acceleration")) {
                    PanelZweibein.this.main.zweibein.setMode(2);
                    try {
                        PanelZweibein.this.main.zweibein.prepaintcompute();
                        PanelZweibein.this.main.mathpanel2d.report(PanelZweibein.this.getReportString());
                    }
                    catch (Exception ex) {
                        PanelZweibein.this.main.mathpanel2d.reportError(ex);
                    }
                }
                PanelZweibein.this.main.mathpanel2d.repaint();
            }
        });
    }

    private String roundVector(Vector2D v) {
        double xrange = this.main.mathpanel2d.getScene2d().getXRange();
        double yrange = this.main.mathpanel2d.getScene2d().getYRange();
        double dist = Math.min(0.001, Math.min(xrange, yrange) / 10000.0);
        String rx = this.formatter.format(v.x, dist);
        String ry = this.formatter.format(v.y, dist);
        return "(" + rx + "," + ry + ")";
    }

    private String roundParam(double x) {
        double xrange = this.main.mathpanel2d.getScene2d().getXRange();
        double yrange = this.main.mathpanel2d.getScene2d().getYRange();
        double dist = Math.min(0.001, Math.min(xrange, yrange) / 10000.0);
        return this.formatter.format(x, dist);
    }

    String getReportString() {
        String str = null;
        Zweibein zb = this.main.zweibein;
        switch (this.main.zweibein.getMode()) {
            case 0: {
                str = "t=" + String.valueOf(this.roundParam(zb.getParameterPos())) + " v=" + this.roundVector(zb.getVelocityVector());
                break;
            }
            case 2: {
                str = "t=" + String.valueOf(this.roundParam(zb.getParameterPos())) + " v=" + this.roundVector(zb.getVelocityVector()) + "  a=" + this.roundVector(zb.getAccelerationVector()).toString();
                break;
            }
            case 1: {
                str = "t=" + String.valueOf(this.roundParam(zb.getParameterPos())) + " v=" + this.roundVector(zb.getVelocityVector()) + "  n=" + this.roundVector(zb.getNormalVector());
                break;
            }
        }
        return str;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("zweibein_nothing")) {
            this.main.zweibein.setVisible(false);
            this.slider.setEnabled(false);
            this.label.setEnabled(false);
            this.texttime.setEnabled(false);
        }
        if (ev.getActionCommand().equals("velocity")) {
            this.activateZweibein(0);
        }
        if (ev.getActionCommand().equals("velocity_normal")) {
            this.activateZweibein(1);
        }
        if (ev.getActionCommand().equals("velocity_acceleration")) {
            this.activateZweibein(2);
        }
        if (ev.getActionCommand().equals("goto")) {
            this.gotoparam();
        }
        this.main.mathpanel2d.repaint();
    }

    private void activateZweibein(int mode) {
        this.main.zweibein.setMode(mode);
        if (mode == 1) {
            this.main.mathpanel2d.getScene2d().axesequal(true);
        }
        this.main.panelaxes.update();
        this.main.zweibein.setParameterPos(this.slider.getDoubleValue());
        this.slider.setEnabled(true);
        this.main.zweibein.setVisible(true);
        this.label.setEnabled(true);
        this.texttime.setEnabled(true);
    }

    private void gotoparam() {
        try {
            double param = Double.parseDouble(this.texttime.getText());
            Interval interval = this.main.zweibein.getParameterInterval();
            if (!interval.contains(param)) {
                this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("PanelZweibein.37")) + interval + Messages.getString("PanelZweibein.38"));
                return;
            }
            this.main.zweibein.setParameterPos(param);
            this.main.mathpanel2d.report(this.getReportString());
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
        }
    }
}

