//QT5_Spec.h, Copyright (c) 2001-2024 R.Lackner
//
//    This file is part of RLPlot.
//
//    RLPlot is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    RLPlot is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with RLPlot; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#include "rlplot.h"
#include "menu.h"
#include "TheDialog.h"
#include <qapplication.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpen.h>
#include <qpainter.h>
#include <qmenubar.h>
#include <qscrollbar.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qfiledialog.h>
#include <qimage.h>
#include <qcursor.h>
#include <qclipboard.h>
#include <qbuffer.h>
#include <qbitmap.h>
#include <qtextstream.h>
#include <QMainWindow>
#include <QKeyEvent>
#include <QWheelEvent>
#include <QGridLayout>
#include <QClipboard>
#include <QMimeData>
#include <QPrinter>
#include <QPrintDialog>
#include <QPageSetupDialog>
#include <QFontDialog>

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class TxtCurBlink:public QObject {
	Q_OBJECT
public:
	TxtCurBlink();
	void Blink();

private:
	bool isVis;
	int count;
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The Qt menu support
class MenuAction : public QAction
{
	Q_OBJECT
public:
	MenuAction(const QString &text, QObject *par = NULL, unsigned int cmd = 0);
	int getCmd() {return val_cmd;};

private:
	unsigned int val_cmd;
	char msg[80];
	QObject *parent;

	void do_menu_cmd();
};

class RLPmenu : public QMenuBar
{
	Q_OBJECT
public:
	RLPmenu(QWidget *parent);
	void paintEvent(QPaintEvent *range);

private:
	QWidget *par;
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Temporary visible objects: show action
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class eph_obj {
public:
	eph_obj(eph_obj *nxt, anyOutput *o);
	virtual ~eph_obj();
	virtual void DoPlot(QPainter *qp);
	virtual void Animate(anyOutput *o) {if(next) next->Animate(o);};
	void Restore();

	int cp, rx, ry, rw, rh;
	eph_obj *next;
	anyOutput *out;
	POINT *points, p1, p2;
	DWORD lcolor;
	RECT bounds;
	anyOutput *source;
	bool invert;
};

class eph_line:public eph_obj {
public:
	eph_line(eph_obj *nxt, POINT * pts, int n, DWORD color, anyOutput *o, bool bShow);
	~eph_line();
	void DoPlot(QPainter *qp);
};

class eph_ellipse:public eph_obj {
public:
	eph_ellipse(eph_obj *nxt, POINT pt1, POINT pt2, DWORD color, anyOutput *o, bool bShow);
	~eph_ellipse();
	void DoPlot(QPainter *qp);
};

class eph_invert:public eph_obj {
public:
	eph_invert(eph_obj *nxt, QPixmap *src, int x, int y, int w, int h, anyOutput *o);
	~eph_invert();
	void DoPlot(QPainter *qp);
};

class eph_animated:public eph_obj {
public:
	eph_animated(eph_obj *nxt, int x, int y, int w, int h, anyOutput *o);
	~eph_animated();
	void DoPlot(QPainter *qp);
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The Qt widget class implementet for RLPlot
class RLPwidget:public QWidget {
	Q_OBJECT

public:
	QScrollBar *HScroll, *VScroll;
	QPixmap *mempic;
	QWidget *drawWidget;

	RLPwidget(QWidget *par=0, const char *name=0, anyOutput *o = 0,
		GraphObj *g = 0);
	virtual ~RLPwidget();
	void Command(unsigned int, void *);
	void openHistoryFile(int idx);
	bool SetScroll(bool isVert, int iMin, int iMax, int iPSize, int iPos);
	bool CheckMenu(int, bool);
	void CheckHistory();
	anyOutput *getOutput() {return OutputClass;};

public slots:
	void hScrollEvent(int pos);
	void vScrollEvent(int pos);
	void wheelEvent(QWheelEvent *evt);

protected:
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);
	void closeEvent(QCloseEvent *);
	void mouseDoubleClickEvent(QMouseEvent *e);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	void keyPressEvent(QKeyEvent *e);
	void focusInEvent(QFocusEvent *e);
	void timerEvent(QTimerEvent *);
	void dragEnterEvent(QDragEnterEvent *event);
	void dropEvent(QDropEvent *event);

private:
	QWidget *parent;
	QGridLayout *layout;
	anyOutput *OutputClass;
	GraphObj *BaseObj;
	MenuAction *Mitems[50];
	int nMitems;
};

// utility Widget for RLPwidget
class DrawWidget: public QWidget {
	Q_OBJECT
public:
	RLPwidget *parent;

	DrawWidget(RLPwidget *par);
	~DrawWidget();
	void Command(unsigned int, void *);
	void MyMenu(RLPmenu *menu){menu_bar = menu;};

protected:
	RLPmenu *menu_bar;
	void paintEvent(QPaintEvent *);
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class DlgWidget:public QWidget {
	Q_OBJECT
public:
	QPixmap *mempic;
	anyOutput *OutputClass;

	DlgWidget(QWidget *par=0, const char *name=0, tag_DlgObj *d = 0, DWORD flags = 0L);
	~DlgWidget();

protected:
	void paintEvent(QPaintEvent *);
	void mouseDoubleClickEvent(QMouseEvent *e);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	void keyPressEvent(QKeyEvent *e);
	void focusInEvent(QFocusEvent *e);
	void focusOutEvent(QFocusEvent *e);
	void closeEvent(QCloseEvent *e);
	void timerEvent(QTimerEvent *);

private:
	QWidget *parent;
	tag_DlgObj *dlg;
};


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class BitMapQT:public anyOutput {
public:
	RLPwidget *widget;
	QWidget *dlgwidget;
	HatchOut *hgo;
	QPixmap *mempic;
	QImage *image;
	QPen qPen;
	QPainter qPainter;
	QFont qFont;
	void *ShowObj;				//eph_obj
	void *ShowAnimated;			//copy mark

	BitMapQT(GraphObj *, RLPwidget *, int vr = 98, int hr = 98);
	BitMapQT(GraphObj *, QWidget *, int vr = 98, int hr = 98);
	BitMapQT(int, int, double, double);
	virtual ~BitMapQT();
	bool SetLine(LineDEF *);
	bool ClipRect(RECT *);
	bool SetFill(FillDEF *);
	bool SetTextSpec(TextDEF *);
	virtual bool Erase(DWORD);
	virtual bool StartPage() {return true;};
	bool CopyBitmap(int, int, anyOutput*, int, int, int, int, bool);
	bool oGetTextExtent(unsigned char *, int, double*, double *);
	bool oGetTextExtentW(w_char *, int, double *, double *);
	bool oGetPix(int, int, DWORD *);
	bool oDrawIcon(int, int, int);
	bool oCircle(int, int, int, int, char* nam = 0L);
	bool foCircle(double, double, double, double, char *nam = 0L);
	bool oSphere(int, int, int, POINT *, int, char *nam = 0L);
	bool oPolyline(POINT *, int);
	bool foPolyline(lfPOINT *, int);
	bool oRectangle(int, int, int, int, char *nam = 0L);
	bool foRectangle(double, double, double, double, char *nam = 0L);
	bool oSolidRectangle(int, int, int, int);
	bool foSolidRectangle(double, double, double, double);
	bool oSolidLine(POINT *);
	bool foSolidLine(lfPOINT *);
	bool oTextOut(int, int, unsigned char *, int);
	bool oTextOutW(int, int, w_char *, int);
	bool oPolygon(POINT *, int, char *nam = 0L);
	bool foPolygon(lfPOINT *, int, char *nam = 0L);
	bool oSolidPolygon(POINT *, int);
	bool GradPG(fPOINT3D *pts, long npt, double Lo, double Hi, double pLo, double pHi, lfPOINT *grad);
	virtual void RestoreMark() { return; };

};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class OutputQT:public BitMapQT {
public:
	QScrollBar *HScroll, *VScroll;

	OutputQT(GraphObj *g);
	OutputQT(DlgWidget *wi);
	~OutputQT();
	bool ActualSize(RECT *rc);
	void Focus(){if(widget){widget->show(); widget->raise();}};
	void Caption(char *txt, bool bModified);
	void MouseCursor(int cid, bool force);
	bool SetScroll(bool isVert, int iMin, int iMax, int iPSize, int iPos);
	bool EndPage();
	void MouseCapture(bool bgrab);
	bool UpdateRect(RECT *rc, bool invert);
	void ShowLine(POINT *, int, DWORD, bool bShow = true);
	void ShowEllipse(POINT p1, POINT p2, DWORD color);
	void ShowInvert(RECT *rec);
	bool SetMenu(int type);
	void CheckMenu(int mid, bool check);
	bool Command(int, void *);
	void CreateNewWindow(GraphObj *g);
	int MenuHeight();
	void RestoreMark();


private:
	GraphObj *BaseObj;
};

class PrintQT:public anyOutput{
public:
	HatchOut *hgo;

	PrintQT(GraphObj *g, char *file);
	~PrintQT();
	bool ActualSize(RECT *rc);
	bool SetLine(LineDEF *lDef);
	bool ClipRect(RECT *);
	bool SetFill(FillDEF *fill);
	bool SetTextSpec(TextDEF *set);
	bool StartPage();
	bool EndPage();
	bool Eject();
//	bool oGetTextExtent(char *text, int cb, int *width, int *height);
//	bool oGetTextExtentW(w_char *text, int cb, int *width, int *height);
	bool oCircle(int x1, int y1, int x2, int y2, char* nam = 0L);
	bool foCircle(double, double, double, double, char *nam = 0L);
	bool oSphere(int, int, int, POINT *, int, char *nam = 0L);
	bool oPolyline(POINT * pts, int cp);
	bool oRectangle(int x1, int y1, int x2, int y2, char *nam = 0L);
	bool foRectangle(double, double, double, double, char *nam = 0L);
	bool oSolidRectangle(int, int, int, int);
	bool foSolidRectangle(double, double, double, double);
	bool oSolidLine(POINT *p);
	bool oTextOut(int x, int y, unsigned char *txt, int cb);
	bool oTextOutW(int x, int y, w_char *txt, int cb);
	bool oPolygon(POINT *pts, int cp, char *nam = 0L);
	bool oSolidPolygon(POINT *, int);
	bool GradPG(fPOINT3D *pts, long npt, double Lo, double Hi, double pLo, double pHi, lfPOINT *grad);

private:
	QPen qPen;
	QFont qFont;
	QPainter qPainter;
	char *fileName;
	GraphObj *go;
	bool bPrinting;
};


