//rlp_strings.h, Copyright (c) 2015-2025 R.Lackner
// String definitions for RLPlot
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//    This file is part of RLPlot.
//
//    RLPlot is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    RLPlot is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with RLPlot; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	This file contains string declarations for RLPlot. It is probably the first
//  place for internationalizing and localizing RLPlot.
//  However, this file is far from being complete! Some static text is still present
//  in the different source files.
//

// The menu items
// the '&' character identifies a shortcut
// first the popup headings
#define SMH_FILE	"&File"
#define SMH_EDIT	"&Edit"
#define SMH_DISPLAY	"&Display"
#define SMH_ZOOM	"&Zoom"
#define SMH_TOOLS	"&Tools"
#define SMH_PLOTS	"&Plots"
#define SMH_ABOUT	"&?"
#define SMH_INSERT	"&Insert"
#define SMH_DELETE	"&Delete"
#define SMH_STATS	"&Statistics"
#define SMH_ANOVA	"&Anova"
#define SMH_REGRESS	"&Regression"
#define SMH_CORREL	"C&orrelations"
#define SMH_GRAPH	"&Graph"
#define SMH_BOOTSTRAP "&Bootstrap"

//now the menu item texts
#define SCM_EXIT	"&Exit"
#define SCM_CLOSE	"&Close"
#define SCM_NEWGRAPH	"Create &Graph"
#define SCM_NEWGRAPHP	"Add &Graph"
#define SCM_NEWPAGE	"Create &Page"
#define SCM_DELGRAPH	"&Flush Graph(s)"
#define SCM_ADDPLOT	"Add &Plot"
#define SCM_ABOUT	"&About ..."
#define SCM_ADDROWCOL	"&Rows/Cols"
#define SCM_REDRAW	"&Redraw"
#define SCM_ZOOM25	"25%"
#define SCM_ZOOM50	"50%"
#define SCM_ZOOM100	"100%"
#define SCM_ZOOM200	"200%"
#define SCM_ZOOM400	"400%"
#define SCM_PRINT	"&Print"
#define SCM_EXPORT	"&Export"
#define SCM_DELOBJ	"&Delete Object"
#define SCM_DEFAULTS	"&Configure"
#define SCM_DEFAULTSP	"Page &Settings"
#ifdef RC_INVOKED
#define SCM_OPEN	"&Open\t^o"
#define SCM_SAVE	"&Save\t^s"
//#define SCM_COPY	"&Copy\a^c"
#define SCM_COPY	"&Copy\t^c"
#define SCM_PASTE	"&Paste\t^v"
#define SCM_COPYGRAPH	"&Copy\t^c"
#define SCM_UNDO	"&Undo\t^z"
#define SCM_ZOOMIN	"zoom &in\t^+"
#define SCM_ZOOMOUT	"zoom &out\t^-"
#define SCM_CUT	"C&ut\t^x"
#else 
#define SCM_OPEN	"&Open"
#define SCM_SAVE	"&Save"
#define SCM_COPY	"&Copy"
#define SCM_PASTE	"&Paste"
#define SCM_COPYGRAPH	"&Copy"
#define SCM_UNDO	"&Undo"
#define SCM_ZOOMIN	"zoom &in"
#define SCM_ZOOMOUT	"zoom &out"
#define SCM_CUT	"C&ut"
#endif
#define SCM_UPDATE	"&Update Values"
#define SCM_ADDAXIS	"Add &Axis"
#define SCM_ZOOMFIT	"&fit to window"
#define SCM_FILE1	"File &1"
#define SCM_FILE2	"File &2"
#define SCM_FILE3	"File &3"
#define SCM_FILE4	"File &4"
#define SCM_FILE5	"File &5"
#define SCM_FILE6   	"File &6"
#define SCM_FILLRANGE	"&Fill Range"
#define SCM_LEGEND	"Add &Legend"
#define SCM_LAYERS	"&Layers"
#define SCM_INSROW	"Ins. &Rows"
#define SCM_INSCOL	"Ins. &Columns"
#define SCM_DELROW	"Del. &Rows"
#define SCM_DELCOL	"Del. &Columns"
#define SCM_SAVEAS	"&Save as"
#define SCM_NEWINST	"&New Instance"
#define SCM_T_STANDARD	"&Standard"
#define SCM_T_DRAW	"&Draw"
#define SCM_T_POLYLINE	"Poly&line"
#define SCM_T_POLYGON	"Poly&gon"
#define SCM_T_RECTANGLE	"&Rectangle"
#define SCM_T_ROUNDREC	"r&ound Rect."
#define SCM_T_ELLIPSE	"&Ellipse"
#define SCM_T_ARROW	"&Arrow"
#define SCM_T_TEXT	"&Text"
#define SCM_SMPLSTAT	"&Sample Stats"
#define SCM_REPCMEANS	"&Comp. Means"
#define SCM_REPANOV	"&One Way Anova"
#define SCM_REPBDANOV "&Breakdown Anova"
#define SCM_REPTWANOV	"&Two Way Anova"
#define SCM_REPFRIEDM	"&Friedman Anova"
#define SCM_REPTWANR	"&Two Way /w Replica"
#define SCM_REPKRUSKAL	"&Kruskal Wallis"
#define SCM_REPREGR	"&Linear Regression"
#define SCM_REPTWREGR	"&Two-Way Regression"
#define SCM_ROBUSTLINE	"&Robust Line-Fit"
#define SCM_CORRELM	"Correlation &Matrix"
#define SCM_CORRELT	"Tiled &Plots"
#define SCM_REPTWOWAY	"&2x2 Table"
#define SCM_ARITH	"Range &Arith."
#define SCM_PRISETUP "Setup Printer"
#define SCM_T_CHARMAP "Spec. &Characters"
#define SCM_BT_MEAN "Bootstrap &Mean"
#define SCM_BT_CORREL "Bootstrap &Correlation"
#define SCM_BT_REGR "Bootstrap &Regression"

//#define SCM_REPBDANOV   663
//#define SCM_REPPCA	"&PCA"

//
//Message Box strings
//   these items may contain C-style format specifiers: Do not change
//
#define SCMG_NOTSAVED "%s has not been saved.\nDo you want to save it now?"
#define SCMG_NOGRAPHLEGEND "No graph selected!\nCreate a new graph first or select\na graph before you can add a legend."
#define SCMG_NOGRAPHAXIS "No graph selected!\nCreate a new graph first or select\na graph before you can add an axis."
#define SCMG_NOGRAPHPHEN "No graph selected!\nSelect a graph before you can add a plot."
#define SCMG_NODELSCALEAX "Axes used for scaling\ncan not be deleted."
#define SCMG_NOGRAFORPLOT "No graph selected!\nCreate a new graph first or select\na graph before you can add a plot."
#define SCMS_COMPILERROR "Wrong number of arguments in template line %d"
#define SCMS_DIFFRANGE "Cannot resolve multiple ranges\nwith different sizes.\n\nPlease select ranges with equal size!"
#define SCMS_NODELID "Cannot delete Object\nwith Id %ld"
#define SCMS_NOADDPLOT "Don\'t know how to\nadd a plot to the\ncurrent graph."
#define SCMS_NOPLOTTING "Nothing to Plot!\n"
#define SCMS_NODATA4PLOT "Attempt to create plot\nwithout any data."
//the following message is issued if an object in a disk or memory file is not referenced (orphan object)
#define SCMS_DELBYNOTARY "%d objects deleted\nby notary"
#define SCMS_BAD_XRANGE "X-range not specified\nor not valid."
#define SCMS_BAD_YRANGE "Y-range missing\nor not valid.\nSize must match X-range."
#define SCMS_BAD_LBRANGE "Range for labels missing\nor not valid.\nSize must match X- and Y-range."
#define SCMS_BAD_ERRANGE "Range for errors missing\nor not valid.\nSize must match X- and Y-range."
#define SCMS_BAD_RANGE "Ranges must be valid and of equal size!"
#define SCMS_NOPLOT "No Plot to add\n"
#define SCMS_NO_OUTPUTFILE "Could not open\noutput file!"
#define SCMS_NO_INPUTFILE "Could not open\ninput file!"
#define SCMS_AXISPOS_TOP "Axis position:\nThe top axis remains on top.\n\nVisit the axis property dialog!"
#define SCMS_AXISPOS_BOTTOM "Axis position:\nThe bottom axis remains at the bottom.\n\nVisit the axis property dialog!"
#define SCMS_AXISPOS_LEFT "Axis position:\nThe left axis remains at the left.\n\nVisit the axis property dialog!"
#define SCMS_AXISPOS_RIGHT "Axis position:\nThe right axis remains on the right.\n\nVisit the axis property dialog!"
#define SCMS_RANGE_DIR "Direction range not specified\nor not valid."
#define SCMS_BAD_DATA_RANGE "Data range not valid."
#define SCMS_BAD_ERROR_RANGE "Error range not valid."
#define SCMS_YE_RNG_DIFFER "Y-range and error-range are\ndifferent in size."
#define SCMS_RNG_RAD_DIFFER " Range for values and\n range for radii must\n have the same size!"
#define SCMS_RNG_SEG_DIFFER " Range for values and\n segment names must\n have the same size!"
#define SCMS_RNG_XYZ_EMPTY "The selected data range\nis empty or does not contain\nvalid data triplets!"
#define SCMS_BAD_FILE "The selected file is not valid\nor not accessible!\n"
#define SCMS_NOT_SAVED "The spreadsheet or a graph has been modified!\n\nDo you want to save it now?"
#define SCMS_ERR_PARAM "Syntax Error in parameters."
#define SCMS_ERR_FORMULA "Syntax Error in formula."
#define SCMS_FILE_MISSING "The selected file   \ndoes not exist!\n"
#define SCMS_PLOT_PLACE "All values defining\nthe placement of the plot\nmust be positive."
#define SCMS_PLOT_RECT "The plotting rectangle must\nfit inside the\nbounding rectangle."
#define SCMS_ERR_RBUFF "Read from buffer with\nunknown format failed."
#define SCMS_ERR_DFILE "Error open data file\n\""
#define SCMS_ERR_FILE "Error open file\n\""
#define SCMS_INF_FREAD "Reading File \"%s\""
#define SCMS_INF_BRENDER "Rendering TIFF Bitmap"
#define SCMS_WRITE_RETRY "An error occured during write,\n\nplease try again!"
#define SCMS_INVALID_DATA "Invalid data for\nthis type of plot!"
#define SCMS_RECALC_TICKS "Recalculate ticks for this axis?"
#define SCMS_UNDO_EMPTY "The UNDO-cache is empty"
#define SCMS_DLG_CLOSE "Please use the\n[ OK ] or [ Cancel ]\nbuttons to close dialogs."
#define SCMS_FAIL_SIZE "Failed to set new dimensions\nof Spreadsheet."
#define SCMS_CPY_PLOT_DATA "Copy plot data to the\nclipbord for spreadsheet?"
#define SCMS_INSUFF_DATA "Insufficient data\nfor this opreration!"
#define SCMS_BAD_RANGES "Both ranges must be given\nand must have the same size."
#define SCMS_NO_RANGE "Range not specified\nor not valid."
#define SCMS_IVALID_CI "The confidence intervall must be in the range 0-100%"
#define SCMS_NOEPS "Export of '*.eps' is deprecated!\nYou may still use it but may be discontinued on \
	further versions.\nPlease consider the '*.svg' format for further exports."
#ifdef _WINDOWS
#define SCMS_FREEZE "RLPlot is frozen!\nProgram will shut down."
#endif
//
//Dialog box strings
//   the length of the following may be critical!
//
//Common dialog items
#define SDLG_COM_OK "OK"
#define SDLG_COM_CANCEL "Cancel"
#define SDLG_COM_EMPTY ""
#define SDLG_COM_X "x"
#define SDLG_COM_Y "y"
#define SDLG_COM_Z "z"
#define SDLG_COM_NEG "-"
#define SDLG_COM_NEXT "Next >>"
#define SDLG_COM_PREV "<< Prev."
#define SDLG_COM_PERC "%"
#define SDLG_COM_COLOR "color"
#define SDLG_COM_XVAL "x-value"
#define SDLG_COM_YVAL "y-value"
#define SDLG_COM_ZVAL "z-value"
#define SDLG_COM_LEFT "left"
#define SDLG_COM_RIGHT "right"
#define SDLG_COM_TOP "top"
#define SDLG_COM_BOTTOM "bottom"
#define SDLG_COM_XAXIS "x-axis"
#define SDLG_COM_YAXIS "y-axis"
#define SDLG_COM_ZAXIS "z-axis"
#define SDLG_COM_SELSTYLE "select style:"
#define SDLG_COM_TOPLOT "Apply to PLOT"
#define SDLG_COM_LWIDTH "line width"
#define SDLG_COM_LCOLOR "line color"
#define SDLG_COM_XRANGE "range for x-values"
#define SDLG_COM_YRANGE "range for y-values"
#define SDLG_COM_ZRANGE "range for z-values"
#define SDLG_COM_DATAREF "[data]"
#define SDLG_COM_COMXRANGE "range for common x-values"
#define SDLG_COM_YRANGES "ranges for y-values"
#define SDLG_COM_CI "confidence interval:"

//Dialog tabs
#define SDLG_TAB_SIZECOL "Size & Color"
#define SDLG_TAB_TEXT "Text"
#define SDLG_TAB_EDIT "Edit"
#define SDLG_TAB_SHAPE "Shape & Color"
#define SDLG_TAB_SCALE "Scaling"
#define SDLG_TAB_BASELINE "Baseline"
#define SDLG_TAB_STYLE "Style"
#define SDLG_TAB_LINE "Line"
#define SDLG_TAB_POLGON "Polygon"
#define SDLG_TAB_MODEL "Model"
#define SDLG_TAB_CLIP "Clipping"
#define SDLG_TAB_DETAIL "Details"
#define SDLG_TAB_ERRBAR "Error Bar"
#define SDLG_TAB_TYPE "Type"
#define SDLG_TAB_ARROW "Arrow"
#define SDLG_TAB_WHISKER "Whisker"
#define SDLG_TAB_BALL "Ball"
#define SDLG_TAB_PLANE "Plane"
#define SDLG_TAB_LABEL "Label"
#define SDLG_TAB_FRAME "Frame"
#define SDLG_TAB_ELLIPSE "Ellipse"
#define SDLG_TAB_RECTANGLE "Rectangle"
#define SDLG_TAB_DATA "Data"
#define SDLG_TAB_LAYOUT "Layout"
#define SDLG_TAB_ERRORS "Error Bars"
#define SDLG_TAB_LABELS "Data Labels"
#define SDLG_TAB_TRANSFORM "Transform"
#define SDLG_TAB_COORD "Coordinates"
#define SDLG_TAB_PLOT "Plot"
#define SDLG_TAB_SCHEME "Scheme"
#define SDLG_TAB_DETAILS "Details"
#define SDLG_TAB_SYMBOLS "Symbols"
#define SDLG_TAB_FUNCTION "Function"
#define SDLG_TAB_AXES "Axes"
#define SDLG_TAB_ERRBARS "Error Bars"
#define SDLG_TAB_TICK "Tick"
#define SDLG_TAB_DIRECTION "Direction"
#define SDLG_TAB_AXIS "Axis"
#define SDLG_TAB_TICKS "Ticks"
#define SDLG_TAB_TRANSFORMS "Transforms"
#define SDLG_TAB_BREAKS "Breaks"
#define SDLG_TAB_PLOTS "Plots"
#define SDLG_TAB_GRADIENT "Gradient"
#define SDLG_TAB_PLACEMENT "Placement"
#define SDLG_TAB_ONLYY "only Y"
#define SDLG_TAB_XYVAL "XY values"
#define SDLG_TAB_MANYY "X, many Y"
#define SDLG_TAB_XYZ "XYZ values"
#define SDLG_TAB_COLORS "Colors"
#define SDLG_TAB_PAPER_SIZE "Paper Size"
#define SDLG_TAB_SHAPES "Shapes"
#define SDLG_TAB_DIALOGS "Dialogs"
#define SDLG_TAB_INTERNAT "Internat."
#define SDLG_TAB_DATETIME "Date/Time"
#define SDLG_TAB_DINPUT "Input Data"
#define SDLG_TAB_DIMS "Dimensions"
#define SDLG_TAB_WH "Width and Height"
#define SDLG_TAB_DESC "Description"
#define SDLG_TAB_GRID "Grid"
#define SDLG_TAB_LIGHT "Light Source"
#define SDLG_TAB_REGINPUT "Regression Input"

//
//Building blocks used by different dialogs
// 
// common fill color and pattern: OD_filldef 
//
#define SDLG_ODFILL_OLIN "outline width"
#define SDLG_ODFILL_OLCOL "outline color"
#define SDLG_ODFILL_FICOL "fill color"
#define SDLG_ODFILL_FIPAT "pattern"

// common line properties: OD_linedef
#define SDLG_ODLIN_LWIDTH "line width"
#define SDLG_ODLIN_LCOLOR "line color"
#define SDLG_ODLIN_LPAT "pattern:"
#define SDLG_ODLIN_LPATL "pattern length"

//
//Specific dialog strings
//  The length of the following strings my be critical
//

//configure 3D shading
#define SDLG_SH3D_HD1 "Shade and Fill Color"
#define SDLG_SH3D_HD2 "Configure Surface Color"
#define SDLG_SH3D_HI "HI-color:"
#define SDLG_SH3D_LO "LO-color:"
#define SDLG_SH3D_FIC "fixed color"
#define SDLG_SH3D_LSC "use light sorce"
#define SDLG_SH3D_GRAD "draw color gradient"
#define SDLG_SH3D_LO2HI "Lo- to Hi-color"
#define SDLG_SH3D_RB "rainbow colors"

//The select fill pattern dialog
#define SDLG_FILL_HD1 "Fill patterns"
#define SDLG_FILL_SIZE "pattern size"
#define SDLG_FILL_BG "BG color"

//The common line property dialog
#define SDLG_LINE_HD1 "Line properties"

//The 'Symbol' dialog
#define SDLG_SYM_HD1 "Symbol of "
#define SDLG_SYM_HD2 "Symbol properties"
#define SDLG_SYM_APPLY "Apply to Symbol"
#define SDLG_SYM_SIZE "size"
#define SDLG_SYM_FILLC "fill color"
#define SDLG_SYM_FONT " font "
#define SDLG_SYM_HELV "Helvetica"
#define SDLG_SYM_TIMES "Times"
#define SDLG_SYM_COUR "Courier"
#define SDLG_SYM_STXT " style "
#define SDLG_SYM_BOLD "bold"
#define SDLG_SYM_ITALIC "italic"
#define SDLG_SYM_UNDERL "underlined"
#define SDLG_SYM_FIXED "fixed text:"
#define SDLG_SYM_FROMSS "from spreadsheet range:"
#define SDLG_SYM_DEFTXT "text"

//The 'Bubble' dialog
#define SDLG_BUB_HD1 "Bubble of "
#define SDLG_BUB_HD2 "Bubble Properties"
#define SDLG_BUB_APPLY "Apply to BUBBLE"
#define SDLG_BUB_SIZEDEF "sizes are given as"
#define SDLG_BUB_PROP "proportionality (relative to circle)"
#define SDLG_BUB_SCALEX "scaling with X axis"
#define SDLG_BUB_SCALEY "scaling with Y axis"
#define SDLG_BUB_DIAM "diameter"
#define SDLG_BUB_CIRC "circumference"
#define SDLG_BUB_AREA "area"
#define SDLG_BUB_SIZE "size"

//The 'Bar' dialog
#define SDLG_BAR_HD1 "Bar of "
#define SDLG_BAR_HD2 "Bar properties"
#define SDLG_BAR_TOBAR "Apply to BAR"
#define SDLG_BAR_WIDTH "bar width:"
#define SDLG_BAR_FIXED " fixed"
#define SDLG_BAR_REL " relative"
#define SDLG_BAR_VERT "vertical bars"
#define SDLG_BAR_BOTBASE "bottom baseline"
#define SDLG_BAR_USERY "user y ="
#define SDLG_BAR_HOR "horizontal bars"
#define SDLG_BAR_LEFTBASE "left baseline"
#define SDLG_BAR_USERX "user x ="
#define SDLG_BAR_CENT "bars centered across baseline"
#define SDLG_BAR_ALIGN "horizontal alignment:"
#define SDLG_BAR_LEFT "left"
#define SDLG_BAR_CENTER "center"
#define SDLG_BAR_RIGHT "right"

//The 'DataLine' dialog
#define SDLG_DLINE_HD1 "Line of "
#define SDLG_DLINE_HD2 "Line properties"
#define SDLG_DLINE_COND "Condition:"
#define SDLG_DLINE_COPY "Copy Data"
#define SDLG_DLINE_COND1 "An optional expression to restrict data use,"
#define SDLG_DLINE_COND2 "e.g. \"x > 10 && x < 20\". For details see:"

//The 'DataPolygon' dialog
#define SDLG_DPGON_HD1 "Polygon of "
#define SDLG_DPGON_HD2 "Isopleth \""
#define SDLG_DPGON_HD3 "Properties"
#define SDLG_DPGON_HD4 "Polygon Properties"
#define SDLG_DPGON_HD5 "Error Polygon of "
#define SDLG_DPGON_TOBL " expand polygon to baseline "

//The 'RegLine' dialog
#define SDLG_REGR_HD1 "Regression Line of "
#define SDLG_REGR_HD2 "Regression Line Properties"
#define SDLG_REGR_HD3 "Linear Regression Analysis Step 2/2"
#define SDLG_REGR_YDEPX "y dependent on x"
#define SDLG_REGR_XDEPY "x dependent on y"
#define SDLG_REGR_MIX "mixed model"
#define SDLG_REGR_ZERO "zero crossing (x = 0, y = 0)"
#define SDLG_REGR_MANU "set manually"
#define SDLG_REGR_AEQ "a ="
#define SDLG_REGR_BEQ "b ="
#define SDLG_REGR_LIM "Line length is limited by"
#define SDLG_REGR_MINMAX "data minima and maxima"
#define SDLG_REGR_FRAME "frame rectangle"
#define SDLG_REGR_UDEF "user defined values"

//The 'SD-Ellipse' dialog
#define SDLG_SDELLY_HD1 "SD ellipse of "
#define SDLG_SDELLY_HD2 "SD ellipse properties"
#define SDLG_SDELLY_REGLINE " show regression line"
#define SDLG_SDELLY_ELLY "  ellipse  "
#define SDLG_SDELLY_CENTER "center (means of data)"
#define SDLG_SDELLY_XEQ "x ="
#define SDLG_SDELLY_YEQ "y ="
#define SDLG_SDELLY_STDEV "standard deviation (S.D.)"
#define SDLG_SDELLY_MAXIS "major axis"
#define SDLG_SDELLY_MIXIS "minor axis"
#define SDLG_SDELLY_SIZE "size:"
#define SDLG_SDELLY_1SD " 1 x S.D."
#define SDLG_SDELLY_2SD " 2 x S.D."
#define SDLG_SDELLY_3SD " 3 x S.D."

//The 'ErrorBar' dialog
#define SDLG_EBAR_HD1 "Error bar of "
#define SDLG_EBAR_HD2 "Error bar properties"
#define SDLG_EBAR_TOERR "Apply to ERROR"
#define SDLG_EBAR_CWIDTH "cap width"
#define SDLG_EBAR_ERR "error"
#define SDLG_EBAR_DESC "description:"
#define SDLG_EBAR_CENT " keep error bar centerd on bar"

//The 'ErrBar3D' dialog: some definitions used from 'ErrorBar'
#define SDLG_EBAR3D_HD1 "3D Error bar of "
#define SDLG_EBAR3D_HD2 "3D Error bar properties"

//The 'Arrow' dialog
#define SDLG_ARROW_HD1 "Arrow of "
#define SDLG_ARROW_HD2 "Arrow properties"
#define SDLG_ARROW_CWIDTH "cap width"
#define SDLG_ARROW_CLENGTH "length"
#define SDLG_ARROW_LWIDTH "line width"
#define SDLG_ARROW_LONLY "line only"
#define SDLG_ARROW_WLINE "arrow with lines"
#define SDLG_ARROW_FILLED "filled arrow"
#define SDLG_ARROW_ORGX "origin x"
#define SDLG_ARROW_COMORG "set common origin to"
#define SDLG_ARROW_TOALL "all arrows of plot"
#define SDLG_ARROW_TOARR "Apply to ARROW"
#define SDLG_ARROW_SYMSPACE "leave space for symbols"

//The 'Box' dialog
#define SDLG_BOX_HD1 "Box of "
#define SDLG_BOX_HD2 "Box properties"
#define SDLG_BOX_TOBOX "Apply to BOX"
#define SDLG_BOX_BWIDTH "bar width:"
#define SDLG_BOX_FIX " fixed"
#define SDLG_BOX_REL " relative"
#define SDLG_BOX_PT1X "point 1 x"
#define SDLG_BOX_PT2X "point 2 x"
#define SDLG_BOX_WIDTH "box width"

//The 'Whisker' dialog: some definitions used from 'ErrorBar'
#define SDLG_WHISKER_HD1 "Whisker of "
#define SDLG_WHISKER_HD2 "Whisker properties"
#define SDLG_WHISKER_TOOBJ "Apply to WHISKER"
#define SDLG_WHISKER_LWIDTH "line width"
#define SDLG_WHISKER_LCOL "line color"
#define SDLG_WHISKER_P1X "point 1 x"
#define SDLG_WHISKER_P2X "point 2 x"

//The 'DropLine' dialog
#define SDLG_DROPL_HD1 "Dropline of "
#define SDLG_DROPL_HD2 "Dropline properties"
#define SDLG_DROPL_TOLINE "Apply to LINE"
#define SDLG_DROPL_SHAPE " Shape "
#define SDLG_DROPL_LINETO "line to:"

//The 'DropLine3D' dialog: some definitions used from 'DropLine'
#define SDLG_DROPL3D_BACK "back"
#define SDLG_DROPL3D_FRONT "front"

//The 'Sphere' (Ball) dialog
#define SDLG_BALL_HD1 "Ball of "
#define SDLG_BALL_HD2 "Ball properties"
#define SDLG_BALL_TOBALL "Apply to BALL"
#define SDLG_BALL_SIZE "ball size"
#define SDLG_BALL_LWIDTH "line width"
#define SDLG_BALL_LCOLOR "line color"
#define SDLG_BALL_FCOLOR "fill color"
#define SDLG_BALL_XDATA "[x-data]"
#define SDLG_BALL_YDATA "[y-data]"
#define SDLG_BALL_ZDATA "[z-data]"

//The 'Plane3D' dialog
#define SDLG_PLANE3D_HD1 "Plane of "
#define SDLG_PLANE3D_HD2 "Plane properties"
#define SDLG_PLANE3D_HD3 "3D Surface Properties"
#define SDLG_PLANE3D_TOPLANE "Apply to PLANE"
#define SDLG_PLANE3D_LWIDTH "line width"
#define SDLG_PLANE3D_LCOLOR "line color"
#define SDLG_PLANE3D_FCOLOR "fill color"
#define SDLG_PLANE3D_RWIDTH "ribbon width"
#define SDLG_PLANE3D_RPOS "ribbon pos."
#define SDLG_PLANE3D_ZDATA "[z-data]"

//The 'Brick' (column 3D) dialog
#define SDLG_BRICK_HD1 "Column of "
#define SDLG_BRICK_HD2 "Column properties"
#define SDLG_BRICK_TOCOLUMN "Apply to COLUMN"
#define SDLG_BRICK_LWIDTH "outline width"
#define SDLG_BRICK_LCOLOR "outline color"
#define SDLG_BRICK_FCOLOR "fill color"
#define SDLG_BRICK_CWIDTH "column width"
#define SDLG_BRICK_CDEPTH "column depth"
#define SDLG_BRICK_YBASE "base (y)"
#define SDLG_BRICK_HEIGHT "height"

//The 'Arrow 3D' dialog: some definitions used from 'Arrow'
#define SDLG_ARR3D_TOALL "set as common origin"

//The 'Line3D' dialog: all definitions elsewhere

//The 'Label' dialog
#define SDLG_LABEL_HD1 "Label properties"
#define SDLG_LABEL_PAXIS "(axis)"
#define SDLG_LABEL_PTICK "(tick)"
#define SDLG_LABEL_SIZE "size"
#define SDLG_LABEL_TEXT "text:"
#define SDLG_LABEL_ROT "rotation"
#define SDLG_LABEL_DEG "deg."
#define SDLG_LABEL_LSPC "line spacing"
#define SDLG_LABEL_MOVE " moveable"
#define SDLG_LABEL_FONT " font "
#define SDLG_LABEL_HELV "Helvetica"
#define SDLG_LABEL_TIMES "Times"
#define SDLG_LABEL_COURIER "Courier"
#define SDLG_LABEL_GREEK "Greek"
#define SDLG_LABEL_STYLE " style "
#define SDLG_LABEL_BOLD "bold"
#define SDLG_LABEL_ITALIC "italic"
#define SDLG_LABEL_UNDERL "underlined"
#define SDLG_LABEL_SUPER "superscript"
#define SDLG_LABEL_SUB "subscript"
#define SDLG_LABEL_ANCHOR "text anchor at"
#define SDLG_LABEL_ADIST "distance from anchor point"
#define SDLG_LABEL_DX "dx"
#define SDLG_LABEL_DY "dy"
#define SDLG_LABEL_HSP "hot spot (text alignment):"
#define SDLG_LABEL_AXIS "Axis"
#define SDLG_LABEL_TICKPROP "Tick Properties"
#define SDLG_LABEL_DELOBJ "Delete Object"

//The 'TextFrame' dialog
#define SDLG_TXTFRM_HD1 "Text Frame"
#define SDLG_TXTFRM_SIZE "text size"
#define SDLG_TXTFRM_COL "text color"
#define SDLG_TXTFRM_LSPAC "line spacing"
#define SDLG_TXTFRM_POS "Text frame position:"
#define SDLG_TXTFRM_PT1_X "Corner1 X"
#define SDLG_TXTFRM_PT_Y "Y"
#define SDLG_TXTFRM_PT2_X "Corner2 X"

//The 'segment' (pie slice) dialog
#define SDLG_SEGMENT_HD1 "Segment Properties"
#define SDLG_SEGMENT_TOSEGMENT "Apply to SEGMENT"
#define SDLG_SEGMENT_EXPLODE "shift out (explode)"
#define SDLG_SEGMENT_MOVEABLE "enable mouse drag (moveable)"
#define SDLG_SEGMENT_CENTX "center x"
#define SDLG_SEGMENT_STARTANG "start angle"
#define SDLG_SEGMENT_DEG "deg."
#define SDLG_SEGMENT_STOP "stop"
#define SDLG_SEGMENT_RAD1 "outer radius"
#define SDLG_SEGMENT_RAD2 "inner"
#define SDLG_SEGMENT_NAM "segment name:"

//The 'polyline' dialog
#define SDLG_POLYLINE_HD1 "Line Properties"
#define SDLG_POLYLINE_DEFAULT "use this style as default"

//The 'polygon' dialog
#define SDLG_POLYGON_HD1 "Polygon Properties"
#define SDLG_POLYGON_DEFAULT "use this style as default"

//The 'rectangle', 'round rectangle', and 'ellipse' dialog
#define SDLG_REC_HD1 "Ellipse Properties"
#define SDLG_REC_HD2 "Rounded Rectangle Properties"
#define SDLG_REC_HD3 "Rectangle Properties"

//Create a simple bar chart
#define SDLG_BARCHART_HD1 "Create a Simple Bar Chart"
#define SDLG_BARCHART_RANGE "spread sheet range for values"
#define SDLG_BARCHART_STYLE " style "
#define SDLG_BARCHART_START "start value"
#define SDLG_BARCHART_STEP "step value"
#define SDLG_BARCHART_WIDTH "bar width"

//Create a scatterplot or XY-plot
#define SDLG_PLOTSCATT_HD1 "XY Plot properties"
#define SDLG_PLOTSCATT_INFO1 "Valid ranges include e.g. \'a1:g13\'"
#define SDLG_PLOTSCATT_INFO2 "or \'b4:j4\' if data are available."
#define SDLG_PLOTSCATT_INFO3 "Separate multiple ranges by \' ; \'."
#define SDLG_PLOTSCATT_INFO4 "An optional expression to restrict data use,"
#define SDLG_PLOTSCATT_INFO5 "e.g. \"x > 10 && x < 20\" will plot only data"
#define SDLG_PLOTSCATT_INFO6 "where x is in the range 10-20"
#define SDLG_PLOTSCATT_DOSYM " symbols"
#define SDLG_PLOTSCATT_DOARR " arrows"
#define SDLG_PLOTSCATT_DODROP " drop lines"
#define SDLG_PLOTSCATT_DOLIN " line"
#define SDLG_PLOTSCATT_DOPG " polygon"
#define SDLG_PLOTSCATT_DOVBAR " vertical bars"
#define SDLG_PLOTSCATT_DOHBAR " horizontal bars"
#define SDLG_PLOTSCATT_ERRS " draw error bars"
#define SDLG_PLOTSCATT_ERRPG " draw error polygon"
#define SDLG_PLOTSCATT_ERRPGSTYLE "polygon style:"
#define SDLG_PLOTSCATT_STYLE "style:"
#define SDLG_PLOTSCATT_ERRANGE "range for error data:"
#define SDLG_PLOTSCATT_ADDLAB "add labels to data points"
#define SDLG_PLOTSCATT_LABRANGE "spread sheet range for labels:"
#define SDLG_PLOTSCATT_DEFTXT "default text:"
#define SDLG_PLOTSCATT_NA "n.a."
#define SDLG_PLOTSCATT_EMPTY "(for empty cells)"
#define SDLG_PLOTSCATT_DIST "distance from point:"
#define SDLG_PLOTSCATT_DX "dx"
#define SDLG_PLOTSCATT_DY "dy"
#define SDLG_PLOTSCATT_ALIGN "alignment:"
#define SDLG_PLOTSCATT_COND "condition:"
#define SDLG_PLOTSCATT_ISBAR "Bar Chart: "
#define SDLG_PLOTSCATT_ISXY "XY-Plot: "
#define SDLG_PLOTSCATT_EXPRERR "The expression in condition is not legal.\nThe term must evaluate to either 'true' or 'false'.\ne.g. 'x <= 10' or 'y < c1'.\nAn empty field is 'true': no restrictions."

//Create a xy-stat plot: mean +/- error
#define SDLG_XYSTAT_HD1 "Mean and Error Plot"
#define SDLG_XYSTAT_GROUP "range for grouping variable"
#define SDLG_XYSTAT_XDTA "(X data)"
#define SDLG_XYSTAT_YDTA "range for Y data"
#define SDLG_XYSTAT_MEANS " draw means "
#define SDLG_XYSTAT_DOLINE " line"
#define SDLG_XYSTAT_DOSYM " symbols"
#define SDLG_XYSTAT_DOBAR " bars"
#define SDLG_XYSTAT_USE "using"
#define SDLG_XYSTAT_AMEAN " arithmetic mean"
#define SDLG_XYSTAT_GMEAN " geometric mean"
#define SDLG_XYSTAT_HMEAN " harmonic mean"
#define SDLG_XYSTAT_MEDIAN " median"
#define SDLG_XYSTAT_EBARS " draw error bars "
#define SDLG_XYSTAT_SDEV " std.deviation(SD)"
#define SDLG_XYSTAT_SEM " std.error(SEM)"
#define SDLG_XYSTAT_PERC " 25, 75 % percentiles"
#define SDLG_XYSTAT_MIMA " min and max"
#define SDLG_XYSTAT_CONF "%  conf.interval"
#define SDLG_XYSTAT_NC " number of cases "
#define SDLG_XYSTAT_TOPE " on top of error"
#define SDLG_XYSTAT_TOPM " on top of mean"
#define SDLG_XYSTAT_PREF "prefix:"
#define SDLG_XYSTAT_NPREF "n = "

//Create a frequecy distribution plot
#define SDLG_FDIST_HD1 "Frequency Distribution"
#define SDLG_FDIST_RANGE "spread sheet range for values"
#define SDLG_FDIST_CLASS " classes "
#define SDLG_FDIST_DODIST " plot distribution "
#define SDLG_FDIST_CREA "create"
#define SDLG_FDIST_CLABAR "classes and bars"
#define SDLG_FDIST_CLSIZE "class size is"
#define SDLG_FDIST_START "starting at"
#define SDLG_FDIST_BSTYLE " bar style "
#define SDLG_FDIST_NORM " normal"
#define SDLG_FDIST_LNORM " log-normal"
#define SDLG_FDIST_BINO " binomial"
#define SDLG_FDIST_POISS " poisson"
#define SDLG_FDIST_EXP " exponential"
#define SDLG_FDIST_RECT " rectangular"
#define SDLG_FDIST_CHI2 " chi-square"
#define SDLG_FDIST_FSTYLE " function style "
#define SDLG_FDIST_LINE "line:"
#define SDLG_FDIST_NOBS "No. of observations"
#define SDLG_FDIST_CATS "Categories"

//Create a linear regression plot
#define SDLG_REGRA_HD1 "Linear Regression Analysis step 1/2"
#define SDLG_REGRA_SYMS " include symbols in plot"
#define SDLG_REGRA_SDEL " draw SD ellipse"
#define SDLG_REGRA_XVAL "  x-values  "
#define SDLG_REGRA_X "x = x"
#define SDLG_REGRA_LOGX "x = log(x)"
#define SDLG_REGRA_RECX "x = 1/x"
#define SDLG_REGRA_SQRTX "x = sqrt(x)"
#define SDLG_REGRA_YVAL "  y-values  "
#define SDLG_REGRA_Y "y = y"
#define SDLG_REGRA_LOGY "y = log(y)"
#define SDLG_REGRA_RECY "y = 1/y"
#define SDLG_REGRA_SQRTY "y = sqrt(y)"

//Linear regression with x, y1..yn
#define SDLG_MYREGR_HD1 "Linear Regression Analysis"
#define SDLG_MYREGR_REGR " Regression "
#define SDLG_MYREGR_RLINE " regression line"
#define SDLG_MYREGR_DATA " Data "
#define SDLG_MYREGR_ALLVAL " draw all values"
#define SDLG_MYREGR_MEANSD  " means +/- Std. Dev."
#define SDLG_MYREGR_MEANSERR  " means +/- Std. Err."
#define SDLG_MYREGR_CI1 " draw"
#define SDLG_MYREGR_CI2 "% C.I."


//Bar chart: average multiple y
#define SDLG_MYBAR_HD "Bar Chart: Average multiple Y"
#define SDLG_MYBAR_DATA " Data "
#define SDLG_MYBAR_LAYOUT "Layout "
#define SDLG_MYBAR_MEANS " draw means"
#define SDLG_MYBAR_MEANSD  " means +/- Std. Dev."
#define SDLG_MYBAR_MEANSERR  " means +/- Std. Err."
#define SDLG_MYBAR_VBARS " verical bars"
#define SDLG_MYBAR_SYMS " symbols"
#define SDLG_MYBAR_ERRS " error bars"
#define SDLG_MYBAR_ERRPG " error polygon"
#define SDLG_MYBAR_LINE " line"

//Create a bubble plot
//Note: this dialog uses some definitions of the 'Bubble' object
#define SDLG_BPLT_HD1 "Create Bubble Plot"
#define SDLG_BPLT_SRANG "range for sizes"
#define SDLG_BPLT_OLIN "outline:"
#define SDLG_BPLT_LW "line width"
#define SDLG_BPLT_FILL "fill:"
#define SDLG_BPLT_PAT "pattern"

//Add to polar plot
#define SDLG_POLPLT_HD3 "Add Polar Plot"
#define SDLG_POLPLT_SELECT " select template and data range "

//Configure polar plot
#define SDLG_POLPLT_HD2 "Polar Plot Properties"
#define SDLG_POLPLT_DISPA "show radial axis"

//Create a polar plot
#define SDLG_POLPLT_HD1 "Create Polar Plot"
#define SDLG_POLPLT_RANGE "angular range (full circle)"
#define SDLG_POLPLT_MIN "min ="
#define SDLG_POLPLT_MAX "max ="
#define SDLG_POLPLT_OFFS "angular offset:"
#define SDLG_POLPLT_CENT "position of center:"
#define SDLG_POLPLT_CX "x ="
#define SDLG_POLPLT_CY "y ="
#define SDLG_POLPLT_RAD "radius:"
#define SDLG_POLPLT_XRNG "range for x-data (circular or angular data)"
#define SDLG_POLPLT_YRNG "range for y-data (radial data)"

//Add to ternary (triangle) plot
#define SDLG_TERN_HD3 "Add Plot to Ternary Plot"
#define SDLG_TERN_LAYOUT "layout:"

//Configure ternary (triangle) plot
#define SDLG_TERN_HD2 "Ternary Plot:\nCannot Configure\n"

//Create a ternary (triangle) plot
#define SDLG_TERN_HD1 "Create Ternary Plot"
#define SDLG_TERN_SYM " symbols"
#define SDLG_TERN_LIN " line"
#define SDLG_TERN_PG " polygon"
#define SDLG_TERN_GRID " draw grid"
#define SDLG_TERN_ARROWS " arrows"

//Add to ternary (triangle) XYZ plot
#define SDLG_TERXYZ_HD3 "Add Ternary XYZ Plot"

//Configure ternary (triangle) XYZ plot
#define SDLG_TERXYZ_HD2 "Ternary XYZ Plot:\nCannot Configure\n"

//Create ternary (triangle) XYZ plot
#define SDLG_TERXYZ_HD1 "Create Ternary XYZ Plot"

//Create a box and whisker plot
#define SDLG_BOXPLT_HD1 "Create a Box and Whisker Plot"
#define SDLG_BOXPLT_DSC "Data Source:"
#define SDLG_BOXPLT_UVAL " user values"
#define SDLG_BOXPLT_SVAL " statistical data"
#define SDLG_BOXPLT_XVAL "range for grouping variable (X values)"
#define SDLG_BOXPLT_DMEAN " draw means "
#define SDLG_BOXPLT_DLINE " line"
#define SDLG_BOXPLT_DSYMS " symbols"
#define SDLG_BOXPLT_USING "using"
#define SDLG_BOXPLT_AMEAN " arithmetic mean"
#define SDLG_BOXPLT_GMEAN " geometric mean"
#define SDLG_BOXPLT_HMEAN " harmonic mean"
#define SDLG_BOXPLT_MEDIAN " median"
#define SDLG_BOXPLT_BOXES " draw boxes "
#define SDLG_BOXPLT_SDEV " std. deviation (SD)"
#define SDLG_BOXPLT_SERR " std. error (SEM)"
#define SDLG_BOXPLT_PERC " 25, 75% percentiles"
#define SDLG_BOXPLT_MIMA " min and max"
#define SDLG_BOXPLT_SPC " "
#define SDLG_BOXPLT_COFI "%  conf. interval"
#define SDLG_BOXPLT_ERRS " draw whiskers "
#define SDLG_BOXPLT_COMX "range for common X values"
#define SDLG_BOXPLT_DOLIN " draw line"
#define SDLG_BOXPLT_LINVAL "range for line values"
#define SDLG_BOXPLT_DOSYMS " draw symbols"
#define SDLG_BOXPLT_RNGSYMS "range for symbol values"
#define SDLG_BOXPLT_DOBOX " draw boxes"
#define SDLG_BOXPLT_RNGHI "range for HI values"
#define SDLG_BOXPLT_RNGLO "range for LO values"
#define SDLG_BOXPLT_DOERRS " draw whiskers"
#define SDLG_BOXPLOT_ERRPG " draw error polygon"
#define SDLG_BOXPLT_NCASE " number of cases "
#define SDLG_BOXPLT_TOPE " on top of error"
#define SDLG_BOXPLT_TOPM " on top of mean"
#define SDLG_BOXPLT_PREF "prefix:"
#define SDLG_BOXPLT_NEQ "n = "

//Create a density distribution plot
#define SDLG_DENSDISP_HD1 "Density profile"
#define SDLG_DENSDISP_RANGE1 "range for direction (time, depth) data"
#define SDLG_DENSDISP_RANGE2 "range for width (density) data"
#define SDLG_DENSDISP_VPROF "vertical profile"
#define SDLG_DENSDISP_SYMBAR "symmetric bars"
#define SDLG_DENSDISP_RIGHT "bars right"
#define SDLG_DENSDISP_LEFT "bars left"
#define SDLG_DENSDISP_UP "bars up"
#define SDLG_DENSDISP_DOWN "bars down"

//Create a stacked bar or stacked polygon plot
#define SDLG_STB_HD1 "Stacked Bar Plot"
#define SDLG_STB_HD2 "Stacked Polygons"
#define SDLG_STB_COMX "range for common x values"
#define SDLG_STB_MBY " ranges for y values "
#define SDLG_STB_YADD " add each y to start value"
#define SDLG_STB_YSUB " subtract each y from start value"
#define SDLG_STB_STV "start value:"
#define SDLG_STB_HPLOT " horizontal plot"
#define SDLG_STB_RFMT "y-values # %d/%d"

// create a phenology plot
#define SDLG_PHEN_HD1 "Create Phenology PLot"
#define SDLG_PHEN_XRANG "range for common x values"
#define SDLG_PHEN_YRANG " ranges for y values "
#define SDLG_PHEN_PLOTINC "height of individual plots"
#define SDLG_PHEN_INDAXES " draw individual x-axis for every plot"

// create grouped bars chart
#define SDLG_GBAR_HD1 "Grouped Bar Chart"
#define SDLG_GBAR_HD2 "Grouped Bar Chart with Error Bars"
#define SDLG_GBAR_VALUES "Get values from spreadsheet:"
#define SDLG_GBAR_RANGES "All ranges should have equal size!"
#define SDLG_GBAR_YVALS " ranges for y values "
#define SDLG_GBAR_START "start value"
#define SDLG_GBAR_GSTEP "group step"
#define SDLG_GBAR_BWIDTH "bar width"
#define SDLG_GBAR_GGAP "group gap"
#define SDLG_GBAR_GLABEL " no group labels"
#define SDLG_GBAR_SSRNG "from spreadsheet range:"
#define SDLG_GBAR_YERNG " ranges for y- and error- data "

// create a waterfall graph
#define SDLG_WFPLOT_HD1 "Create Waterfall Plot"
#define SDLG_WFPLOT_YRNGS " ranges for y values "
#define SDLG_WFPLOT_XYDISP "data to data displacement : "
#define SDLG_WFPLOT_DX "dx = "
#define SDLG_WFPLOT_DY "dy = "
#define SDLG_WFPLOT_DLINES " draw lines"
#define SDLG_WFPLOT_DBARS " draw bars"
#define SDLG_WFPLOT_COL_ALL " common color for all:"
#define SDLG_WFPLOT_COL_INC " increment color scheme : "
#define SDLG_WFPLOT_YFMT "y-values # %d/%d"

// create a multi data line plot
#define SDLG_MLPLOT_HD1 "Create Multi Line Plot"
#define SDLG_MLPLOT_XYRNG " ranges for x- and y- values "
#define SDLG_MLPLOT_LICOL "line color"
#define SDLG_MLPLOT_COMCOL " common color for lines:"
#define SDLG_MLPLOT_INCCOL " increment color scheme:"
#define SDLG_MLPLOT_DOSYM " draw symbols"
#define SDLG_MLPLOT_COLSYM " use line color for symbols"
#define SDLG_MLPLOT_XFMT "x-range # %d/%d"
#define SDLG_MLPLOT_YFMT "y-range # %d/%d"

// create a pie or ring chart
#define SDLG_PIE_HD1 "Create pie chart"
#define SDLG_PIE_HD2 "Create ring chart"
#define SDLG_PIE_RNG "spread sheet range for values"
#define SDLG_PIE_CENT "position of center:"
#define SDLG_PIE_START "start angle"
#define SDLG_PIE_DEG "degree"
#define SDLG_PIE_FIXR "fixed radius"
#define SDLG_PIE_SSR "pick radii from spreadsheet range"
#define SDLG_PIE_XFAC "x  factor"
#define SDLG_PIE_ORAD "outer radius"
#define SDLG_PIE_IRAD "inner radius"
#define SDLG_PIE_USENAME " get segment names from range:"

// Create a star chart
#define SDLG_STAR_HD1 "Create star chart"
#define SDLG_STAR_RNG "spread sheet range for values"
#define SDLG_STAR_XFAC "x  factor"
#define SDLG_STAR_SANG "start angle"
#define SDLG_STAR_DEG "degree"
#define SDLG_STAR_DOPG "draw polygon"
#define SDLG_STAR_DRAY "draw rays"
#define SDLG_STAR_DLABEL "add labels to data points"
#define SDLG_STAR_LBRNG "spread sheet range for labels:"
#define SDLG_STAR_LBDIST "distance : "

// Grid3D properties
#define SDLG_G3D_HD1 "Grid of "
#define SDLG_G3D_HD2 "3D Grid"
#define SDLG_G3D_GLINE " grid lines "
#define SDLG_G3D_SURF " surface "
#define SDLG_G3D_GLW "grid line width"
#define SDLG_G3D_GLC "grid line color"
#define SDLG_G3D_PLC "plane color"
#define SDLG_G3D_INF1 "To hide gridlines set grid line color"
#define SDLG_G3D_INF2 "to 100% transparent."

//Scatt3D accomodates most simple 3D plots
#define SDLG_PLOT3D_HD1 "Create 3D Plot"
#define SDLG_PLOT3D_HD2 "Delauney Surface"
#define SDLG_PLOT3D_HD3 "Create Paravent Plot"
#define SDLG_PLOT3D_ROT1 "Use [arrow keys], [shift]+[arrow key],"
#define SDLG_PLOT3D_ROT2 "and [r], [R], [l] or [L] to rotate graph."
#define SDLG_PLOT3D_VEC "The rotation vector must not be NULL."
#define SDLG_PLOT3D_SEL1 " balls"
#define SDLG_PLOT3D_SEL2 " columns"
#define SDLG_PLOT3D_SEL3 " line"
#define SDLG_PLOT3D_SEL4 " drop lines"
#define SDLG_PLOT3D_SEL5 " arrows"
#define SDLG_PLOT3D_SEL6 " polygon"
#define SDLG_PLOT3D_TEMPL "select template:"
#define SDLG_PLOT3D_ERRRNG "range for error data:"
#define SDLG_PLOT3D_DOERRS " draw error bars:"
#define SDLG_PLOT3D_BADR "Ranges for "
#define SDLG_PLOT3D_BADRX "\n-  X Data"
#define SDLG_PLOT3D_BADRY "\n-  Y Data"
#define SDLG_PLOT3D_BADRZ "\n-  Z Data"
#define SDLG_PLOT3D_RNGMISS "\nnot given or not valid."

// funtion plotter with user defined function
#define SDLG_FUNC2D_HD1 "Function Plot"
#define SDLG_FUNC2D_TIT "plot user defined function"
#define SDLG_FUNC2D_BEGX "where x = "
#define SDLG_FUNC2D_ENDX "until"
#define SDLG_FUNC2D_STEPX "step"
#define SDLG_FUNC2D_YEQ "y="

// fit function by nonlinear regression
#define SDLG_FITFUNC_HD1 "Fit Function to Data"
#define SDLG_FITFUNC_FIT "Fit"
#define SDLG_FITFUNC_FITFUNC "fit function by nonlinear regression"
#define SDLG_FITFUNC_PARAM "parameters and initial values : "
#define SDLG_FITFUNC_DEF "function, y = f(x) : "
#define SDLG_FITFUNC_YEQ "y = "
#define SDLG_FITFUNC_CONV "converg.: "
#define SDLG_FITFUNC_ITER "iterations: "
#define SDLG_FITFUNC_DOSYMS "draw symbols"
#define SDLG_FITFUNC_XSTART "plot x = "
#define SDLG_FITFUNC_XEND "until"
#define SDLG_FITFUNC_XSTEP "step"
#define SDLG_FITFUNC_METH "algorithm:"
#define SDLG_FITFUNC_LEVMARC "Levenberg Marquart"
#define SDLG_FITFUNC_SIMPLEX "Simplex"
#define SDLG_FITFUNC_BOOT "Bootstrap"

// Create a new normal quantile plot
#define SDLG_NQUANT_HD1 "Normal Quantiles Plot"
#define SDLG_NQUANT_RANGE "range for variables"
#define SDLG_NQUANT_YAXIS "Normal quantiles"
#define SDLG_NQUANT_LEGEND "Data"
#define SDLG_NQUANT_SYMS "Symbols:"

// Create a contour plot
#define SDLG_CONTOUR_HD1 "Create Contour Plot"
#define SDLG_CONTOUR_SRECT " super rectangle "
#define SDLG_CONTOUR_ZMIN " at z minimum"
#define SDLG_CONTOUR_ZMAX " at z maximum"
#define SDLG_CONTOUR_ZMEAN " at z mean"
#define SDLG_CONTOUR_ZUSER " at user defined level,"
#define SDLG_CONTOUR_ZEQ "z ="
#define SDLG_CONTOUR_DOSYM "  draw symbols  "
#define SDLG_CONTOUR_NOSYM " no symbols"
#define SDLG_CONTOUR_DOMIN " draw minima"
#define SDLG_CONTOUR_DOMAX " draw maxima"
#define SDLG_CONTOUR_DOSRC " draw all source data"
#define SDLG_CONTOUR_SLABEL " symbols with labels"

// Add axis to three dimensional graph
#define SDLG_AXIS3D_HD1 "Add Axis to 3D Plot"
#define SDLG_AXIS3D_SCALE " scaling "
#define SDLG_AXIS3D_AUTOS " automatic scaling"
#define SDLG_AXIS3D_FROM "axis from"
#define SDLG_AXIS3D_TO "to"
#define SDLG_AXIS3D_LINE " line "
#define SDLG_AXIS3D_LIW "width"
#define SDLG_AXIS3D_LABEL " axis label "
#define SDLG_AXIS3D_TEMPL "select a template:"
#define SDLG_AXIS3D_YAT "y-axis at:"
#define SDLG_AXIS3D_XAT "x-axis at:"
#define SDLG_AXIS3D_ZAT "z-axis at:"
#define SDLG_AXIS3D_NONE "[none]"

// Properties of 3D graph
#define SDLG_PLOT_3D_HD "Properties of 3D Graph "
#define SDLG_PLOT_3D_DEG "deg."
#define SDLG_PLOT_3D_XROT "rotation x"
#define SDLG_PLOT_3D_YROT "rot. y"
#define SDLG_PLOT_3D_ZROT "rot. z"
#define SDLG_PLOT_3D_AZI "azimut (x)"
#define SDLG_PLOT_3D_ELE "elevation (y)"

// Add 3D plot to graph
#define SDLG_ADDPLOT_3D_HD1 "Add 3D Plot"
#define SDLG_ADDPLOT_3D_TEMPL "  select template  "

// Create a 2.5 dimensional bar chart
//NOTE: Some of the following definitions are also used for 2.5D ribbon chart
#define SDLG_BAR25D_HD1 "Create 2.5D Bar Chart"
#define SDLG_BAR25D_DIST "distances:"
#define SDLG_BAR25D_STZ "start z ="
#define SDLG_BAR25D_STEP "step ="
#define SDLG_BAR25D_CCOL " common color for columns:"
#define SDLG_BAR25D_CINC " increment color scheme:"
#define SDLG_BAR25D_YOFY "y-values # %d/%d"

// Create a 2.5 dimensional ribbon chart
//NOTE: Some definitions taken from 2.5D ribbon chart
#define SDLG_RIB25D_HD1 "Create 2.5D Ribbon Chart"
#define SDLG_RIB25D_CCOL " common color for ribbons:"

// Create a 3 dimensional bubble plot
//NOTE: This template uses some definitions of the 'Bubble' and 'BubblePlot'objects
#define SDLG_BUB3DPLOT_HD1 "Create a 3D Bubble Plot"
#define SDLG_BUB3DPLOT_SCALE "scaling:"
#define SDLG_BUB3DPLOT_SCALEX "with x-values"
#define SDLG_BUB3DPLOT_SCALEY "with y-values"
#define SDLG_BUB3DPLOT_SCALEZ "with z-values"
#define SDLG_BUB3DPLOT_TEMPL "select template : "

// Create a 3D function plot
#define SDLG_FUNC3DPLOT_HD1 "3D Function Plot"
#define SDLG_FUNC3DPLOT_UDF "plot user defined function"
#define SDLG_FUNC3DPLOT_STX "where x = "
#define SDLG_FUNC3DPLOT_LASTX "until"
#define SDLG_FUNC3DPLOT_STEP "step"
#define SDLG_FUNC3DPLOT_ZEQ "z = "
#define SDLG_FUNC3DPLOT_YEQ "y = "
#define SDLG_FUNC3DPLOT_GRIDB " grid "
#define SDLG_FUNC3DPLOT_SURFB " surface "
#define SDLG_FUNC3DPLOT_GRIDR " grid lines"
#define SDLG_FUNC3DPLOT_SURFR " surface"
#define SDLG_FUNC3DPLOT_GLW "grid line width"
#define SDLG_FUNC3DPLOT_GLC "grid line color"
#define SDLG_FUNC3DPLOT_PLC "plane color"

// Fit a 3D function to data
//NOTE: This dialog uses also definitions for FitFunction and Function 3D!
#define SDLG_FITFUNC3D_HD1 "Fit Function to Data in 3D Space"
#define SDLG_FITFUNC3D_DEF "function, y=f(x,z):"
#define SDLG_FITFUNC3D_SYMS "draw symbols"
#define SDLG_FITFUNC3D_PLTX "plot x="
#define SDLG_FITFUNC3D_CHIFMT "Chi 2 = %g"

// Grid line properties
#define SDLG_GRIDL_HD1 "Grid line properties"
#define SDLG_GRIDL_TOLINE "Apply to LINE"
#define SDLG_GRIDL_TOAXIS "Apply to AXIS"
#define SDLG_GRIDL_GLINE " grid line "
#define SDLG_GRIDL_LINETO "line to:"
#define SDLG_GRIDL_LINEALIGN "parallel to:"

// Axis tick properties
#define SDLG_TICK_HD1 "Tick properties"
#define SDLG_TICK_TOTICK "Apply to TICK"
#define SDLG_TICK_TOAXIS "Apply to AXIS"
#define SDLG_TICK_SIZE "tick size"
#define SDLG_TICK_ISMAJOR "major tick"
#define SDLG_TICK_TYPE "type:"
#define SDLG_TICK_SYM "symmetric"
#define SDLG_TICK_DOGRID "draw grid line(s)"
#define SDLG_TICK_VALUE "value:"
#define SDLG_TICK_LABEL "label:"
#define SDLG_TICK_DIREC "direction of ticks"
#define SDLG_TICK_PERPEND "perpendicular to axis"
#define SDLG_TICK_ANGLE "fixed angle"
#define SDLG_TICK_DEG "deg."
#define SDLG_TICK_OUT "outside"
#define SDLG_TICK_IN "inside"
#define SDLG_TICK_POS "positive"
#define SDLG_TICK_NEG "negative"
#define SDLG_TICK_RIGHT "right"
#define SDLG_TICK_LEFT "left"
#define SDLG_TICK_UP "up"
#define SDLG_TICK_DOWN "down"

// Get axis tick values from spreadsheet
#define SDLG_SSTICK_HD1 "Choose Ticks from Spreadsheet"
#define SDLG_SSTICK_RNG1 "range for major tick VALUES:"
#define SDLG_SSTICK_RNG2 "range for major tick LABELS:"
#define SDLG_SSTICK_RNG3 "minor tick VALUES:"
#define SDLG_SSTICK_ERR "Ranges for tick values\nand tick labels must have\nthe same size"

// Axis properties
#define SDLG_AXIS_SCALE " scaling "
#define SDLG_AXIS_AUTOSC " automatic scaling"
#define SDLG_AXIS_FROM "axis from"
#define SDLG_AXIS_TO "to"
#define SDLG_AXIS_PLC " placement "
#define SDLG_AXIS_LINE " line "
#define SDLG_AXIS_LWIDTH "width"
#define SDLG_AXIS_LBL " axis label "
#define SDLG_AXIS_CX "center x"
#define SDLG_AXIS_RAD "radius"
#define SDLG_AXIS_NOTI "no ticks"
#define SDLG_AXIS_AUTI "automatic"
#define SDLG_AXIS_UCTI "leave unchanged"
#define SDLG_AXIS_MANTI "set manually "
#define SDLG_AXIS_SSVAL "use spread sheet values"
#define SDLG_AXIS_STVAL "start value"
#define SDLG_AXIS_INTV "interval"
#define SDLG_AXIS_MINT "minor ticks per interval"
#define SDLG_AXIS_ZERO "0"
#define SDLG_AXIS_TFORM "Transforms:"
#define SDLG_AXIS_TNONE "none (linear)"
#define SDLG_AXIS_TLOG "logarithmic (log base 10)"
#define SDLG_AXIS_TRECI "reciprocal (1/x)"
#define SDLG_AXIS_TSQR "square root"
#define SDLG_AXIS_LVTOP "low vaues top of graph"
#define SDLG_AXIS_LVRIGHT "low values right of graph"
#define SDLG_AXIS_BGAP "break gap"
#define SDLG_AXIS_SSIZE "symbol size"
#define SDLG_AXIS_BDATA " break data "
#define SDLG_AXIS_BFROM "from"
#define SDLG_AXIS_BTO "to"
#define SDLG_AXIS_DEL "Delete"
#define SDLG_AXIS_CGRAD " color gradient "
#define SDLG_AXIS_CFILL "use common fill color:"
#define SDLG_AXIS_RBOW_I "rainbow color gradient I"
#define SDLG_AXIS_XRBOW "extented rainbow colors"
#define SDLG_AXIS_CORGR "simple color gradient"
#define SDLG_AXIS_RBOW_II "rainbow color gradient II"
#define SDLG_AXIS_INVGR "invert gradient"
#define SDLG_AXIS_TRANS "transparency"
#define SDLG_AXIS_TLBF "  use tick label format:"
#define SDLG_AXIS_UNCH "[unchanged]"
#define SDLG_AXIS_NA "n.a."
#define SDLG_AXIS_DATA "[data]"
#define SDLG_AXIS_XAX "X-axis"
#define SDLG_AXIS_YAX "Y-axis"
#define SDLG_AXIS_ZAX "Z-axis"
#define SDLG_AXIS_GAX "Gradient Axis"
#define SDLG_AXIS_AX "Axis"
#define SDLG_AXIS_AAX "Angular Axis"
#define SDLG_AXIS_RAX "Radial Axis"
#define SDLG_AXIS_DCW "set direction cw"
#define SDLG_AXIS_PROP " Properties"
#define SDLG_AXIS_BFMT "break # %d/%d"

// Graph: add xy-plot
#define SDLG_GRAFADD_HD1 "Add Plot"
#define SDLG_GRAFADD_TMPL "select template:"
#define SDLG_GRAFADD_XY " x,y values "
#define SDLG_GRAFADD_XYY " x, many y "

//Create graph: needs a plot
#define SDLG_GRAPH_HD1 "Create graph"
#define SDLG_GRAPH_SEL "arrangement of data: select plot"
#define SDLG_GRAPH_BOUNDS "bounding rectangle (relative to page)"
#define SDLG_GRAPH_ULEFT "upper left corner x"
#define SDLG_GRAPH_LRIGHT "lower right x"
#define SDLG_GRAPH_PRECT "plotting rectangle (relative to bounding rectangle)"
#define SDLG_GRAPH_TEMPL "select template:"
#define SDLG_GRAPH_TOUT "ticks outside"
#define SDLG_GRAPH_TINS "ticks inside"
#define SDLG_GRAPH_TSYM "ticks symmetrical"
#define SDLG_GRAPH_HGRID "horizontal grid lines"
#define SDLG_GRAPH_VGRID "vertical grid lines"
#define SDLG_GRAPH_GRID " show grid"
#define SDLG_GRAPH_GRIDSPACING "grid spacing"
#define SDLG_GRAPH_GRIDCOLOR "grid color"
#define SDLG_GRAPH_SNAP " snap to grid"
#define SDLG_GRAPH_ADDGRAPH "Add Graph"

//Configure graph
//NOTE: This dialog uses some definitions from the CreateGraph dialog
#define SDLG_CGRA_HD1 "Graph"
#define SDLG_CGRA_HD2 " properties"
#define SDLG_CGRA_ADDPLT "Add Plot"
#define SDLG_CGRA_ADDAX "Add Axis"
#define SDLG_CGRA_ADDLEG "Add Legend"
#define SDLG_CGRA_LAYERS "Layers"
#define SDLG_CGRA_CLIP " enable clipping to data rectangle"
#define SDLG_CGRA_BRC "bounding rectangle"
#define SDLG_CGRA_FILLC "fill color"
#define SDLG_CGRA_OUTLC "outline color"
#define SDLG_CGRA_PRC "plotting rectangle"
#define SDLG_CGRA_AXTILA "axes, ticks, and axis labels"
#define SDLG_CGRA_AXCOL "axis color"

//Add new axis to current graph
#define SDLG_ADDA_HD1 "New axis properties"
#define SDLG_ADDA_SCALE " scaling "
#define SDLG_ADDA_ASCALE " automatic scaling"
#define SDLG_ADDA_FROM "axis from"
#define SDLG_ADDA_TO "to"
#define SDLG_ADDA_LIN " line "
#define SDLG_ADDA_LWIDTH "width"
#define SDLG_ADDA_LBL " axis label "
#define SDLG_ADDA_TMPL "select a template:"
#define SDLG_ADDA_PLC " placement "
#define SDLG_ADDA_NONE "[none]"

//Page properties
#define SDLG_PAGE_HD1 "Page"
#define SDLG_PAGE_HD2 " properties"
#define SDLG_PAGE_LAYER "Layers"

// Edit global defaults
#define SDLG_DEFS_HD1 "Edit Global Preferences"
#define SDLG_DEFS_TSIZE "text size"
#define SDLG_DEFS_PIX "pixel"
#define SDLG_DEFS_DFMT "date format : "
#define SDLG_DEFS_DTFMT "date + time format : "
#define SDLG_DEFS_TFMT "time format : "
#define SDLG_DEFS_FMT_INFO "For further information about formats see"
#define SDLG_DEFS_TEST "Test"
#define SDLG_DEFS_INTL "edit country specific information"
#define SDLG_DEFS_DECP "decimal point"
#define SDLG_DEFS_CSEP "column separator"
#define SDLG_DEFS_UNITS "use units : "
#define SDLG_DEFS_ADJ "adjust dialog window size:"
#define SDLG_DEFS_XINC "width increment"
#define SDLG_DEFS_YINC "height increment"
#define SDLG_DEFS_FILE "setup information file:"

//Get bitmap resolution for export
#define SDLG_EXP_HD1 "Export Tag Image File"
#define SDLG_EXP_PROP "image properties:"
#define SDLG_EXP_WIDTH "width"
#define SDLG_EXP_HEIGHT "height"
#define SDLG_EXP_RES "resolution"
#define SDLG_EXP_DPI "dpi"

//show layers of graph or page
#define SDLG_LAYERS_HD1 "Layer Control"
#define SDLG_LAYERS_HIDDEN "hidden"
#define SDLG_LAYERS_VISIBLE "visible"
#define SDLG_LAYERS_LAYERS "Layers:"
#define SDLG_LAYERS_ROOT "(root)"
#define SDLG_LAYERS_MOVEABLE " object is moveable"

//change spreadsheet widt and height
#define SDLG_WH_HD "Change spread sheet settings"
#define SDLG_WH_NCOL "number of columns:"
#define SDLG_WH_NROW "number of rows:"
#define SDLG_WH_ROWBUTT "row buttons"
#define SDLG_WH_DIGITS "[digits]"
#define SDLG_WH_COLW "column width"
#define SDLG_WH_ROWH "row height"
#define SDLG_WH_TXTS "text size"

//operate on spreadsheet range
#define SDLG_SSARITH_HD "Spreadsheet Range Arithmetics"
#define SDLG_SSARITH_RNG "operate on range:"
#define SDLG_SSARITH_OP "operation:  y ="
#define SDLG_SSARITH_FUNC "y*1.0"
#define SDLG_SSARITH_VAL " apply to numerical values only"
#define SDLG_SSARITH_ANY " apply to any numerical result"

//the about rlplot dialog
#define SDLG_ABOUT_HD "RLPlot"
#define SDLG_ABOUT_PGM "scientific plotting program"
#define SDLG_ABOUT_CPYR "Copyright (C) 2002-2025 R. Lackner"
#define SDLG_ABOUT_EMAIL "mailto:lacknerreinhard3@gmail.com"
#define SDLG_ABOUT_FREE "This is free software published"
#define SDLG_ABOUT_GNU "under the GNU general public"
#define SDLG_ABOUT_GPL "license (GPL)."

//report linear regression analysis
#define SDLG_REPREGR_HD "<b>Regression:</b>"
#define SDLG_REPREGR_SLP "slope = %g"
#define SDLG_REPREGR_ICP "intercept = %g"
#define SDLG_REPREGR_OBS "observations = %g"
#define SDLG_REPREGR_R2 "r<sup> 2</sup> = %g"
#define SDLG_REPREGR_R "r = %g"
#define SDLG_REPREGR_CI "%g%% C.I."

//... and results table for regression and anova
#define SDLG_REPREGR_DF "<i>df</i>"
#define SDLG_REPREGR_SS "<i>SS</i>"
#define SDLG_REPREGR_F "<i>F</i>"
#define SDLG_REPREGR_P "<i>P</i>"
#define SDLG_REPREGR_SV "Source of variation"
#define SDLG_REPREGR_EBR "Explained by regression"
#define SDLG_REPREGR_AG "Among groups"
#define SDLG_REPREGR_UE "Unexplained"
#define SDLG_REPREGR_WG "Within groups"
#define SDLG_REPREGR_TOT "Total"
#define SDLG_REPREGR_BWR "Between rows"
#define SDLG_REPREGR_BWC "Between columns"
#define SDLG_REPREGR_IA "Interaction"
#define SDLG_REPREGR_WGS "Within subgroups (error)"
#define SDLG_REPREGR_ERR "Error"

//the bootstrap mean dialog
#define SDLG_BTMEAN_HD "Bootstrap Mean"
#define SDLG_BTMEAN_RANGE "range for variables"
#define SDLG_BTMEAN_ITER "number of iterations:"
#define SDLG_BTMEAN_HDMEAN "<b>Bootstrap Mean for \""
#define SDLG_BTMEAN_HDITER "\" with %ld iterations</b>"
#define SDLG_BTMEAN_YAXIS "number of means"
#define SDLG_BTMEAN_XA "arithmetic means"
#define SDLG_BTMEAN_XG "geometric means"
#define SDLG_BTMEAN_XH "harmonic means"
#define SDLG_BTMEAN_GNA "a-mean graph"
#define SDLG_BTMEAN_GNG "g-mean graph"
#define SDLG_BTMEAN_GNH "h-mean graph"
#define SDLG_BTMEAN_RA "arithmetic mean"
#define SDLG_BTMEAN_RG "geometric mean"
#define SDLG_BTMEAN_RH "harmonic mean"

//the bootstrap regression dialog
#define SDLG_BTREGR_HD "Bootstrap Regression"
#define SDLG_BTREGR_X "range for independent variable (x)"
#define SDLG_BTREGR_Y "range for dependent variable (y)"
#define SDLG_BTREGR_ITER "number of iterations:"
#define SDLG_BTREGR_REPI "\" with %ld iterations"
#define SDLG_BTREGR_REPF "y = %.4g + x * %.4g"
#define SDLG_BTREGR_REPA "Intercept"
#define SDLG_BTREGR_REPNA "number of intercepts"
#define SDLG_BTREGR_REPB "Slope"
#define SDLG_BTREGR_REPNB "number of slopes"
#define SDLG_BTREGR_REGR "<b>Regression</b>"
#define SDLG_BTREGR_BTREGR "<b>Bootstrap Regression for \""

//sample stats dialog
#define SDLG_SMPSTAT_HD "Sample Statistics"
#define SDLG_SMPSTAT_RNG "rectangular range for variables"
#define SDLG_SMPSTAT_QUANT "Normal quantiles"
#define SDLG_SMPSTAT_SSTAT "<b>Sample Statistics for \""
#define SDLG_SMPSTAT_DESC "<b>Descriptive Statistics:</b>"
#define SDLG_SMPSTAT_NDIST "<b>Test for Normal Distribution:</b>"
#define SDLG_SMPSTAT_KOL "Kolmogorov-Smirnov D = %.4lf, P "
#define SDLG_SMPSTAT_SWW "Shapiro-Wilk W = %.4lf, P "

//compare two groups via mean and median
//mostly using definitions from elsewhere
#define SDLG_CMPMEANS_HD "Compare Means"

//simple linear regression
#define SDLG_REGR_HD "Linear Regression"
#define SDLG_REGR_INCO " include origin"


//the bootstrap correllation dialog
#define SDLG_BTCORR_HD "Bootstrap Correlation"
#define SDLG_BTCORR_V1 "range for variable 1"
#define SDLG_BTCORR_V2 "range for variable 2"
#define SDLG_BTCORR_NITER "number of iterations:"
#define SDLG_BTCORR_RSEED "random number seed:"
#define SDLG_BTCORR_RADD " add random error to resampled data"
#define SDLG_BTCORR_INF1 "(This option reduces the effect"
#define SDLG_BTCORR_INF2 "of ties in rank order statistics)"
#define SDLG_BTCORR_RESIZE "random error size:"
#define SDLG_BTCORR_REPH1 "<b>Bootstrap Correlation for \""
#define SDLG_BTCORR_REPH2 "\" vs. \""
#define SDLG_BTCORR_REPH3 "\" with %d Iterations"
#define SDLG_BTCORR_AX1 "number of correlations"
#define SDLG_BTCORR_AXP "Pearson's R<ssub>P</ssub>"
#define SDLG_BTCORR_AXS "Spearman's rho, R<ssub>S</ssub>"
#define SDLG_BTCORR_AXK "Kendall's tau, R<ssub>K</ssub>"

//the bootstrap function dialog
#define SDLG_BTFUNC_HD "Bootstrap Function"
#define SDLG_BTFUNC_HD1 "Bootstrap fitted function"
#define SDLG_BTFUNC_HD2 "using the \'Levenberg Marquart\' algorithm"
#define SDLG_BTFUNC_HD3 "using the \'Simplex\' algorithm"
#define SDLG_BTFUNC_END "The \'%s\' exited after %ld iterations"
#define SDLG_BTFUNC_CHI2 "Chi2 = %g, n = %ld"
#define SDLG_BTFUNC_ITER "number of iterations:"
#define SDLG_BTFUNC_REPHD "<b>Bootstrap the Fitted Function</b>"
#define SDLG_BTFUNC_HDP "<b>Parameters</b>"
#define SDLG_BTFUNC_HDS1 "Data from range  "
#define SDLG_BTFUNC_HDS2 "and from  "
#define SDLG_BTFUNC_HDS3 "File:  "
#define SDLG_BTFUNC_N "using %ld valid values out of %ld"
#define SDLG_BTFUNC_FF "Fitted function: "
#define SDLG_BTFUNC_XAXIS "parameter \'%s\'"
#define SDLG_BTFUNC_YAXIS "number of observations"
#define SDLG_BTFUNC_PLOTS "Plots:"
#define SDLG_BTFUNC_REP1 " parameter histograms"
#define SDLG_BTFUNC_REP2 " function and residuals"

