/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.sequence;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import uibk.applets.sequence.AppletSequence;
import uibk.applets.sequence.Messages;
import uibk.applets.sequence.PanelCommand;
import uibk.mtk.draw2d.objects.GraphSequence;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Sequence;
import uibk.mtk.math.parsing.Misc;

public class InteractionControl
implements ActionListener {
    PanelCommand panelcommand;
    AppletSequence main;
    private boolean restart = true;
    private int countplots;
    private String input;

    public InteractionControl(AppletSequence main, PanelCommand panelcommand) {
        this.main = main;
        this.panelcommand = panelcommand;
    }

    private Sequence getSequence() {
        try {
            String strfunc = this.panelcommand.textFormula.getText();
            return this.main.sequenceparser.parse(strfunc, "n");
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("InteractionControl.ErrorFunction"), e);
            return null;
        }
    }

    private double[] getInitials() {
        try {
            String strinitials = this.panelcommand.textInitials.getText();
            return Misc.parseInitalValues(strinitials, Messages.getString("InteractionControl.InitialValue"));
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("InteractionControl.ErrorInitialValues"), e);
            return null;
        }
    }

    private int[] getStartEnd() {
        try {
            int start = this.panelcommand.textSequenceStart.getValue();
            int end = this.panelcommand.textSequenceEnd.getValue();
            return new int[]{start, end};
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("InteractionControl.ErrorIndices"), e);
            return null;
        }
    }

    private void clear() {
        this.main.graphfolgen.clear();
        this.main.axes.setVisible(false);
        this.restart = true;
        this.countplots = 0;
        this.main.mathpanel2d.repaint();
        this.main.mathpanel2d.report(Messages.getString("InteractionControl.DrawingAreaIsClosed"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals(Messages.getString("InteractionControl.Clear"))) {
            this.clear();
        }
        if (ev.getActionCommand().equals(Messages.getString("InteractionControl.Compute"))) {
            this.compute();
        }
    }

    private String getInputString() {
        String start = this.panelcommand.textSequenceStart.getText();
        String formula = this.panelcommand.textFormula.getText();
        String end = this.panelcommand.textSequenceEnd.getText();
        String initials = this.panelcommand.textInitials.getText();
        return (String.valueOf(start) + formula + end + initials).trim();
    }

    private void compute() {
        double[] initials;
        if (!this.panelcommand.optsingleplot.isSelected() && !this.restart && this.input != null && this.input.equals(this.getInputString())) {
            return;
        }
        this.input = null;
        Sequence sequence = this.getSequence();
        int[] startend = this.getStartEnd();
        if (sequence == null || startend == null) {
            return;
        }
        if (sequence.getType() == 0) {
            initials = this.getInitials();
            if (initials == null) {
                return;
            }
        } else {
            if (!this.panelcommand.textInitials.getText().equals("")) {
                this.main.mathpanel2d.reportError(Messages.getString("InteractionControl.DeleteInitivalValue"));
                return;
            }
            initials = null;
        }
        this.calcplot(sequence, initials, startend[0], startend[1]);
    }

    private void calcplot(Sequence sequence, double[] initials, int start, int end) {
        double[] seq = null;
        try {
            seq = sequence.compute(initials, start, end);
            if (this.panelcommand.optsingleplot.isSelected()) {
                this.countplots = 0;
                this.restart = true;
                this.main.graphfolgen.clear();
            }
            GraphSequence graph = new GraphSequence();
            graph.setFormula(sequence.getFormula());
            this.main.graphfolgen.addGraph(graph);
            graph.setSequence(seq, start, end);
            graph.setLineColor(AppletSequence.LINECOLORS[this.countplots % 6]);
            graph.setColor(AppletSequence.POINTCOLORS[this.countplots % 6]);
            this.main.axes.setVisible(true);
            CoordinateRect2D limits = graph.getLimits();
            if (this.restart) {
                this.main.mathpanel2d.getScene2d().setLimits(limits);
            } else {
                this.main.mathpanel2d.getScene2d().ensureLimits(limits);
            }
            this.restart = false;
            this.main.mathpanel2d.reportSuccess(String.valueOf(Messages.getString("InteractionControl.Folge")) + sequence.getFormula() + Messages.getString("InteractionControl.FinishedDrawing"));
            this.input = this.getInputString();
            ++this.countplots;
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
        }
        this.main.mathpanel2d.repaint();
    }
}

