/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.example.zooom.CONSTANTS;

public class UIObject {
    private Vector2 pos;
    private float scale;
    private String name;
    private Texture texture;
    private Sprite sprite;
    private Rectangle boundingRectangle;
    private float width;
    private float height;
    private boolean press = false;
    private boolean release = false;

    public UIObject(String name, float scale, Vector2 pos) {
        this.name = name;
        this.pos = pos;
        this.scale = scale;
        this.texture = new Texture(Gdx.files.internal(name + ".png"), true);
        this.texture.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
        this.sprite = new Sprite(this.texture);
        this.width = this.sprite.getWidth();
        this.height = this.sprite.getHeight();
        this.sprite.setScale(CONSTANTS.screenScale * scale);
        this.sprite.setOriginBasedPosition(pos.x - this.width * CONSTANTS.screenScale * scale * 0.5f, pos.y - this.height * CONSTANTS.screenScale * scale * 0.5f);
        this.boundingRectangle = this.sprite.getBoundingRectangle();
    }

    public void update() {
    }

    public void draw(PolygonSpriteBatch batch) {
        this.sprite.draw(batch);
    }

    public void press(boolean press) {
        this.press = press;
        if (press) {
            this.sprite.setScale(CONSTANTS.screenScale * this.scale * 0.9f);
        } else {
            this.sprite.setScale(CONSTANTS.screenScale * this.scale);
        }
    }

    public boolean release(boolean release) {
        return this.press;
    }

    public void dispose() {
        this.texture.dispose();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public Rectangle getBoundingRectangle() {
        return this.boundingRectangle;
    }
}

