/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.example.zooom.CONSTANTS;
import com.example.zooom.Font;
import java.util.ArrayList;

public class Text {
    private String lang;
    private String name;
    private Vector2 pos;
    private Vector2 posnew;
    private float base;
    private String text;
    private float scalefactor;
    private float alpha;
    private boolean drawable;
    private Font font;
    private String type;
    private Rectangle moreRectangle1;
    private Rectangle moreRectangle;
    private boolean press = false;
    private ArrayList<TextPart> parts;
    private boolean touch;
    private Vector2 pos2;
    private Vector2 touchpos1;
    private Vector2 touchpos2;

    public Text(String lang, String name, float base, float x, float y, String text, Font font, String type) {
        this.lang = lang;
        this.name = name;
        this.base = base;
        this.pos = new Vector2(x, y);
        this.posnew = new Vector2();
        this.text = text;
        this.font = font;
        this.type = type;
        this.touch = false;
        this.pos2 = new Vector2(0.0f, 0.0f);
        this.touchpos1 = new Vector2(0.0f, 0.0f);
        this.touchpos2 = new Vector2(0.0f, 0.0f);
        this.moreRectangle1 = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        this.moreRectangle = new Rectangle();
        this.format();
    }

    public Text(String lang, String name, String base, String x, String y, String text, Font font, String type) {
        this(lang, name, Float.parseFloat(base), Float.parseFloat(x), Float.parseFloat(y), text, font, type);
    }

    public void update(float zoomfactor) {
        this.scalefactor = (float)Math.pow(10.0, zoomfactor - this.base) * CONSTANTS.screenScale;
        this.posnew.x = this.pos.x * this.scalefactor + (float)Gdx.graphics.getWidth() / 2.0f + this.pos2.x * this.scalefactor;
        this.posnew.y = this.pos.y * this.scalefactor + (float)Gdx.graphics.getHeight() / 2.0f - this.pos2.y * this.scalefactor;
        if (this.type.equals("text")) {
            this.posnew.x += CONSTANTS.center.x;
            this.posnew.y += CONSTANTS.center.y;
        }
        this.moreRectangle.set(this.posnew.x + this.moreRectangle1.x * this.scalefactor, this.posnew.y + this.moreRectangle1.y * this.scalefactor - this.moreRectangle1.height * this.scalefactor, this.moreRectangle1.width * this.scalefactor, this.moreRectangle1.height * this.scalefactor);
        this.alpha = ((zoomfactor - this.base) * (zoomfactor - this.base) - 1.0f) * -1.25f;
        this.drawable = !(this.alpha < 0.0f);
    }

    public void draw(PolygonSpriteBatch batch) {
        if (!this.lang.equals(CONSTANTS.lang)) {
            return;
        }
        if (this.drawable) {
            for (TextPart part : this.parts) {
                this.font.draw(batch, part.text, (int)(this.posnew.x + part.pos.x * this.scalefactor), (int)(this.posnew.y + part.pos.y * this.scalefactor), this.scalefactor, new Color(part.color.r, part.color.g, part.color.b, this.alpha), part.italic, part.bold);
            }
        }
    }

    private void format() {
        this.parts = new ArrayList();
        boolean italic = false;
        boolean bold = false;
        Color color = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        Vector2 pos = new Vector2(0.0f, 0.0f);
        String[] temp = this.text.split("\\*");
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].length() == 0) continue;
            switch (temp[i].charAt(0)) {
                case 'r': {
                    italic = false;
                    bold = false;
                    temp[i] = temp[i].substring(1);
                    break;
                }
                case 'i': {
                    italic = true;
                    temp[i] = temp[i].substring(1);
                    break;
                }
                case 'b': {
                    bold = true;
                    temp[i] = temp[i].substring(1);
                    break;
                }
                case 'c': {
                    color.set(Float.parseFloat(String.valueOf(temp[i].charAt(1))), Float.parseFloat(String.valueOf(temp[i].charAt(2))), Float.parseFloat(String.valueOf(temp[i].charAt(3))), 1.0f);
                    temp[i] = temp[i].substring(4);
                    break;
                }
                case 'n': {
                    pos.x = 0.0f;
                    pos.y -= this.font.lineHeight;
                    temp[i] = temp[i].substring(1);
                    break;
                }
                case 'z': {
                    temp[i] = temp[i].substring(1);
                    this.moreRectangle1.set(pos.x, pos.y, this.font.getWidth(temp[i], italic, bold), this.font.getHeight(temp[i], italic, bold));
                }
            }
            this.parts.add(new TextPart(temp[i], new Vector2(pos.x, pos.y), new Color(color.r, color.g, color.b, color.a), italic, bold));
            pos.x += this.font.getWidth(temp[i], italic, bold);
        }
    }

    public String getName() {
        return this.name;
    }

    public Rectangle getMoreRectangle() {
        return new Rectangle(this.moreRectangle.x - this.moreRectangle.width * 0.15f, this.moreRectangle.y - this.moreRectangle.height * 0.7f, this.moreRectangle.width * 1.3f, this.moreRectangle.height * 2.4f);
    }

    public void press(boolean press) {
        this.press = press;
        if (press) {
            this.parts.get((int)(this.parts.size() - 1)).color.set(0.6f, 0.0f, 0.9f, 1.0f);
        } else {
            this.parts.get((int)(this.parts.size() - 1)).color.set(0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    public boolean release(boolean release) {
        return this.press;
    }

    public String getLang() {
        return this.lang;
    }

    public void touch(boolean touch) {
        if (CONSTANTS.lang.equals(this.lang) && this.alpha > 0.5f) {
            this.touch = touch;
        }
        if (this.touch) {
            this.touchpos1.set(this.touchpos2);
            this.touchpos2.set(Gdx.input.getX(), Gdx.input.getY());
        } else {
            this.touchpos2.set(0.0f, 0.0f);
            this.touchpos1.set(this.touchpos2);
        }
        if (this.touchpos1.x != 0.0f || this.touchpos1.y != 0.0f) {
            this.pos2.x += (this.touchpos2.x - this.touchpos1.x) / this.scalefactor;
            this.pos2.y += (this.touchpos2.y - this.touchpos1.y) / this.scalefactor;
        }
    }

    public Rectangle getBoundingRectangle() {
        return new Rectangle(this.posnew.x, this.posnew.y - 100.0f * this.scalefactor, 100.0f * this.scalefactor, 100.0f * this.scalefactor);
    }

    private class TextPart {
        public String text;
        public Vector2 pos;
        public Color color;
        public boolean italic;
        public boolean bold;

        public TextPart(String text2, Vector2 pos, Color color, boolean italic, boolean bold) {
            this.text = text2;
            this.pos = pos;
            this.color = color;
            this.italic = italic;
            this.bold = bold;
        }
    }
}

