/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.example.zooom.CONSTANTS;
import com.example.zooom.Font;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class Ruler {
    private String name;
    private float base;
    private Vector2 pos;
    private Vector2 schriftpos;
    private Vector2 schriftpos2;
    private Rectangle rect;
    private Rectangle rect2;
    private Rectangle rect3;
    private float alpha;
    private float scalefactor;
    private boolean drawable;
    private Font font;
    private int hoehe = 15;
    private int laenge = 50;
    private int dicke = 3;
    private int abstand = 10 + this.dicke;
    private float schriftgroesse = 1.0f;
    private float textbreite;
    private float texthoehe;

    public Ruler(String name, String base, String x, String y, String schriftpos, Font font) {
        this.name = name;
        this.base = Float.parseFloat(base);
        this.pos = new Vector2(Float.parseFloat(x), Float.parseFloat(y));
        this.font = font;
        this.schriftpos = new Vector2();
        this.schriftpos2 = new Vector2();
        this.schriftgroesse = CONSTANTS.schriftGroesse;
        this.textbreite = font.getWidth(name);
        this.texthoehe = font.getHeight(name);
        this.schriftpos.x = 0.0f;
        this.schriftpos.y = this.texthoehe * this.schriftgroesse + (float)this.abstand;
    }

    public void update(float zoomfactor) {
        this.alpha = ((zoomfactor - this.base) * (zoomfactor - this.base) - 0.9f) * -1.5f;
        if (this.alpha < 0.0f) {
            this.drawable = false;
            return;
        }
        this.drawable = true;
        this.scalefactor = (float)Math.pow(10.0, zoomfactor - this.base);
        this.pos.x = (float)(-CONSTANTS.logicalWidth) * 0.45f;
        this.pos.y = -200.0f - 90.0f * (zoomfactor - this.base + 1.0f) * 0.5f;
        this.rect = new Rectangle(this.pos.x + (float)this.dicke, this.pos.y, (float)(2 * this.laenge) * this.scalefactor - (float)this.dicke, this.dicke);
        this.rect2 = new Rectangle(this.pos.x, this.pos.y - (float)(this.hoehe - this.dicke) * 0.5f, this.dicke, this.hoehe);
        this.rect3 = new Rectangle(this.pos.x + (float)(2 * this.laenge) * this.scalefactor, this.pos.y - (float)(this.hoehe - this.dicke) * 0.5f, this.dicke, this.hoehe);
        this.schriftpos2.set(this.pos);
        this.schriftpos2.add(this.schriftpos);
        this.setScale(this.rect, this.rect2, this.rect3, CONSTANTS.screenScale);
        this.setRelativePosition(this.rect, this.rect2, this.rect3, (float)CONSTANTS.screenWidth * 0.5f, (float)CONSTANTS.screenHeight * 0.5f);
        this.schriftpos2.x *= CONSTANTS.screenScale;
        this.schriftpos2.y *= CONSTANTS.screenScale;
        this.schriftpos2.add((float)CONSTANTS.screenWidth * 0.5f, (float)CONSTANTS.screenHeight * 0.5f);
    }

    public void draw(ShapeDrawer drawer, PolygonSpriteBatch batch) {
        if (this.drawable) {
            drawer.filledRectangle(this.rect, new Color(0.0f, 0.0f, 0.0f, this.alpha));
            drawer.filledRectangle(this.rect2, new Color(0.0f, 0.0f, 0.0f, this.alpha));
            drawer.filledRectangle(this.rect3, new Color(0.0f, 0.0f, 0.0f, this.alpha));
        }
        this.font.draw(batch, this.name, (int)this.schriftpos2.x, (int)this.schriftpos2.y, this.schriftgroesse * CONSTANTS.screenScale, new Color(0.0f, 0.0f, 0.0f, this.alpha));
    }

    private void setScale(Rectangle rect, float scale) {
        rect.setSize(rect.width * scale, rect.height * scale);
        rect.setPosition(rect.x * scale, rect.y * scale);
    }

    private void setScale(Rectangle rect, Rectangle rect1, float scale) {
        rect1.setSize(rect1.width * scale, rect1.height * scale);
        rect1.setPosition(rect1.x * scale, rect1.y * scale);
        this.setScale(rect, scale);
    }

    private void setScale(Rectangle rect, Rectangle rect1, Rectangle rect2, float scale) {
        rect2.setSize(rect2.width * scale, rect2.height * scale);
        rect2.setPosition(rect2.x * scale, rect2.y * scale);
        this.setScale(rect, rect1, scale);
    }

    private void setRelativePosition(Rectangle rect, float x, float y) {
        rect.setPosition(rect.x + x, rect.y + y);
    }

    private void setRelativePosition(Rectangle rect, Rectangle rect1, float x, float y) {
        rect1.setPosition(rect1.x + x, rect1.y + y);
        this.setRelativePosition(rect, x, y);
    }

    private void setRelativePosition(Rectangle rect, Rectangle rect1, Rectangle rect2, float x, float y) {
        rect2.setPosition(rect2.x + x, rect2.y + y);
        this.setRelativePosition(rect, rect1, x, y);
    }

    private class Triangle {
        public float x1;
        public float x2;
        public float x3;
        public float y1;
        public float y2;
        public float y3;

        public Triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.x1 = x1;
            this.x2 = x2;
            this.x3 = x3;
            this.y1 = y1;
            this.y2 = y2;
            this.y3 = y3;
        }

        public void add(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.x1 += x1;
            this.y1 += y1;
            this.x2 += x2;
            this.y2 += y2;
            this.x3 += x3;
            this.y3 += y3;
        }

        public void add(float x, float y) {
            this.x1 += x;
            this.y1 += y;
            this.x2 += x;
            this.y2 += y;
            this.x3 += x;
            this.y3 += y;
        }

        public Triangle() {
            this.x1 = 0.0f;
            this.x2 = 0.0f;
            this.x3 = 0.0f;
            this.y1 = 0.0f;
            this.y2 = 0.0f;
            this.y3 = 0.0f;
        }

        public void set(Triangle triangle) {
            this.x1 = triangle.x1;
            this.x2 = triangle.x2;
            this.x3 = triangle.x3;
            this.y1 = triangle.y1;
            this.y2 = triangle.y2;
            this.y3 = triangle.y3;
        }
    }
}

