/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.example.zooom.CONSTANTS;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class Regler {
    public boolean touched;
    private boolean jump;
    private float newZoomfactor;
    private float zoomMax;
    private float zoomMin;
    private float height;
    private float bremse = 2.0f;
    private boolean jumpable = false;
    private float borderTop = 0.2f;
    private float borderBottom = 0.15f;
    private float borderRight = 0.95f;
    private Vector2 startPos;
    private Vector2 pos;
    private Texture regler_mitte_tex;
    private Texture regler_top_tex;
    private Texture regler_bottom_tex;
    private Texture regler_regler_tex;
    private Sprite regler_mitte;
    private Sprite regler_top;
    private Sprite regler_bottom;
    private Sprite regler_regler;
    private Rectangle touchRect;
    private float touchRectX = 2.0f;
    private float touchRectY = 4.0f;

    public Regler(float zoomMin, float zoomMax) {
        this.zoomMin = zoomMin;
        this.zoomMax = zoomMax;
        this.touched = false;
        this.jump = false;
        this.pos = new Vector2();
        this.startPos = new Vector2((float)CONSTANTS.screenWidth * this.borderRight, (float)CONSTANTS.screenHeight * this.borderBottom);
        this.height = (float)CONSTANTS.screenHeight - (float)CONSTANTS.screenHeight * (this.borderBottom + this.borderTop);
        this.regler_top_tex = new Texture(Gdx.files.internal("regler_top.png"));
        this.regler_mitte_tex = new Texture(Gdx.files.internal("regler_mitte.png"));
        this.regler_bottom_tex = new Texture(Gdx.files.internal("regler_bottom.png"));
        this.regler_regler_tex = new Texture(Gdx.files.internal("regler_regler.png"));
        this.regler_top = new Sprite(this.regler_top_tex);
        this.regler_mitte = new Sprite(this.regler_mitte_tex);
        this.regler_bottom = new Sprite(this.regler_bottom_tex);
        this.regler_regler = new Sprite(this.regler_regler_tex);
        this.regler_mitte.setPosition(this.startPos.x - this.regler_mitte.getWidth() * CONSTANTS.screenScale * 0.5f, this.startPos.y);
        this.regler_mitte.setSize(this.regler_mitte.getWidth() * CONSTANTS.screenScale, this.height);
        this.regler_bottom.setPosition(this.startPos.x - this.regler_bottom.getWidth() * CONSTANTS.screenScale * 0.5f, this.startPos.y - this.regler_bottom.getHeight() * CONSTANTS.screenScale);
        this.regler_bottom.setSize(this.regler_bottom.getWidth() * CONSTANTS.screenScale, this.regler_bottom.getHeight() * CONSTANTS.screenScale);
        this.regler_top.setPosition(this.startPos.x - this.regler_top.getWidth() * CONSTANTS.screenScale * 0.5f, this.startPos.y + this.height);
        this.regler_top.setSize(this.regler_top.getWidth() * CONSTANTS.screenScale, this.regler_top.getHeight() * CONSTANTS.screenScale);
        this.regler_regler.setScale(CONSTANTS.screenScale);
        this.regler_regler.setOriginBasedPosition(this.startPos.x, this.startPos.y);
        this.touchRect = new Rectangle(this.regler_regler.getBoundingRectangle());
    }

    public float update(float zoomfactor) {
        this.newZoomfactor = zoomfactor;
        if (this.touched) {
            this.newZoomfactor = ((float)(CONSTANTS.screenHeight - Gdx.input.getY()) - (float)CONSTANTS.screenHeight * this.borderBottom) / this.height * (this.zoomMax - this.zoomMin) + this.zoomMin;
            if (!this.jump || !this.jumpable) {
                float bremsenanpassung = (this.newZoomfactor - zoomfactor) * (this.newZoomfactor - zoomfactor) * 0.125f;
                if (bremsenanpassung < 1.0f) {
                    bremsenanpassung = 1.0f;
                }
                if (this.newZoomfactor - zoomfactor >= this.bremse * Gdx.graphics.getDeltaTime()) {
                    this.newZoomfactor = zoomfactor + this.bremse * Gdx.graphics.getDeltaTime() * bremsenanpassung;
                } else if (this.newZoomfactor - zoomfactor < -this.bremse * Gdx.graphics.getDeltaTime()) {
                    this.newZoomfactor = zoomfactor - this.bremse * Gdx.graphics.getDeltaTime() * bremsenanpassung;
                }
            } else {
                this.jump = false;
            }
            if (this.newZoomfactor >= this.zoomMax) {
                this.newZoomfactor = this.zoomMax;
            } else if (this.newZoomfactor <= this.zoomMin) {
                this.newZoomfactor = this.zoomMin;
            }
        }
        this.pos.y = this.height / (this.zoomMax - this.zoomMin) * (zoomfactor - this.zoomMin);
        this.regler_regler.setOriginBasedPosition(this.startPos.x + this.pos.x, this.startPos.y + this.pos.y);
        return this.newZoomfactor;
    }

    public void draw(ShapeDrawer drawer, PolygonSpriteBatch batch) {
        this.regler_mitte.draw(batch);
        this.regler_top.draw(batch);
        this.regler_bottom.draw(batch);
        this.regler_regler.draw(batch);
    }

    public boolean isTouched(float x, float y) {
        this.touchRect.set(this.regler_regler.getBoundingRectangle());
        this.touchRect.setPosition(this.touchRect.x - this.touchRect.width * (this.touchRectX - 1.0f) * 0.5f, this.touchRect.y - this.touchRect.height * (this.touchRectY - 1.0f) * 0.5f);
        this.touchRect.setSize(this.touchRect.width * this.touchRectX, this.touchRect.height * this.touchRectY);
        if (this.touchRect.contains(x, y)) {
            return true;
        }
        if ((this.regler_top.getBoundingRectangle().contains(x, y) || this.regler_mitte.getBoundingRectangle().contains(x, y) || this.regler_bottom.getBoundingRectangle().contains(x, y)) && !this.touched) {
            this.jump = true;
            return true;
        }
        return false;
    }

    public void touched(boolean touched) {
        this.touched = touched;
    }

    public void dispose() {
        this.regler_bottom_tex.dispose();
        this.regler_top_tex.dispose();
        this.regler_mitte_tex.dispose();
        this.regler_regler_tex.dispose();
    }
}

