/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import com.example.zooom.CONSTANTS;

public class Object {
    public String name;
    private String texture;
    private float base;
    private Vector2 pos;
    public Sprite object;
    private float scalefactor;
    private boolean visible;
    private TextureAtlas atlas;
    private Animation<TextureRegion> animation;
    private float stateTime;
    private float frameDuration;
    private boolean touch;
    private Vector2 pos2;
    private Vector2 touchpos1;
    private Vector2 touchpos2;

    public Object(String name, String texture, String base, String x, String y) {
        this.name = name;
        this.texture = texture;
        try {
            this.base = Float.parseFloat(base);
        }
        catch (Exception e) {
            this.base = 0.0f;
            Gdx.app.log("ERROR", "Exception while creating object '" + name + "'");
        }
        try {
            this.pos = new Vector2(Integer.valueOf(x).intValue(), Integer.valueOf(y).intValue());
        }
        catch (Exception e) {
            this.pos = new Vector2(0.0f, 0.0f);
            Gdx.app.log("ERROR", "Exception while creating the object '" + name + "'");
        }
        this.loadTexture();
        this.touch = false;
        this.pos2 = new Vector2(0.0f, 0.0f);
        this.touchpos1 = new Vector2(0.0f, 0.0f);
        this.touchpos2 = new Vector2(0.0f, 0.0f);
    }

    private void loadTexture() {
        if (this.texture.split(":")[0].equals("animation")) {
            this.frameDuration = Float.parseFloat(this.texture.split(":")[1]);
            this.texture = this.texture.split(":")[0];
            this.atlas = new TextureAtlas(CONSTANTS.android ? Gdx.files.external("zooom/animations/" + this.name + ".atlas") : Gdx.files.internal("animations/" + this.name + ".atlas"));
            this.animation = new Animation<TextureAtlas.AtlasRegion>(this.frameDuration, this.atlas.findRegions("carbon"), Animation.PlayMode.LOOP);
            this.stateTime = 0.0f;
            this.object = new Sprite(this.animation.getKeyFrame(0.0f));
        } else {
            Texture tempTexture = new Texture(CONSTANTS.android ? Gdx.files.external("zooom/objects/" + this.texture) : Gdx.files.internal("objects/" + this.texture), !CONSTANTS.html);
            if (!CONSTANTS.developerMode && !CONSTANTS.html) {
                tempTexture.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
            } else {
                tempTexture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
            }
            this.object = new Sprite(tempTexture);
        }
    }

    public void update(float zoomfactor) {
        if (zoomfactor - this.base < -3.0f || zoomfactor - this.base > 1.0f) {
            this.visible = false;
            if (!CONSTANTS.developerMode) {
                return;
            }
        } else {
            this.visible = true;
        }
        if (this.texture.equals("animation")) {
            this.stateTime += Gdx.graphics.getDeltaTime();
            this.object = new Sprite(this.animation.getKeyFrame(this.stateTime));
        }
        this.scalefactor = (float)Math.pow(10.0, zoomfactor - this.base) * CONSTANTS.screenScale;
        this.object.setScale(this.scalefactor);
        if (CONSTANTS.developerMode) {
            XmlReader reader = new XmlReader();
            try {
                Array<XmlReader.Element> objects = reader.parse(CONSTANTS.android ? Gdx.files.external("zooom/scene.xml") : Gdx.files.internal("scene.xml")).getChild(0).getChildrenByName("object");
                for (XmlReader.Element object : objects) {
                    if (!object.getAttribute("name").equals(this.name)) continue;
                    this.pos.x = object.getInt("x");
                    this.pos.y = object.getInt("y");
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.object.setOriginBasedPosition(this.pos.x * this.scalefactor + (float)Gdx.graphics.getWidth() / 2.0f + this.pos2.x * this.scalefactor + CONSTANTS.center.x, this.pos.y * this.scalefactor + (float)Gdx.graphics.getHeight() / 2.0f - this.pos2.y * this.scalefactor + CONSTANTS.center.y);
    }

    public void draw(PolygonSpriteBatch batch) {
        if (this.visible) {
            this.object.draw(batch);
        }
    }

    public void touch(boolean touch) {
        if (!this.visible) {
            return;
        }
        this.touch = touch;
        if (!CONSTANTS.dev_touch.equals("") && !CONSTANTS.dev_touch.equals(this.name)) {
            return;
        }
        CONSTANTS.dev_touch = this.name;
        if (touch) {
            this.touchpos1.set(this.touchpos2);
            this.touchpos2.set(Gdx.input.getX(), Gdx.input.getY());
        } else {
            CONSTANTS.dev_touch = "";
            this.touchpos2.set(0.0f, 0.0f);
            this.touchpos1.set(this.touchpos2);
        }
        if (this.touchpos1.x != 0.0f || this.touchpos1.y != 0.0f) {
            this.pos2.x += (this.touchpos2.x - this.touchpos1.x) / this.scalefactor;
            this.pos2.y += (this.touchpos2.y - this.touchpos1.y) / this.scalefactor;
        }
    }

    public void dispose() {
        try {
            this.atlas.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

