/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import com.example.zooom.CONSTANTS;
import com.example.zooom.Font;
import com.example.zooom.Object;
import com.example.zooom.Regler;
import com.example.zooom.Ruler;
import com.example.zooom.Text;
import com.example.zooom.UIObject;
import java.util.ArrayList;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class Main
extends ApplicationAdapter {
    private boolean developerMode = false;
    private String extRoot;
    private ArrayList<Object> objects;
    private ShapeDrawer drawer;
    private PolygonSpriteBatch batch;
    private float zoomfactor = 3.2f;
    private float zoomMin;
    private float zoomMax;
    private int logicalResX = 960;
    private int logicalResY = 640;
    private Vector3 bkcolor;
    private Font font;
    private ArrayList<Ruler> rulers;
    private ArrayList<Text> texts;
    private Regler regler;
    private boolean mouseDown = false;
    private float fingerZoomDistance1;
    private float fingerZoomDistance2;
    private float fingerZoomSpeed = 5.0E-6f;
    private Vector2 lastMousePos;
    private Ellipse verschiebeCircle;
    private Texture texture;
    private Texture dev;
    private Sprite dev2;
    private ArrayList<UIObject> uiObjects;
    private Texture langFocusTexture;
    private Sprite langFocusSprite;
    private Vector2 posDE;
    private Vector2 posEN;
    private More more;
    private boolean languageChanged;
    private int loaded = 0;
    private Texture mmProd;
    private Sprite mmProdSprite;
    private XmlReader reader;

    @Override
    public void create() {
        Gdx.input.setCatchKey(4, true);
        this.batch = new PolygonSpriteBatch();
        this.font = new Font("Scada");
        Pixmap pixmap = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        pixmap.setColor(Color.WHITE);
        pixmap.drawPixel(0, 0);
        this.texture = new Texture(pixmap);
        pixmap.dispose();
        TextureRegion region = new TextureRegion(this.texture, 0, 0, 1, 1);
        this.drawer = new ShapeDrawer(this.batch, region);
        this.drawer.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.objects = new ArrayList();
        this.rulers = new ArrayList();
        this.texts = new ArrayList();
        this.mmProd = new Texture(Gdx.files.internal("MMProd.png"));
        this.fingerZoomSpeed /= Gdx.graphics.getDensity();
        this.lastMousePos = new Vector2(0.0f, 0.0f);
        CONSTANTS.lang = "de";
        CONSTANTS.developerMode = this.developerMode;
        CONSTANTS.center = new Vector2(0.0f, 0.0f);
        Gdx.input.setInputProcessor(new InputAdapter(){

            @Override
            public boolean touchDown(int x, int y, int pointer, int button) {
                return true;
            }
        });
        this.extRoot = Gdx.files.getExternalStoragePath();
        if (Gdx.files.external("/zooom/scene.xml").exists()) {
            if (!CONSTANTS.html) {
                CONSTANTS.android = true;
            }
        } else if (CONSTANTS.android) {
            Gdx.files.internal("scene.xml").copyTo(Gdx.files.external("/zooom/scene.xml"));
            Gdx.files.internal("objects/").copyTo(Gdx.files.external("/zooom/"));
            Gdx.files.internal("animations/").copyTo(Gdx.files.external("/zooom/"));
        } else if (CONSTANTS.html) {
            // empty if block
        }
    }

    @Override
    public void resize(int width, int height) {
        float scaleY;
        float scaleX = (float)Gdx.graphics.getWidth() / (float)this.logicalResX;
        if (scaleX <= (scaleY = (float)Gdx.graphics.getHeight() / (float)this.logicalResY)) {
            CONSTANTS.screenScale = scaleX;
            CONSTANTS.screenBorderX = 0;
            CONSTANTS.screenBorderY = (Gdx.graphics.getHeight() - (int)((float)this.logicalResY * scaleX)) / 2;
        } else {
            CONSTANTS.screenScale = scaleY;
            CONSTANTS.screenBorderX = (Gdx.graphics.getWidth() - (int)((float)this.logicalResX * scaleY)) / 2;
            CONSTANTS.screenBorderY = 0;
        }
        CONSTANTS.screenWidth = width;
        CONSTANTS.screenHeight = height;
        CONSTANTS.logicalWidth = this.logicalResX;
        CONSTANTS.logicalHeight = this.logicalResY;
        this.verschiebeCircle = new Ellipse(CONSTANTS.screenWidth / 2, CONSTANTS.screenHeight / 2, CONSTANTS.screenWidth, CONSTANTS.screenHeight);
    }

    @Override
    public void render() {
        if (this.loaded < 2) {
            Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            Gdx.gl.glClear(16640);
            this.batch.begin();
            this.mmProdSprite = new Sprite(this.mmProd);
            this.mmProdSprite.setScale(0.5f);
            this.mmProdSprite.setOriginBasedPosition(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
            this.mmProdSprite.draw(this.batch);
            if (this.loaded == 1 && !this.loadScene(0)) {
                Gdx.app.log("ERROR", "Could not load the Scene");
            }
            if (this.developerMode) {
                this.dev = new Texture(Gdx.files.internal("logRes.png"));
                this.dev2 = new Sprite(this.dev);
            }
            ++this.loaded;
            this.batch.end();
        } else {
            this.languageChanged = false;
            for (Object object : this.objects) {
                object.update(this.zoomfactor);
            }
            for (Ruler ruler : this.rulers) {
                ruler.update(this.zoomfactor);
            }
            for (Text text : this.texts) {
                text.update(this.zoomfactor);
            }
            this.zoomfactor = this.regler.update(this.zoomfactor);
            if (Gdx.input.isKeyPressed(22)) {
                this.zoomfactor = (float)((double)this.zoomfactor - 0.05);
            }
            if (Gdx.input.isKeyPressed(21)) {
                this.zoomfactor = (float)((double)this.zoomfactor + 0.05);
            }
            if (!Gdx.input.isTouched() && this.regler.touched) {
                this.regler.touched(false);
                this.lastMousePos.set(0.0f, 0.0f);
                this.mouseDown = false;
                this.fingerZoomDistance1 = 0.0f;
                this.fingerZoomDistance2 = 0.0f;
            } else if (!Gdx.input.isTouched() && this.mouseDown) {
                this.mouseDown = false;
                this.fingerZoomDistance1 = 0.0f;
                this.fingerZoomDistance2 = 0.0f;
                for (UIObject uiObject : this.uiObjects) {
                    if (uiObject.getBoundingRectangle().contains(this.lastMousePos.x, (float)CONSTANTS.screenHeight - this.lastMousePos.y) && uiObject.release(true)) {
                        if (uiObject.getName().equals("langDE")) {
                            CONSTANTS.lang = "de";
                        } else if (uiObject.getName().equals("langEN")) {
                            CONSTANTS.lang = "en";
                        } else if (uiObject.getName().equals("info")) {
                            this.more.object = "info";
                        } else if (uiObject.getName().equals("back")) {
                            this.more.delete();
                        }
                        uiObject.press(false);
                        this.languageChanged = true;
                        break;
                    }
                    uiObject.press(false);
                }
                if (!this.languageChanged && this.more.object.equals("")) {
                    for (Text text : this.texts) {
                        if (text.getLang().equals(CONSTANTS.lang)) {
                            if (!text.getMoreRectangle().contains(this.lastMousePos.x, (float)CONSTANTS.screenHeight - this.lastMousePos.y) || !text.release(true)) continue;
                            this.more.object = text.getName();
                            text.press(false);
                            break;
                        }
                        text.press(false);
                    }
                } else if (!(this.languageChanged || this.more.object.equals("") || this.more.getWindowRect().contains(Gdx.input.getX(), CONSTANTS.screenHeight - Gdx.input.getY()))) {
                    this.more.delete();
                }
                this.lastMousePos.set(0.0f, 0.0f);
            } else if (!Gdx.input.isTouched()) {
                this.mouseDown = false;
                this.fingerZoomDistance1 = 0.0f;
                this.fingerZoomDistance2 = 0.0f;
            } else if (Gdx.input.isTouched(1) && this.more.object.equals("")) {
                float tempX = Gdx.input.getX(0) - Gdx.input.getX(1);
                float tempY = Gdx.input.getY(0) - Gdx.input.getY(1);
                float sqrDistance = tempX * tempX + tempY * tempY;
                this.fingerZoomDistance2 = this.fingerZoomDistance1 == 0.0f ? 0.0f : sqrDistance - this.fingerZoomDistance1;
                this.fingerZoomDistance1 = sqrDistance;
                this.zoomfactor += this.fingerZoomDistance2 * this.fingerZoomSpeed;
                if (this.zoomfactor > this.zoomMax) {
                    this.zoomfactor = this.zoomMax;
                } else if (this.zoomfactor < this.zoomMin) {
                    this.zoomfactor = this.zoomMin;
                }
                this.lastMousePos.set(0.0f, 0.0f);
            } else if (Gdx.input.justTouched()) {
                this.mouseDown = true;
                this.fingerZoomDistance1 = 0.0f;
                this.fingerZoomDistance2 = 0.0f;
                for (UIObject uiObject : this.uiObjects) {
                    if (uiObject.getBoundingRectangle().contains(Gdx.input.getX(), CONSTANTS.screenHeight - Gdx.input.getY())) {
                        uiObject.press(true);
                        this.languageChanged = true;
                        continue;
                    }
                    uiObject.press(false);
                }
                if (!this.more.object.equals("")) {
                    this.more.touchHandling();
                } else if (this.regler.isTouched(Gdx.input.getX(), CONSTANTS.screenHeight - Gdx.input.getY())) {
                    this.regler.touched(true);
                } else if (!this.languageChanged && !this.regler.touched) {
                    for (Text text : this.texts) {
                        if (text.getLang().equals(CONSTANTS.lang)) {
                            if (text.getMoreRectangle().contains(Gdx.input.getX(), CONSTANTS.screenHeight - Gdx.input.getY())) {
                                text.press(true);
                                this.languageChanged = true;
                                break;
                            }
                            text.press(false);
                            continue;
                        }
                        text.press(false);
                    }
                }
                this.lastMousePos.set(Gdx.input.getX(), Gdx.input.getY());
            } else if (Gdx.input.isTouched()) {
                if (!(!this.more.object.equals("") || this.languageChanged || this.regler.touched || this.lastMousePos.x == 0.0f && this.lastMousePos.y == 0.0f || this.languageChanged)) {
                    CONSTANTS.center.x += (float)Gdx.input.getX() - this.lastMousePos.x;
                    CONSTANTS.center.y += (float)(CONSTANTS.screenHeight - Gdx.input.getY()) - ((float)CONSTANTS.screenHeight - this.lastMousePos.y);
                    if (!this.verschiebeCircle.contains((float)(CONSTANTS.screenWidth / 2) + CONSTANTS.center.x, (float)(CONSTANTS.screenHeight / 2) + CONSTANTS.center.y)) {
                        CONSTANTS.center.x -= (float)Gdx.input.getX() - this.lastMousePos.x;
                        CONSTANTS.center.y -= (float)(CONSTANTS.screenHeight - Gdx.input.getY()) - ((float)CONSTANTS.screenHeight - this.lastMousePos.y);
                    }
                }
                this.lastMousePos.set(Gdx.input.getX(), Gdx.input.getY());
            }
            if (Gdx.input.isKeyJustPressed(4) && !this.more.object.equals("")) {
                this.more.delete();
            }
            Gdx.gl.glClearColor(this.bkcolor.x, this.bkcolor.y, this.bkcolor.z, 1.0f);
            if (this.developerMode) {
                Gdx.gl.glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
            }
            Gdx.gl.glClear(16640);
            this.batch.begin();
            if (this.developerMode) {
                this.drawer.filledRectangle((float)CONSTANTS.screenBorderX, (float)CONSTANTS.screenBorderY, (float)this.logicalResX * CONSTANTS.screenScale, (float)this.logicalResY * CONSTANTS.screenScale, new Color(this.bkcolor.x, this.bkcolor.y, this.bkcolor.z, 1.0f));
            }
            if (this.developerMode) {
                this.font.draw(this.batch, "external: " + Gdx.files.getExternalStoragePath() + "zooom", 10, Gdx.graphics.getHeight() - 10);
            }
            for (Object object : this.objects) {
                object.draw(this.batch);
            }
            for (Ruler ruler : this.rulers) {
                ruler.draw(this.drawer, this.batch);
            }
            for (Text text : this.texts) {
                text.draw(this.batch);
            }
            for (UIObject uiObject : this.uiObjects) {
                if (uiObject.getName().equals("back")) continue;
                uiObject.draw(this.batch);
            }
            if (CONSTANTS.lang.equals("de")) {
                this.langFocusSprite.setOriginBasedPosition(this.posDE.x, this.posDE.y);
            } else if (CONSTANTS.lang.equals("en")) {
                this.langFocusSprite.setOriginBasedPosition(this.posEN.x, this.posEN.y);
            }
            this.langFocusSprite.draw(this.batch);
            this.regler.draw(this.drawer, this.batch);
            if (!this.more.object.isEmpty()) {
                this.more.draw();
            }
            this.batch.end();
            if (this.developerMode) {
                this.developer();
            }
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.font.dispose();
        this.texture.dispose();
        this.langFocusTexture.dispose();
        if (this.developerMode) {
            this.dev.dispose();
        }
        this.mmProd.dispose();
        this.more.dispose();
        this.regler.dispose();
        for (Object object : this.objects) {
            object.dispose();
        }
        for (UIObject uiObject : this.uiObjects) {
            uiObject.dispose();
        }
    }

    private boolean loadScene(int sceneid) {
        this.reader = new XmlReader();
        XmlReader.Element root = this.reader.parse(CONSTANTS.android ? Gdx.files.external("zooom/scene.xml") : Gdx.files.internal("scene.xml"));
        XmlReader.Element scene = root.getChild(sceneid);
        this.zoomMin = 100.0f;
        this.zoomMax = 0.0f;
        Array<XmlReader.Element> objects = scene.getChildrenByName("object");
        for (XmlReader.Element element : objects) {
            this.objects.add(new Object(element.getAttribute("name"), element.getAttribute("texture"), element.getAttribute("base"), element.getAttribute("x"), element.getAttribute("y")));
            this.zoomMax = Math.max(this.zoomMax, Float.parseFloat(element.getAttribute("base")));
            this.zoomMin = Math.min(this.zoomMin, Float.parseFloat(element.getAttribute("base")));
        }
        CONSTANTS.firstObject = this.objects.get((int)0).name;
        Array<XmlReader.Element> rulers = scene.getChildrenByName("ruler");
        for (XmlReader.Element element : rulers) {
            this.rulers.add(new Ruler(element.getAttribute("name"), element.getAttribute("base"), element.getAttribute("x"), element.getAttribute("y"), element.getAttribute("schrift"), this.font));
        }
        Array<XmlReader.Element> array = scene.getChildrenByName("text");
        for (XmlReader.Element text : array) {
            this.texts.add(new Text(text.getAttribute("lang"), text.getAttribute("name"), text.getAttribute("base"), text.getAttribute("x"), text.getAttribute("y"), text.getAttribute("text"), this.font, "text"));
            this.zoomMax = Math.max(this.zoomMax, Float.parseFloat(text.getAttribute("base")));
            this.zoomMin = Math.min(this.zoomMin, Float.parseFloat(text.getAttribute("base")));
        }
        this.uiObjects = new ArrayList();
        this.more = new More(scene);
        this.regler = new Regler(this.zoomMin, this.zoomMax);
        float f = 0.5f;
        float borderTop = 0.98f;
        float borderRight = 0.99f;
        float space = 0.02f;
        this.uiObjects.add(new UIObject("info", f, new Vector2((float)CONSTANTS.screenWidth * borderRight, (float)CONSTANTS.screenHeight * borderTop)));
        this.uiObjects.add(new UIObject("langDE", f, new Vector2((float)CONSTANTS.screenWidth * borderRight * (1.0f - space) - this.uiObjects.get(1).getWidth() * CONSTANTS.screenScale * f, (float)CONSTANTS.screenHeight * borderTop)));
        this.uiObjects.add(new UIObject("langEN", f, new Vector2((float)CONSTANTS.screenWidth * borderRight * (1.0f - 2.0f * space) - this.uiObjects.get(1).getWidth() * CONSTANTS.screenScale * f - this.uiObjects.get(2).getWidth() * CONSTANTS.screenScale * f, (float)CONSTANTS.screenHeight * borderTop)));
        this.langFocusTexture = new Texture(Gdx.files.internal("langFocus.png"), true);
        this.langFocusTexture.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
        this.langFocusSprite = new Sprite(this.langFocusTexture);
        this.langFocusSprite.setScale(CONSTANTS.screenScale * f);
        this.posDE = new Vector2((float)CONSTANTS.screenWidth * borderRight * (1.0f - space) - this.uiObjects.get(1).getWidth() * CONSTANTS.screenScale * f - this.langFocusSprite.getWidth() * CONSTANTS.screenScale * f * 0.5f, (float)CONSTANTS.screenHeight * borderTop - this.langFocusSprite.getHeight() * CONSTANTS.screenScale * f * 0.5f);
        this.posEN = new Vector2((float)CONSTANTS.screenWidth * borderRight * (1.0f - 2.0f * space) - this.uiObjects.get(1).getWidth() * CONSTANTS.screenScale * f - this.uiObjects.get(2).getWidth() * CONSTANTS.screenScale * f - this.langFocusSprite.getWidth() * CONSTANTS.screenScale * f * 0.5f, (float)CONSTANTS.screenHeight * borderTop - this.langFocusSprite.getHeight() * CONSTANTS.screenScale * f * 0.5f);
        this.bkcolor = new Vector3(scene.getFloat("bkcolorRED", 1.0f), scene.getFloat("bkcolorGREEN", 1.0f), scene.getFloat("bkcolorBLUE", 1.0f));
        CONSTANTS.developerMode = this.developerMode = scene.getBoolean("developermode", false);
        String startbase = scene.getAttribute("startbase", "min");
        this.zoomfactor = startbase.equals("min") ? this.zoomMin - 0.2f : (startbase.equals("max") ? this.zoomMax - 0.2f : Float.parseFloat(startbase));
        return true;
    }

    private void developer() {
        this.batch.begin();
        this.drawer.rectangle((float)CONSTANTS.screenBorderX, (float)CONSTANTS.screenBorderY, (float)this.logicalResX * CONSTANTS.screenScale, (float)this.logicalResY * CONSTANTS.screenScale, new Color(1.0f, 0.0f, 0.0f, 1.0f), 10.0f);
        if (Gdx.input.isTouched()) {
            this.font.draw(this.batch, "x:" + (Gdx.input.getX() - Gdx.graphics.getWidth() / 2) + " y:" + ((Gdx.input.getY() - this.logicalResY) * -1 - Gdx.graphics.getHeight() / 2) + " base:" + (float)Math.round(this.zoomfactor * 100.0f) / 100.0f, Gdx.input.getX(), (Gdx.input.getY() - this.logicalResY + 20) * -1);
        }
        this.batch.end();
    }

    private class More {
        public String object = "";
        private ArrayList<Text> moreTexts = new ArrayList();
        private Rectangle windowRect;
        private Rectangle windowRect2;
        Array<XmlReader.Element> texts;
        private float transparenz = 0.95f;
        private float borderLeft = 0.8f;
        private float borderRight = 0.8f;
        private float borderTop = 0.8f;
        private float borderBottom = 0.8f;
        private float borderTextLeft = 0.9f;
        private float borderTextTop = 0.9f;
        private int backButtonBorderX = 15;
        private int backButtonBorderY = 10;
        private boolean animation = true;
        private float animationDuration = 0.5f;
        private float accumulator = 0.0f;
        private float animPoint;

        public More(XmlReader.Element scene) {
            float x = -((float)CONSTANTS.logicalWidth * 0.5f * this.borderLeft * this.borderTextLeft);
            float y = (float)CONSTANTS.logicalHeight * 0.5f * this.borderTop * this.borderTextTop;
            Array<XmlReader.Element> infos = new Array<XmlReader.Element>(scene.getChildrenByName("info"));
            for (XmlReader.Element info : infos) {
                this.moreTexts.add(new Text(info.getAttribute("lang"), info.getAttribute("name"), 0.0f, x, y, info.getAttribute("text"), Main.this.font, "info"));
            }
            this.texts = new Array<XmlReader.Element>(scene.getChildrenByName("more"));
            for (XmlReader.Element text : this.texts) {
                this.moreTexts.add(new Text(text.getAttribute("lang"), text.getAttribute("name"), 0.0f, x, y, text.getAttribute("text"), Main.this.font, "more"));
            }
            this.windowRect = new Rectangle((float)CONSTANTS.screenWidth * 0.5f - (float)CONSTANTS.logicalWidth * 0.5f * CONSTANTS.screenScale * this.borderLeft, (float)CONSTANTS.screenHeight * 0.5f - (float)CONSTANTS.logicalHeight * 0.5f * CONSTANTS.screenScale * this.borderBottom, CONSTANTS.screenScale * (float)CONSTANTS.logicalWidth * 0.5f * (this.borderLeft + this.borderRight), CONSTANTS.screenScale * (float)CONSTANTS.logicalHeight * 0.5f * (this.borderTop + this.borderBottom));
            this.windowRect2 = new Rectangle(this.windowRect);
            float backButtonScale = 0.5f;
            Main.this.uiObjects.add(new UIObject("back", backButtonScale, new Vector2((float)CONSTANTS.screenWidth * 0.5f + CONSTANTS.screenScale * ((float)CONSTANTS.logicalWidth * 0.5f * this.borderRight - (float)this.backButtonBorderX), (float)CONSTANTS.screenHeight * 0.5f + CONSTANTS.screenScale * ((float)CONSTANTS.logicalHeight * 0.5f * this.borderTop - (float)this.backButtonBorderY))));
        }

        public void draw() {
            if (this.animation) {
                this.accumulator += Gdx.graphics.getDeltaTime();
                if (this.accumulator >= this.animationDuration) {
                    this.animation = false;
                }
                this.animPoint = this.accumulator / this.animationDuration;
                if (this.animPoint > 1.0f) {
                    this.animPoint = 1.0f;
                }
                if (this.object.equals("info")) {
                    this.windowRect2.set(this.windowRect.x + this.windowRect.width * (1.0f - this.animPoint), this.windowRect.y + this.windowRect.height * (1.0f - this.animPoint), this.windowRect.width * this.animPoint, this.windowRect.height * this.animPoint);
                } else {
                    this.windowRect2.set(this.windowRect.x + 0.5f * this.windowRect.width * (1.0f - this.animPoint), this.windowRect.y + 0.5f * this.windowRect.height * (1.0f - this.animPoint), this.windowRect.width * this.animPoint, this.windowRect.height * this.animPoint);
                }
            } else {
                this.windowRect2.set(this.windowRect);
                this.accumulator = 0.0f;
                this.animPoint = 1.0f;
            }
            Main.this.drawer.filledRectangle(this.windowRect2, new Color(0.9f, 0.9f, 0.9f, this.transparenz));
            Main.this.drawer.rectangle(this.windowRect2, new Color(0.0f, 0.0f, 0.0f, this.transparenz));
            if (this.animPoint == 1.0f) {
                ((UIObject)Main.this.uiObjects.get(0)).draw(Main.this.batch);
            }
            for (Text moreText : this.moreTexts) {
                if (!moreText.getName().equals(this.object) || !moreText.getLang().equals(CONSTANTS.lang)) continue;
                if (Main.this.developerMode) {
                    try {
                        XmlReader.Element scene = Main.this.reader.parse(CONSTANTS.android ? Gdx.files.external("zooom/scene.xml") : Gdx.files.internal("scene.xml")).getChild(0);
                        this.texts = new Array<XmlReader.Element>(scene.getChildrenByName("more"));
                        for (XmlReader.Element text : this.texts) {
                            if (!text.getAttribute("name").equals(this.object) || !text.getAttribute("lang").equals(CONSTANTS.lang)) continue;
                            moreText = new Text(text.getAttribute("lang"), text.getAttribute("name"), 0.0f, -((float)CONSTANTS.logicalWidth * 0.5f * this.borderLeft * this.borderTextLeft), (float)CONSTANTS.logicalHeight * 0.5f * this.borderTop * this.borderTextTop, text.getAttribute("text"), Main.this.font, "more");
                            break;
                        }
                    }
                    catch (Exception e) {
                        Gdx.app.log("ERROR", "exception while parsing xml...");
                    }
                }
                if (this.animPoint != 1.0f) continue;
                moreText.update(0.0f);
                moreText.draw(Main.this.batch);
                break;
            }
        }

        public void touchHandling() {
        }

        public void dispose() {
        }

        public void delete() {
            this.object = "";
            this.animation = true;
        }

        public Rectangle getWindowRect() {
            return this.windowRect;
        }
    }
}

