/*
 * Decompiled with CFR 0.152.
 */
package com.example.zooom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class Font {
    private Texture[] texture;
    private BitmapFont[] font;
    private ShaderProgram fontShader;
    private int id;
    private GlyphLayout layout = new GlyphLayout();
    private float globalScale = 0.8f;
    private float zeilenabstand = 1.0f;
    public float lineHeight;
    public float capHeight;
    public float ascent;
    public float descent;

    public Font(String name) {
        this.texture = new Texture[4];
        this.font = new BitmapFont[4];
        this.texture[0] = new Texture(Gdx.files.internal("fonts/" + name + "_Regular.png"), true);
        this.texture[0].setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        this.font[0] = new BitmapFont(Gdx.files.internal("fonts/" + name + "_Regular.fnt"), new TextureRegion(this.texture[0]), false);
        this.font[0].setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.texture[1] = new Texture(Gdx.files.internal("fonts/" + name + "_Italic.png"), true);
        this.texture[1].setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        this.font[1] = new BitmapFont(Gdx.files.internal("fonts/" + name + "_Italic.fnt"), new TextureRegion(this.texture[1]), false);
        this.font[1].setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.texture[2] = new Texture(Gdx.files.internal("fonts/" + name + "_Bold.png"), true);
        this.texture[2].setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        this.font[2] = new BitmapFont(Gdx.files.internal("fonts/" + name + "_Bold.fnt"), new TextureRegion(this.texture[2]), false);
        this.font[2].setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.texture[3] = new Texture(Gdx.files.internal("fonts/" + name + "_BoldItalic.png"), true);
        this.texture[3].setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        this.font[3] = new BitmapFont(Gdx.files.internal("fonts/" + name + "_BoldItalic.fnt"), new TextureRegion(this.texture[3]), false);
        this.font[3].setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.fontShader = new ShaderProgram(Gdx.files.internal("fonts/font.vert"), Gdx.files.internal("fonts/font.frag"));
        if (!this.fontShader.isCompiled()) {
            Gdx.app.error("fontShader", "compilation failed:\n" + this.fontShader.getLog());
        }
        for (int i = 0; i < 4; ++i) {
            this.font[i].getData().setLineHeight(this.font[i].getData().lineHeight * this.zeilenabstand);
            this.font[i].getData().setScale(this.globalScale);
        }
        this.lineHeight = this.font[0].getLineHeight();
        this.capHeight = this.font[0].getCapHeight();
        this.ascent = this.font[0].getAscent();
        this.descent = this.font[0].getDescent();
    }

    public void draw(PolygonSpriteBatch batch, String text, int x, int y, float scale, Color color, boolean italic, boolean bold) {
        this.id = 0;
        if (italic) {
            this.id = 1;
        }
        if (bold) {
            this.id = 2;
        }
        if (italic && bold) {
            this.id = 3;
        }
        this.font[this.id].setColor(color);
        this.font[this.id].getData().setScale(scale * this.globalScale);
        this.layout.setText(this.font[this.id], text);
        batch.setShader(this.fontShader);
        this.fontShader.setUniformf("smoothing", 0.25f / (scale * 4.0f));
        this.font[this.id].draw((Batch)batch, this.layout, (float)x, (float)y);
        batch.setShader(null);
        this.font[this.id].getData().setScale(this.globalScale);
    }

    public void draw(PolygonSpriteBatch batch, String text, int x, int y) {
        this.draw(batch, text, x, y, 1.0f, Color.BLACK, false, false);
    }

    public void draw(PolygonSpriteBatch batch, String text, int x, int y, float scale) {
        this.draw(batch, text, x, y, scale, Color.BLACK, false, false);
    }

    public void draw(PolygonSpriteBatch batch, String text, int x, int y, float scale, Color color) {
        this.draw(batch, text, x, y, scale, color, false, false);
    }

    public void draw(PolygonSpriteBatch batch, String text, int x, int y, float scale, Color color, boolean italic) {
        this.draw(batch, text, x, y, scale, color, italic, false);
    }

    public void dispose() {
        for (int i = 0; i < 4; ++i) {
            this.texture[i].dispose();
            this.font[i].dispose();
        }
        this.fontShader.dispose();
    }

    public float getWidth(String text, boolean italic, boolean bold) {
        this.id = 0;
        if (italic) {
            this.id = 1;
        }
        if (bold) {
            this.id = 2;
        }
        if (italic && bold) {
            this.id = 3;
        }
        this.layout.setText(this.font[this.id], text);
        return this.layout.width;
    }

    public float getWidth(String text, boolean italic) {
        return this.getWidth(text, italic, false);
    }

    public float getWidth(String text) {
        return this.getWidth(text, false, false);
    }

    public float getHeight(String text, boolean italic, boolean bold) {
        this.id = 0;
        if (italic) {
            this.id = 1;
        }
        if (bold) {
            this.id = 2;
        }
        if (italic && bold) {
            this.id = 3;
        }
        this.layout.setText(this.font[this.id], text);
        return this.layout.height;
    }

    public float getHeight(String text, boolean italic) {
        return this.getHeight(text, italic, false);
    }

    public float getHeight(String text) {
        return this.getHeight(text, false, false);
    }
}

