/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d.objects;

import java.awt.Color;
import uibk.applets.complex2d.MathPanelSource;
import uibk.applets.complex2d.objects.MappableCircleSector;
import uibk.applets.complex2d.objects.MappableLine;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Interval;
import uibk.mtk.util.IntervalIterator;

public final class ObjectCreator {
    MathPanelSource mathpanel;
    boolean advanced_highlighting;
    boolean check_singularities;
    static final double EPS = 0.2;
    boolean adjustcoords = true;
    static final Color COLOR1 = Color.red;
    static final Color COLOR2 = Color.blue;

    public void enableAdvancedHighLighting(boolean enable) {
        this.advanced_highlighting = enable;
    }

    public void enableCheckSingularities(boolean enable) {
        this.check_singularities = enable;
    }

    public ObjectCreator(MathPanelSource mathpanel) {
        this.mathpanel = mathpanel;
    }

    public void createHouse(CoordinateRect2D rect) {
        double width = rect.getXRange() * 0.8;
        double height = rect.getYRange() * 0.5;
        double heightroof = rect.getYRange() * 0.3;
        double centerx = rect.xmin + rect.getXRange() / 2.0;
        double centery = rect.ymin + (height + heightroof) / 2.0;
        Punkt2D lowerleft = new Punkt2D(centerx - width / 2.0, centery - height / 2.0);
        Punkt2D upperleft = new Punkt2D(centerx - width / 2.0, centery + height / 2.0);
        Punkt2D lowerright = new Punkt2D(centerx + width / 2.0, centery - height / 2.0);
        Punkt2D upperright = new Punkt2D(centerx + width / 2.0, centery + height / 2.0);
        Punkt2D saddle = new Punkt2D(centerx, centery + height / 2.0 + heightroof);
        Punkt2D door_lowerleft = new Punkt2D(centerx + width / 10.0, centery - height / 2.0);
        Punkt2D door_upperleft = new Punkt2D(centerx + width / 10.0, centery - height / 6.0);
        Punkt2D door_lowerright = new Punkt2D(centerx + 4.0 * width / 10.0, centery - height / 2.0);
        Punkt2D door_upperright = new Punkt2D(centerx + 4.0 * width / 10.0, centery - height / 6.0);
        Punkt2D[][] lines = new Punkt2D[][]{{lowerleft, lowerright}, {lowerleft, upperleft}, {lowerright, upperright}, {upperleft, upperright}, {upperleft, saddle}, {upperright, saddle}, {door_lowerleft, door_upperleft}, {door_upperleft, door_upperright}, {door_lowerright, door_upperright}};
        int i = 0;
        while (i < lines.length) {
            MappableLine line = new MappableLine(lines[i][0], lines[i][1]);
            line.enableAdvancedHighlight(this.advanced_highlighting);
            line.enableCheckSingularities(this.check_singularities);
            line.setColor(COLOR1);
            this.mathpanel.add(line);
            ++i;
        }
        if (this.adjustcoords) {
            this.mathpanel.getScene2d().setLimits(rect);
        }
    }

    public void createGrid(CoordinateRect2D rect, int gridx, int gridy) {
        MappableLine line;
        double xmin = rect.xmin;
        double xmax = rect.xmax;
        double ymin = rect.ymin;
        double ymax = rect.ymax;
        IntervalIterator itx = new IntervalIterator(xmin, xmax, gridx);
        IntervalIterator ity = new IntervalIterator(ymin, ymax, gridy);
        while (itx.hasNext()) {
            double x = (Double)itx.next();
            line = new MappableLine(new Punkt2D(x, ymin), new Punkt2D(x, ymax));
            line.setColor(COLOR2);
            line.enableAdvancedHighlight(this.advanced_highlighting);
            line.enableCheckSingularities(this.check_singularities);
            this.mathpanel.add(line);
        }
        while (ity.hasNext()) {
            double y = (Double)ity.next();
            line = new MappableLine(new Punkt2D(xmin, y), new Punkt2D(xmax, y));
            line.setColor(COLOR1);
            line.enableAdvancedHighlight(this.advanced_highlighting);
            line.enableCheckSingularities(this.check_singularities);
            this.mathpanel.add(line);
        }
    }

    public void createPolarCoords(Punkt2D center, double argstart, double extend, Interval rint, int n) {
        if (rint.a < 0.0 || argstart > Math.PI * 2 || argstart < 0.0 || extend > Math.PI * 2 || !rint.isRealInterval()) {
            throw new IllegalArgumentException();
        }
        double rmax = rint.b;
        double rmin = rint.a;
        double min = rmin == 0.0 ? rmax / (double)n : rmin;
        IntervalIterator it = new IntervalIterator(min, rmax, n);
        while (it.hasNext()) {
            double r = it.nextdouble();
            MappableCircleSector sec = new MappableCircleSector(center.x, center.y, r, argstart, extend);
            sec.setColor(Color.red);
            sec.enableCheckSingularities(this.check_singularities);
            sec.enableAdvancedHighlight(this.advanced_highlighting);
            this.mathpanel.add(sec);
        }
        if (rmax != rmin) {
            double max = extend == Math.PI * 2 ? argstart + extend - extend / (double)n : argstart + extend;
            it = new IntervalIterator(argstart, max, n);
            while (it.hasNext()) {
                double phi = it.nextdouble();
                double x1 = center.x + rmin * Math.cos(phi);
                double y1 = center.y + rmin * Math.sin(phi);
                double x2 = center.x + rmax * Math.cos(phi);
                double y2 = center.y + rmax * Math.sin(phi);
                MappableLine line = new MappableLine(new Punkt2D(x1, y1), new Punkt2D(x2, y2));
                line.setColor(Color.blue);
                line.enableCheckSingularities(this.check_singularities);
                line.enableAdvancedHighlight(this.advanced_highlighting);
                this.mathpanel.add(line);
            }
        }
        if (this.adjustcoords) {
            this.mathpanel.getScene2d().setLimits(center.x - rmax, center.x + rmax, center.y - rmax, center.y + rmax);
        }
    }

    public void createPolarCoordsCut(Punkt2D center, Interval radius, double radiuscut, double argcut, int n) {
        if (!radius.isRealInterval() || !radius.contains(radiuscut) || argcut < 0.0 || argcut > Math.PI * 2) {
            throw new IllegalArgumentException("");
        }
        double rmin = radius.a;
        double rmax = radius.b;
        double offset = 6.083185307179586;
        double min = rmin;
        if (rmin == 0.0) {
            min = radius.getLength() / (double)n;
        }
        IntervalIterator it = new IntervalIterator(min, rmax, n);
        while (it.hasNext()) {
            MappableCircleSector sec;
            double r = it.nextdouble();
            if (r < radiuscut) {
                sec = new MappableCircleSector(center.x, center.y, r, 0.0, Math.PI * 2);
                sec.setColor(Color.red);
                sec.enableAdvancedHighlight(this.advanced_highlighting);
                sec.enableCheckSingularities(this.check_singularities);
                this.mathpanel.add(sec);
                continue;
            }
            sec = new MappableCircleSector(center.x, center.y, r, argcut + 0.1, offset);
            sec.setColor(Color.red);
            sec.enableAdvancedHighlight(this.advanced_highlighting);
            sec.enableCheckSingularities(this.check_singularities);
            this.mathpanel.add(sec);
        }
        double cutmin = argcut + 0.1;
        double cutmax = cutmin + Math.PI * 2 - 0.2;
        it = new IntervalIterator(cutmin, cutmax, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            double x1 = center.x + rmin * Math.cos(t);
            double y1 = center.y + rmin * Math.sin(t);
            double x2 = center.x + rmax * Math.cos(t);
            double y2 = center.y + rmax * Math.sin(t);
            MappableLine line = new MappableLine(new Punkt2D(x1, y1), new Punkt2D(x2, y2));
            line.setColor(Color.blue);
            line.enableCheckSingularities(this.check_singularities);
            line.enableAdvancedHighlight(this.advanced_highlighting);
            this.mathpanel.add(line);
        }
        if (this.adjustcoords) {
            this.mathpanel.getScene2d().setLimits(center.x - rmax, center.x + rmax, center.y - rmax, center.y + rmax);
        }
    }
}

