/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import uibk.applets.complex2d.objects.MappableObject;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.util.ColorIterator;

public class MappedObject
extends Graph2D
implements Highlightable {
    protected MappableObject src;

    public MappedObject(MappableObject src) {
        this.src = src;
    }

    @Override
    public void highlight(BufferedImage framebuffer, Graphics2D g2) {
        BasicStroke stroke = new BasicStroke(4.0f);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(stroke);
        g2.setColor(this.src.getHighLightColor());
        ColorIterator colit = this.src.getColorIterator();
        int i = 0;
        while (i < this.points.size() - 1) {
            Punkt2D start = (Punkt2D)this.points.elementAt(i);
            Punkt2D end = (Punkt2D)this.points.elementAt(i + 1);
            if (start != null && end != null) {
                int startx = this.scene2d.xToPixel(start.x);
                int starty = this.scene2d.yToPixel(start.y);
                int endx = this.scene2d.xToPixel(end.x);
                int endy = this.scene2d.yToPixel(end.y);
                if (this.src.advanced_highlighting) {
                    g2.setColor((Color)colit.next());
                }
                g2.drawLine(startx, starty, endx, endy);
            }
            ++i;
        }
        g2.setStroke(oldStroke);
        this.draw(framebuffer, g2);
    }

    @Override
    public boolean highlightcontains(int x, int y) {
        return false;
    }

    @Override
    public void setHighLightColor(Color color) {
    }

    @Override
    public Color getHighLightColor() {
        return this.src.getHighLightColor();
    }
}

