/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import uibk.applets.complex2d.objects.MappedObject;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.math.Complex;
import uibk.mtk.math.functions.ComplexFunction;
import uibk.mtk.util.ColorIterator;
import uibk.mtk.util.IntervalIterator;
import uibk.mtk.util.ObjectIterator;

public abstract class MappableObject
extends Drawable2D
implements Highlightable {
    Color highlightcolor = new Color(100, 250, 150, 200);
    static final Color ADVCOLOR1 = new Color(255, 255, 0, 200);
    static final Color ADVCOLOR2 = new Color(100, 250, 150, 200);
    int highlightradius = 4;
    boolean advanced_highlighting = false;
    boolean check_singularities = true;
    static final double WARNING_THRESH = 0.5;
    static final double SING_THRESH = 0.25;
    private double warning_threshold;
    private double sing_threshold;
    MappedObject image;
    int discretsize = 100;

    public int getDiscretSize() {
        return this.discretsize;
    }

    public void enableAdvancedHighlight(boolean enable) {
        this.advanced_highlighting = enable;
    }

    public void enableCheckSingularities(boolean enable) {
        this.check_singularities = enable;
    }

    private void simplehighlight(BufferedImage framebuffer, Graphics2D g2) {
        Stroke oldstroke = g2.getStroke();
        BasicStroke stroke = new BasicStroke(this.highlightradius);
        g2.setStroke(stroke);
        g2.setColor(this.highlightcolor);
        this.basicdraw(framebuffer, g2);
        g2.setStroke(oldstroke);
        this.draw(framebuffer, g2);
    }

    ColorIterator getColorIterator() {
        return new ColorIterator(ADVCOLOR1, ADVCOLOR2, this.getDiscretSize());
    }

    private void advancedhighlight(BufferedImage framebuffer, Graphics2D g2) {
        ObjectIterator it = this.getIterator();
        int n = it.numberOfElements();
        ColorIterator colIt = new ColorIterator(ADVCOLOR1, ADVCOLOR2, n);
        Stroke oldstroke = g2.getStroke();
        BasicStroke stroke = new BasicStroke(this.highlightradius);
        g2.setStroke(stroke);
        Punkt2D last = null;
        while (it.hasNext()) {
            Color c = (Color)colIt.next();
            g2.setColor(c);
            Punkt2D p = (Punkt2D)it.next();
            if (last != null) {
                int p1x = this.scene2d.xToPixel(last.x);
                int p1y = this.scene2d.yToPixel(last.y);
                int p2x = this.scene2d.xToPixel(p.x);
                int p2y = this.scene2d.yToPixel(p.y);
                g2.drawLine(p1x, p1y, p2x, p2y);
            }
            last = p;
        }
        g2.setStroke(oldstroke);
        this.draw(framebuffer, g2);
    }

    public ObjectIterator getIterator() {
        return this.getIterator(this.discretsize);
    }

    @Override
    public void setHighLightColor(Color color) {
        this.highlightcolor = color;
    }

    @Override
    public Color getHighLightColor() {
        return this.highlightcolor;
    }

    abstract ObjectIterator getIterator(int var1);

    protected abstract void basicdraw(BufferedImage var1, Graphics2D var2);

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        this.basicdraw(framebuffer, g2);
    }

    @Override
    public void highlight(BufferedImage framebuffer, Graphics2D g2) {
        if (this.advanced_highlighting) {
            this.advancedhighlight(framebuffer, g2);
        } else {
            this.simplehighlight(framebuffer, g2);
        }
    }

    public MappedObject getMappedObject() {
        return this.image;
    }

    public void map(ComplexFunction f, int n) throws Exception {
        this.discretsize = n;
        this.image = new MappedObject(this);
        this.image.setColor(this.color);
        this.image.setStroke(new BasicStroke(1.0f));
        if (this.check_singularities) {
            this.advancedmap(this.image, f);
        } else {
            this.simplemap(this.image, f);
        }
    }

    private void getThreshold() {
        ObjectIterator it = this.getIterator();
        double realmin = Double.POSITIVE_INFINITY;
        double realmax = Double.NEGATIVE_INFINITY;
        double imagmin = Double.POSITIVE_INFINITY;
        double imagmax = Double.NEGATIVE_INFINITY;
        while (it.hasNext()) {
            Punkt2D p = (Punkt2D)it.next();
            if (p.x < realmin) {
                realmin = p.x;
            }
            if (p.x > realmax) {
                realmax = p.x;
            }
            if (p.y < imagmin) {
                imagmin = p.y;
            }
            if (!(p.y > imagmax)) continue;
            imagmax = p.y;
        }
        this.warning_threshold = Math.max(realmax - realmin, imagmax - imagmin) * 0.5;
        this.sing_threshold = Math.max(realmax - realmin, imagmax - imagmin) * 0.25;
    }

    private void advancedmap(MappedObject image, ComplexFunction f) throws Exception {
        this.getThreshold();
        ObjectIterator it = this.getIterator();
        double oldt = 0.0;
        Complex last = new Complex();
        while (it.hasNext()) {
            Punkt2D p = (Punkt2D)it.next();
            Complex zf = f.getValue(p.x, p.y);
            if (zf.isInfinite() || zf.isNaN()) {
                image.addPoint(null);
            } else {
                if (it.getPos() > 1 && this.getDistance(zf, last) > this.warning_threshold && this.checkSing(oldt, it.getT(), f)) {
                    image.addPoint(null);
                }
                image.addPoint(new Punkt2D(zf.getReal(), zf.getImag()));
            }
            last.set(zf);
        }
    }

    private void simplemap(MappedObject image, ComplexFunction f) throws Exception {
        ObjectIterator it = this.getIterator();
        while (it.hasNext()) {
            Punkt2D p = (Punkt2D)it.next();
            Complex zf = f.getValue(p.x, p.y);
            if (zf.isInfinite() || zf.isNaN()) {
                throw new Exception();
            }
            image.addPoint(new Punkt2D(zf.getReal(), zf.getImag()));
        }
    }

    protected abstract Complex getComplex(double var1);

    double getDistance(Complex z1, Complex z2) {
        if (z1.isInfinite() || z1.isNaN() || z2.isInfinite() || z2.isNaN()) {
            return Double.POSITIVE_INFINITY;
        }
        double rx = 1.0 / Math.max(z1.getReal(), z2.getReal());
        double ry = 1.0 / Math.max(z1.getImag(), z2.getImag());
        double dx = z2.getReal() - z1.getReal();
        double dy = z2.getImag() - z1.getImag();
        double dist = rx * dx * dx + ry * dy * dy;
        return dist;
    }

    protected boolean checkSing(double t1, double t2, ComplexFunction f) {
        int n = 20;
        IntervalIterator it = new IntervalIterator(t1, t2, n);
        Complex last = null;
        while (it.hasNext()) {
            double t = it.nextdouble();
            Complex z = f.getValue(this.getComplex(t));
            if (last != null && this.getDistance(z, last) > this.sing_threshold) {
                return true;
            }
            last = z;
        }
        return false;
    }
}

