/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d.objects;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.applets.complex2d.objects.MappableObject;
import uibk.mtk.geom.GeomUtil;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Complex;
import uibk.mtk.util.Line2DIterator;
import uibk.mtk.util.ObjectIterator;

public class MappableLine
extends MappableObject {
    protected Punkt2D p1 = new Punkt2D();
    protected Punkt2D p2 = new Punkt2D();

    public MappableLine(Punkt2D p1, Punkt2D p2) {
        this.p1.setLocation(p1);
        this.p2.setLocation(p2);
    }

    @Override
    public boolean highlightcontains(int x, int y) {
        double p2y;
        double p2x;
        double p1y;
        double p1x = this.scene2d.xToPixel(this.p1.x);
        double distquad = GeomUtil.distPointLine(x, y, p1x, p1y = (double)this.scene2d.yToPixel(this.p1.y), p2x = (double)this.scene2d.xToPixel(this.p2.x), p2y = (double)this.scene2d.yToPixel(this.p2.y));
        return distquad <= (double)(this.highlightradius * this.highlightradius);
    }

    @Override
    public ObjectIterator getIterator(int n) {
        return new Line2DIterator(this.p1, this.p2, n);
    }

    @Override
    public Complex getComplex(double t) {
        double r = this.p1.x * t + (1.0 - t) * this.p2.x;
        double s = this.p1.y * t + (1.0 - t) * this.p2.y;
        return new Complex(r, s);
    }

    @Override
    public void basicdraw(BufferedImage framebuffer, Graphics2D g2) {
        int x1 = this.scene2d.xToPixel(this.p1.x);
        int y1 = this.scene2d.yToPixel(this.p1.y);
        int x2 = this.scene2d.xToPixel(this.p2.x);
        int y2 = this.scene2d.yToPixel(this.p2.y);
        g2.drawLine(x1, y1, x2, y2);
    }
}

