/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d.objects;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import uibk.applets.complex2d.objects.MappableObject;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Complex;
import uibk.mtk.math.Interval;
import uibk.mtk.util.CircleSectorIterator;
import uibk.mtk.util.ObjectIterator;

public class MappableCircleSector
extends MappableObject {
    Punkt2D center = new Punkt2D();
    double radius = 1.0;
    double argstart = 0.0;
    double offset;

    @Override
    public Complex getComplex(double t) {
        double x = this.center.x + this.radius * Math.cos(t);
        double y = this.center.y + this.radius * Math.sin(t);
        return new Complex(x, y);
    }

    public MappableCircleSector(double x, double y, double r, double argmin, double offset) {
        if (this.argstart < 0.0 || this.argstart > Math.PI * 2 || offset < 0.0 || offset > Math.PI * 2 || r < 0.0) {
            throw new IllegalArgumentException("");
        }
        this.center.x = x;
        this.center.y = y;
        this.radius = r;
        this.argstart = argmin;
        this.offset = offset;
    }

    private double getphi(double x, double y) {
        double dirx = x - this.center.x;
        double diry = y - this.center.y;
        double phi = Math.acos(dirx / Math.sqrt(dirx * dirx + diry * diry));
        if (y < this.center.y) {
            return Math.PI * 2 - phi;
        }
        return phi;
    }

    @Override
    public boolean highlightcontains(int x, int y) {
        double d2;
        int ry;
        boolean distancepassed = false;
        boolean argumentpassed = false;
        Point c = this.scene2d.project(this.center);
        int rx = Math.abs(this.scene2d.xToPixel((double)c.x + this.radius) - this.scene2d.xToPixel(c.x));
        double a = rx >= (ry = Math.abs(this.scene2d.yToPixel((double)c.y + this.radius) - this.scene2d.yToPixel(c.y))) ? rx : ry;
        double b = rx >= ry ? ry : rx;
        double e = Math.sqrt(a * a - b * b);
        double f1x = rx >= ry ? (double)c.x + e : (double)c.x;
        double f1y = rx >= ry ? (double)c.y : (double)c.y + e;
        double f2x = rx >= ry ? (double)c.x - e : (double)c.x;
        double f2y = rx >= ry ? (double)c.y : (double)c.y - e;
        double d1 = Math.sqrt((f1x - (double)x) * (f1x - (double)x) + (f1y - (double)y) * (f1y - (double)y));
        if (Math.abs(d1 + (d2 = Math.sqrt((f2x - (double)x) * (f2x - (double)x) + (f2y - (double)y) * (f2y - (double)y))) - 2.0 * a) <= (double)this.highlightradius) {
            distancepassed = true;
        }
        if (this.offset == Math.PI * 2) {
            argumentpassed = true;
        } else {
            double wx = this.scene2d.pixelToX(x);
            double wy = this.scene2d.pixelToY(y);
            double phi = this.getphi(wx, wy) * 360.0 / (Math.PI * 2);
            if (!this.notCovered().contains(phi)) {
                argumentpassed = true;
            }
        }
        return distancepassed && argumentpassed;
    }

    private Interval notCovered() {
        double argmax = this.argstart + this.offset;
        if (argmax > Math.PI * 2) {
            argmax -= Math.PI * 2;
        }
        return new Interval(argmax * 360.0 / (Math.PI * 2), this.argstart * 360.0 / (Math.PI * 2));
    }

    @Override
    public ObjectIterator getIterator(int n) {
        return new CircleSectorIterator(this.center, this.argstart, this.offset, this.radius, n);
    }

    @Override
    public void basicdraw(BufferedImage framebuffer, Graphics2D g2) {
        Point c = this.scene2d.project(this.center);
        int rx = Math.abs(this.scene2d.xToPixel((double)c.x + this.radius) - this.scene2d.xToPixel(c.x));
        int ry = Math.abs(this.scene2d.yToPixel((double)c.y + this.radius) - this.scene2d.yToPixel(c.y));
        int amin = (int)(this.argstart * 360.0 / (Math.PI * 2));
        int aoffset = (int)(this.offset * 360.0 / (Math.PI * 2));
        g2.drawArc(c.x - rx, c.y - ry, rx * 2, ry * 2, amin, aoffset);
    }
}

