/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import uibk.applets.complex2d.AppletComplex2D;
import uibk.applets.complex2d.Messages;
import uibk.applets.complex2d.objects.MappableObject;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.functions.ComplexFunction;
import uibk.mtk.swing.base.ComplexFunctionTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelFunction
extends MPanel
implements ActionListener {
    private AppletComplex2D main;
    ComplexFunctionTextField textFunction;

    public PanelFunction(AppletComplex2D main) {
        this.main = main;
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelDef());
        this.add(Box.createVerticalGlue());
        this.add(this.createPanelButtons());
    }

    private MPanel createPanelDef() {
        TitledPanel panelfunction = new TitledPanel(Messages.getString("PanelFunction.DefineFunction"));
        panelfunction.setLayout(new GridBagLayout());
        panelfunction.setMaximumSize(new Dimension(2000, 100));
        this.textFunction = new ComplexFunctionTextField(10, 'z');
        this.textFunction.setActionCommand("compute");
        this.textFunction.addActionListener(this);
        this.textFunction.setToolTipText(String.valueOf(Messages.getString("PanelFunction.FormulaForComplexFun")) + 'z' + Messages.getString("PanelFunction.Insert"));
        panelfunction.add((Component)new JLabel("f(z)="), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelfunction.add((Component)this.textFunction, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        return panelfunction;
    }

    private MPanel createPanelButtons() {
        MPanel panelButtons = new MPanel();
        panelButtons.setLayout(new GridLayout(1, 2, 30, 5));
        panelButtons.setMaximumSize(new Dimension(2000, 100));
        panelButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton buttonCalc = new JButton(Messages.getString("PanelFunction.Map"));
        buttonCalc.setActionCommand("compute");
        buttonCalc.addActionListener(this);
        buttonCalc.setToolTipText(Messages.getString("PanelFunction.ComputeImage"));
        JButton buttonClear = new JButton(Messages.getString("PanelFunction.Delte"));
        buttonClear.setActionCommand("clear");
        buttonClear.addActionListener(this);
        buttonClear.setToolTipText(Messages.getString("PanelFunction.DeleteAll"));
        panelButtons.add(buttonCalc);
        panelButtons.add(buttonClear);
        return panelButtons;
    }

    private void clear() {
        this.main.mathpanelsource.clearMappables();
        this.main.mathpaneldest.clearMappedObjects();
        this.main.mathpaneldest.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
        this.main.mathpanelsource.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
        this.main.mathpaneldest.repaint();
        this.main.mathpanelsource.repaint();
        this.main.mathpanelsource.report(Messages.getString("PanelFunction.DeletedAll"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("clear")) {
            this.clear();
        }
        if (ev.getActionCommand().equals("compute")) {
            ComplexFunction function;
            this.main.mathpaneldest.clearMappedObjects();
            try {
                function = this.textFunction.getFunction();
            }
            catch (Exception e) {
                this.main.mathpanelsource.reportError(Messages.getString("PanelFunction.ErrorFunction"), e);
                return;
            }
            try {
                this.mapall(function);
            }
            catch (Exception e) {
                this.main.mathpanelsource.reportError(e);
            }
            this.main.mathpaneldest.repaint();
        }
    }

    private void mapall(ComplexFunction function) throws Exception {
        Iterator it = this.main.mathpanelsource.getMappables();
        int num = this.main.paneldiscretsize.getDiscretizationNum();
        if (!it.hasNext()) {
            this.main.mathpanelsource.reportError(Messages.getString("PanelFunction.ErrorNoObjectToMap"));
            return;
        }
        CoordinateRect2D rect = null;
        while (it.hasNext()) {
            MappableObject mappable = (MappableObject)it.next();
            try {
                mappable.map(function, num);
                if (rect == null) {
                    rect = mappable.getMappedObject().getLimits();
                } else {
                    CoordinateRect2D temp = mappable.getMappedObject().getLimits();
                    if (!rect.contains(temp)) {
                        rect = rect.combine(temp);
                    }
                }
                this.main.mathpaneldest.add(mappable.getMappedObject());
            }
            catch (Exception e) {
                this.main.mathpaneldest.clearMappedObjects();
                throw new Exception(Messages.getString("PanelFunction.ErrorObjectNotMapable"));
            }
            this.main.mathpaneldest.getScene2d().setLimits(rect);
            this.main.mathpanelsource.reportSuccess(Messages.getString("PanelFunction.ObjectMapped"));
        }
    }
}

