/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.complex2d.AppletComplex2D;
import uibk.applets.complex2d.Messages;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelCreatePolar
extends TitledPanel
implements ActionListener {
    AppletComplex2D main;
    JLabel label;
    JSlider slidersize;
    IntervalTextField radiusinterval;
    JTextField center;
    IntervalTextField arginterval;

    public PanelCreatePolar(AppletComplex2D main) {
        super(Messages.getString("PanelCreatePolar.PolarCoordinates"));
        this.main = main;
        this.initComponents();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("create")) {
            Punkt2D center = this.getCenter();
            Interval radius = this.getRadiusInterval();
            Interval arg = this.getArgInterval();
            if (center == null || radius == null || arg == null) {
                return;
            }
            int n = this.slidersize.getValue();
            this.main.mathpanelsource.clearMappables();
            this.main.objectcreator.createPolarCoords(center, arg.a, arg.b - arg.a, radius, n);
            this.main.mathpaneldest.clearMappedObjects();
            this.main.mathpaneldest.getScene2d().reset();
            this.main.mathpaneldest.repaint();
            this.main.mathpanelsource.reportSuccess(Messages.getString("PanelCreatePolar.CreatedPolarCoordinates"));
            this.main.mathpanelsource.repaint();
        }
    }

    Interval getRadiusInterval() {
        Interval interval;
        try {
            interval = this.radiusinterval.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
        if (interval.a < 0.0) {
            this.main.mathpanelsource.reportError(Messages.getString("PanelCreatePolar.ErrorLowerBoundary"));
            return null;
        }
        return interval;
    }

    Interval getArgInterval() {
        Interval interval = null;
        try {
            interval = this.arginterval.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
        if (interval.a < 0.0) {
            this.main.mathpanelsource.reportError(Messages.getString("PanelCreatePolar.ErrorUpperBoundary"));
            return null;
        }
        if (interval.getLength() > Math.PI * 2) {
            this.main.mathpanelsource.reportError(Messages.getString("PanelCreatePolar.ErrorIntervalLength"));
            return null;
        }
        return interval;
    }

    private Punkt2D getCenter() {
        try {
            return Misc.parsePunkt2D(this.center.getText(), Messages.getString("PanelCreatePolar.Center"));
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1000, 220));
        this.setPreferredSize(new Dimension(1000, 220));
        this.radiusinterval = new IntervalTextField(6, Messages.getString("PanelCreatePolar.IntervalRadius"), true);
        this.radiusinterval.setText("[0,1]");
        this.radiusinterval.setActionCommand("create");
        this.radiusinterval.addActionListener(this);
        this.radiusinterval.setToolTipText(Messages.getString("PanelCreatePolar.IntervalForRadiusInPolarCoordinates"));
        this.arginterval = new IntervalTextField(6, Messages.getString("PanelCreatePolar.IntervalArgument"), true);
        this.arginterval.setText("[0,2pi]");
        this.arginterval.setActionCommand("create");
        this.arginterval.addActionListener(this);
        this.arginterval.setToolTipText(Messages.getString("PanelCreatePolar.IntervalRadiusArgument"));
        this.center = new JTextField(6);
        this.center.setText("(0,0)");
        this.center.setActionCommand("create");
        this.center.addActionListener(this);
        this.center.setToolTipText(Messages.getString("PanelCreatePolar.CenterOfPolarCoordinates"));
        JButton buttoncreate = new JButton(Messages.getString("PanelCreatePolar.Create"));
        buttoncreate.setActionCommand("create");
        buttoncreate.addActionListener(this);
        buttoncreate.setToolTipText(Messages.getString("PanelCreatePolar.CreateIntersection"));
        this.slidersize = new JSlider();
        this.slidersize.setMinimum(3);
        this.slidersize.setValue(10);
        this.slidersize.setMaximum(30);
        this.label = new JLabel(String.valueOf(Messages.getString("PanelCreatePolar.GridLinesColon")) + this.slidersize.getValue() + "x" + this.slidersize.getValue());
        this.slidersize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelCreatePolar.this.label.setText(String.valueOf(Messages.getString("PanelCreatePolar.GridLinesColon")) + String.valueOf(n) + "x" + String.valueOf(n));
            }
        });
        this.add((Component)this.label, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.slidersize, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 15, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreatePolar.CenterColon")), new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.center, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreatePolar.IntervalRadiusColon")), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.radiusinterval, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreatePolar.IntervalArgumentColon")), new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.arginterval, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)buttoncreate, new GridBagConstraints(0, 6, 2, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
    }
}

