/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import uibk.applets.complex2d.AppletComplex2D;
import uibk.applets.complex2d.Messages;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Interval;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelCreateHouse
extends TitledPanel
implements ActionListener {
    AppletComplex2D main;
    IntervalTextField intervalx;
    IntervalTextField intervaly;

    public PanelCreateHouse(AppletComplex2D main) {
        super(Messages.getString("PanelCreateHouse.House"));
        this.main = main;
        this.initComponents();
    }

    private Interval getIntervalX() {
        try {
            return this.intervalx.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
    }

    private Interval getIntervalY() {
        try {
            return this.intervaly.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("create")) {
            Interval intx = this.getIntervalX();
            Interval inty = this.getIntervalY();
            if (intx == null || inty == null) {
                return;
            }
            CoordinateRect2D limits = new CoordinateRect2D(intx.a, intx.b, inty.a, inty.b);
            this.main.mathpanelsource.clearMappables();
            this.main.objectcreator.createHouse(limits);
            this.main.mathpaneldest.clearMappedObjects();
            this.main.mathpaneldest.getScene2d().reset();
            this.main.mathpaneldest.repaint();
            this.main.mathpanelsource.repaint();
            this.main.mathpanelsource.reportSuccess(Messages.getString("PanelCreateHouse.CreatedHouse"));
        }
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1000, 220));
        this.setPreferredSize(new Dimension(1000, 220));
        this.intervalx = new IntervalTextField(5, Messages.getString("PanelCreateHouse.IntervalRealPart"), true);
        this.intervalx.setText("[-1,1]");
        this.intervalx.setActionCommand("create");
        this.intervalx.addActionListener(this);
        this.intervalx.setToolTipText(Messages.getString("PanelCreateHouse.InsertIntervalRealpart"));
        this.intervaly = new IntervalTextField(5, Messages.getString("PanelCreateHouse.IntervalImaginaryPart"), true);
        this.intervaly.setText("[-1,1]");
        this.intervaly.setActionCommand("create");
        this.intervaly.addActionListener(this);
        this.intervaly.setToolTipText(Messages.getString("PanelCreateHouse.InsertIntervalImaginaryPart"));
        JButton buttoncreate = new JButton(Messages.getString("PanelCreateHouse.Create"));
        buttoncreate.setActionCommand("create");
        buttoncreate.addActionListener(this);
        buttoncreate.setToolTipText(Messages.getString("PanelCreateHouse.CreateHouse"));
        this.add((Component)new JLabel(Messages.getString("PanelCreateHouse.IntervalRealPartColon")), new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.intervalx, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateHouse.IntervalImaginaryPartColon")), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.intervaly, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)buttoncreate, new GridBagConstraints(0, 5, 3, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
    }
}

