/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.complex2d.AppletComplex2D;
import uibk.applets.complex2d.Messages;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Interval;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelCreateGrid
extends TitledPanel
implements ActionListener {
    AppletComplex2D main;
    JLabel label;
    JSlider slider;
    IntervalTextField intervalx;
    IntervalTextField intervaly;

    public PanelCreateGrid(AppletComplex2D main) {
        super(Messages.getString("PanelCreateGrid.Grid"));
        this.main = main;
        this.initComponents();
    }

    private Interval getIntervalX() {
        try {
            return this.intervalx.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
    }

    private Interval getIntervalY() {
        try {
            return this.intervaly.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("create")) {
            Interval intx = this.getIntervalX();
            Interval inty = this.getIntervalY();
            if (intx == null || inty == null) {
                return;
            }
            int n = this.slider.getValue();
            this.main.mathpanelsource.clearMappables();
            CoordinateRect2D limits = new CoordinateRect2D(intx.a, intx.b, inty.a, inty.b);
            this.main.objectcreator.createGrid(limits, n, n);
            this.main.mathpanelsource.getScene2d().setLimits(limits);
            this.main.mathpaneldest.clearMappedObjects();
            this.main.mathpaneldest.getScene2d().reset();
            this.main.mathpaneldest.repaint();
            this.main.mathpanelsource.repaint();
            this.main.mathpanelsource.reportSuccess(Messages.getString("PanelCreateGrid.CreatedGrid"));
        }
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.intervalx = new IntervalTextField(5, Messages.getString("PanelCreateGrid.IntervalRealPart"), true);
        this.intervalx.setText("[-1,1]");
        this.intervalx.setActionCommand("create");
        this.intervalx.addActionListener(this);
        this.intervalx.setToolTipText(Messages.getString("PanelCreateGrid.InsertIntervalForRealPart"));
        this.intervaly = new IntervalTextField(5, Messages.getString("PanelCreateGrid.IntervalImaginaryPart"), true);
        this.intervaly.setText("[-1,1]");
        this.intervaly.setActionCommand("create");
        this.intervaly.addActionListener(this);
        this.intervaly.setToolTipText(Messages.getString("PanelCreateGrid.InsertIntervalForImaginaryPart"));
        JButton buttoncreate = new JButton(Messages.getString("PanelCreateGrid.Create"));
        buttoncreate.setActionCommand("create");
        buttoncreate.addActionListener(this);
        buttoncreate.setToolTipText(Messages.getString("PanelCreateGrid.CreateGrid"));
        this.slider = new JSlider();
        this.slider.setMinimum(3);
        this.slider.setValue(10);
        this.slider.setMaximum(30);
        this.label = new JLabel(String.valueOf(Messages.getString("PanelCreateGrid.Size")) + this.slider.getValue() + "x" + this.slider.getValue());
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelCreateGrid.this.label.setText(String.valueOf(Messages.getString("PanelCreateGrid.Size")) + String.valueOf(n) + "x" + String.valueOf(n));
            }
        });
        this.add((Component)this.label, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.slider, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 15, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateGrid.IntervalRealColon")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.intervalx, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateGrid.IntervalImaginaryColon")), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.intervaly, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 15, 5), 0, 0));
        this.add((Component)buttoncreate, new GridBagConstraints(0, 5, 3, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.setMaximumSize(new Dimension(1000, 220));
    }
}

