/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.complex2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.complex2d.AppletComplex2D;
import uibk.applets.complex2d.Messages;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelCreateCut
extends TitledPanel
implements ActionListener {
    AppletComplex2D main;
    JLabel label;
    JSlider slidersize;
    IntervalTextField radiusinterval;
    JTextField center;
    DoubleTextField cutargument;
    DoubleTextField cutradius;

    public PanelCreateCut(AppletComplex2D main) {
        super(Messages.getString("PanelCreateCut.IntersectionPolarCoordinates"));
        this.main = main;
        this.initComponents();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("create")) {
            Punkt2D center = this.getCenter();
            Interval radius = this.getRadiusInterval();
            Double argcut = this.getArgumentCut();
            if (center == null || radius == null || argcut == null) {
                return;
            }
            Double radiuscut = this.getRadiusCut(radius);
            if (radiuscut == null) {
                return;
            }
            int n = this.slidersize.getValue();
            this.main.mathpanelsource.clearMappables();
            this.main.objectcreator.createPolarCoordsCut(center, radius, radiuscut, argcut, n);
            this.main.mathpaneldest.clearMappedObjects();
            this.main.mathpaneldest.getScene2d().reset();
            this.main.mathpaneldest.repaint();
            this.main.mathpanelsource.reportSuccess(Messages.getString("PanelCreateCut.CreatedIntersection"));
            this.main.mathpanelsource.repaint();
        }
    }

    private Interval getRadiusInterval() {
        Interval interval;
        try {
            interval = this.radiusinterval.getInterval();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
        if (interval.a < 0.0) {
            this.main.mathpanelsource.reportError(Messages.getString("PanelCreateCut.ErrorLowerLimit"));
            return null;
        }
        return interval;
    }

    private Punkt2D getCenter() {
        try {
            return Misc.parsePunkt2D(this.center.getText(), Messages.getString("PanelCreateCut.Center"));
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
    }

    Double getRadiusCut(Interval rinterval) {
        double radiuscut;
        try {
            this.cutradius.evaluateInput();
            radiuscut = this.cutradius.getValue();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
        if (!rinterval.contains(radiuscut)) {
            this.main.mathpanelsource.reportError(String.valueOf(Messages.getString("PanelCreateCut.ErrorRadiusOfIntersectionNotInInterval")) + rinterval + Messages.getString("PanelCreateCut.Included"));
            return null;
        }
        return new Double(radiuscut);
    }

    Double getArgumentCut() {
        double argcut;
        try {
            this.cutargument.evaluateInput();
            argcut = this.cutargument.getValue();
        }
        catch (Exception ex) {
            this.main.mathpanelsource.reportError(ex);
            return null;
        }
        if (argcut < 0.0 || argcut >= Math.PI * 2) {
            this.main.mathpanelsource.reportError(Messages.getString("PanelCreateCut.ErrorAngleIsNotIn0T02Pi"));
            return null;
        }
        return new Double(argcut);
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1000, 250));
        this.setPreferredSize(new Dimension(1000, 250));
        this.radiusinterval = new IntervalTextField(6, Messages.getString("PanelCreateCut.IntervalRadius"), true);
        this.radiusinterval.setText("[0,1]");
        this.radiusinterval.setActionCommand("create");
        this.radiusinterval.addActionListener(this);
        this.radiusinterval.setToolTipText(Messages.getString("PanelCreateCut.RadiusPolarCoordinates"));
        this.center = new JTextField(6);
        this.center.setText("(0,0)");
        this.center.setActionCommand("create");
        this.center.addActionListener(this);
        this.center.setToolTipText(Messages.getString("PanelCreateCut.CenterPolarCoordinates"));
        this.cutargument = new DoubleTextField(6, null, null, null, Messages.getString("PanelCreateCut.ArgumentOfIntersection"));
        this.cutargument.setText(Messages.getString("PanelCreateCut.Pi"));
        this.cutargument.setActionCommand("create");
        this.cutargument.addActionListener(this);
        this.cutargument.setToolTipText(Messages.getString("PanelCreateCut.AngleOfTheIntersection"));
        this.cutradius = new DoubleTextField(6, null, null, null, Messages.getString("PanelCreateCut.RadiusIntersection"));
        this.cutradius.setText("0");
        this.cutradius.setActionCommand("create");
        this.cutradius.addActionListener(this);
        this.cutradius.setToolTipText(Messages.getString("PanelCreateCut.RadiusWhereIntersectionStarts"));
        JButton buttoncreate = new JButton(Messages.getString("PanelCreateCut.Create"));
        buttoncreate.setActionCommand("create");
        buttoncreate.addActionListener(this);
        buttoncreate.setToolTipText(Messages.getString("PanelCreateCut.CreateTheIntersection"));
        this.slidersize = new JSlider();
        this.slidersize.setMinimum(3);
        this.slidersize.setValue(10);
        this.slidersize.setMaximum(30);
        this.label = new JLabel(String.valueOf(Messages.getString("PanelCreateCut.GridLines")) + this.slidersize.getValue() + "x" + this.slidersize.getValue());
        this.slidersize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelCreateCut.this.label.setText(String.valueOf(Messages.getString("PanelCreateCut.GridLines")) + String.valueOf(n) + "x" + String.valueOf(n));
            }
        });
        this.add((Component)this.label, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.slidersize, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 15, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateCut.CenterColon")), new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.center, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateCut.IntervalRadiusColon")), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.radiusinterval, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateCut.ArgumentIntersectionColon")), new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.cutargument, new GridBagConstraints(1, 6, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCreateCut.RadiusIntersectionColon")), new GridBagConstraints(0, 7, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.cutradius, new GridBagConstraints(1, 7, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)buttoncreate, new GridBagConstraints(0, 8, 2, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
    }
}

