/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.functions;

import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom2d.Vector2D;
import uibk.mtk.lang.Settings;
import uibk.mtk.math.functions.Function2D;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Variable;

public class ParsedFunction2D
extends ParsedFunction
implements Function2D {
    public ParsedFunction2D(Variable varx, Variable vary, Expr function) {
        super(new Variable[]{varx, vary}, new Expr[]{function});
    }

    public double getValue(double x, double y) {
        double[] v = new double[]{x, y};
        return super.getValue(v)[0];
    }

    public double getValue(Punkt2D p) {
        return this.getValue(p.x, p.y);
    }

    public double getDerivate(Punkt2D a, Vector2D v) throws Exception {
        double[] deriv = this.directionalDerivate(new double[]{a.x, a.y}, new double[]{v.x, v.y});
        return deriv[0];
    }

    public Punkt2D getDerivate1(Punkt2D v) {
        double h = this.gethSymm1((v.x + v.y) / 2.0);
        Punkt2D deriv = new Punkt2D();
        deriv.x = (this.getValue(v.x + h, v.y) - this.getValue(v.x - h, v.y)) / (2.0 * h);
        deriv.y = (this.getValue(v.x, v.y - h) - this.getValue(v.x, v.y + h)) / (2.0 * h);
        return deriv;
    }

    private double gethSymm1(double x) {
        double hsym = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        double s = Math.max(1.0, Math.abs(x));
        return hsym * s;
    }

    private double gethSymm2(double x) {
        double hsym = Math.pow(Settings.getMachinePrecision(), 0.25);
        double s = Math.max(1.0, Math.abs(x));
        return hsym * s;
    }

    public Punkt2D[] getDerivate2(Punkt2D v) {
        double h = this.gethSymm2((v.x + v.y) / 2.0);
        Punkt2D[] deriv = new Punkt2D[]{new Punkt2D(), new Punkt2D()};
        deriv[0].x = (this.getValue(v.x - h, v.y) + this.getValue(v.x + h, v.y) - 2.0 * this.getValue(v.x, v.y)) / (h * h);
        deriv[1].y = (this.getValue(v.x, v.y - h) + this.getValue(v.x, v.y + h) - 2.0 * this.getValue(v.x, v.y)) / (h * h);
        deriv[1].x = deriv[0].y = (this.getValue(v.x + h, v.y + h) - this.getValue(v.x - h, v.y + h) - this.getValue(v.x + h, v.y - h) + this.getValue(v.x - h, v.y - h)) / (4.0 * h * h);
        return deriv;
    }
}

