/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.lang;

public abstract class Animation
implements Runnable {
    private Thread t1 = null;
    private int delay = 100;
    private int slowDownTime = 1;
    private long timeOld = 0L;

    public void run() {
        this.timeOld = System.currentTimeMillis();
        while (true) {
            this.compute();
            if (this.t1.isInterrupted()) break;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.t1.interrupt();
            }
        }
    }

    public synchronized void start() {
        if (this.t1 == null) {
            this.t1 = new Thread((Runnable)this, "Calc");
        }
        if (!this.t1.isAlive()) {
            this.t1 = new Thread((Runnable)this, "Calc");
            this.t1.start();
        }
    }

    public synchronized void stop() {
        if (!this.isStop()) {
            try {
                this.t1.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isStop() {
        if (this.t1 != null) {
            return !this.t1.isAlive();
        }
        return true;
    }

    public synchronized void setDelay(int delay) {
        this.delay = delay;
    }

    public synchronized void setSlowDownTime(int b) {
        this.slowDownTime = b <= 0 ? 1 : b;
    }

    public synchronized double getTime() {
        double timeRet = System.currentTimeMillis() - this.timeOld;
        this.timeOld = System.currentTimeMillis();
        return timeRet / (double)(1000 * this.slowDownTime);
    }

    protected abstract void compute();
}

