/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.util;

import java.util.Iterator;
import java.util.Vector;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.SingularityChecker;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.math.functions.ParametricCurve2D;
import uibk.mtk.math.functions.ParametricCurve3D;
import uibk.mtk.util.IntervalIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphUtil {
    private static final String BUNDLE_NAME = "uibk.mtk.draw2d.util.messages";

    private GraphUtil() {
    }

    public static Vector compute(ParametricCurve2D curve2d, double paramstart, double paramend, int n) throws Exception {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        IntervalIterator it = new IntervalIterator(paramstart, paramend, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            Punkt2D p = curve2d.calcPoint(t);
            if (!p.isReal()) {
                throw new Exception(Messages.getString(BUNDLE_NAME, "GraphUtil.0"));
            }
            points.add(p);
        }
        return points;
    }

    public static Vector compute(ParametricCurve3D curve3d, double paramstart, double paramend, int n) throws Exception {
        Vector<Punkt3D> points = new Vector<Punkt3D>();
        IntervalIterator it = new IntervalIterator(paramstart, paramend, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            Punkt3D p = curve3d.calcPoint(t);
            if (!p.isReal()) {
                throw new Exception(Messages.getString(BUNDLE_NAME, "GraphUtil.0"));
            }
            points.add(p);
        }
        return points;
    }

    public static Vector compute(Function1D function, double xstart, double xend, int n) throws Exception {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        IntervalIterator it = new IntervalIterator(xstart, xend, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            double y = function.getValue(t);
            if (Double.isNaN(y) || Double.isInfinite(y)) {
                throw new Exception(Messages.getString(BUNDLE_NAME, "GraphUtil.0"));
            }
            points.add(new Punkt2D(t, y));
        }
        return points;
    }

    public static Vector computewithsing(Function1D function, double xstart, double xend, int n) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        IntervalIterator it1 = new IntervalIterator(xstart, xend, n);
        while (it1.hasNext()) {
            double t = it1.nextdouble();
            double y = function.getValue(t);
            if (y > max) {
                max = y;
            }
            if (!(y < min)) continue;
            min = y;
        }
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        SingularityChecker sing = new SingularityChecker(min, max);
        IntervalIterator it = new IntervalIterator(xstart, xend, n);
        double last = 0.0;
        while (it.hasNext()) {
            double t = it.nextdouble();
            boolean s = false;
            s = it.getPos() > 1 ? sing.hasSingularity(function, last, t) : sing.hasSingularity(function, t, t);
            if (s) {
                points.add(null);
            } else {
                double y = function.getValue(t);
                points.add(new Punkt2D(t, y));
            }
            last = t;
        }
        return points;
    }

    public static Vector convertPointsToGraphs(Vector v) {
        Vector<Graph2D> graphs = new Vector<Graph2D>();
        Iterator it = v.iterator();
        Graph2D g = new Graph2D();
        while (it.hasNext()) {
            Punkt2D p = (Punkt2D)it.next();
            if (p == null) {
                if (g.getNumberPoints() > 0) {
                    graphs.add(g);
                }
                g = new Graph2D();
            }
            g.addPoint(p);
        }
        if (g.getNumberPoints() > 0) {
            graphs.add(g);
        }
        return graphs;
    }

    public static Vector<Double> compute(Graph2D graph, int n) {
        IntervalIterator it = new IntervalIterator(graph.getFirstPoint().x, graph.getLastPoint().x, n);
        Vector points = graph.getPoints();
        Vector<Double> values = new Vector<Double>();
        int i = 0;
        double value = 0.0;
        boolean flag = true;
        while (it.hasNext()) {
            flag = true;
            double t = it.nextdouble();
            while (flag) {
                if (t > ((Punkt2D)points.get((int)(i + 1))).x) {
                    ++i;
                    continue;
                }
                flag = false;
            }
            value = ((Punkt2D)points.get((int)i)).y + (t - ((Punkt2D)points.get((int)i)).x) * (((Punkt2D)points.get((int)(i + 1))).y - ((Punkt2D)points.get((int)i)).y) / (((Punkt2D)points.get((int)(i + 1))).x - ((Punkt2D)points.get((int)i)).x);
            values.add(new Double(value));
        }
        return values;
    }
}

