/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class MathSquare2D
extends Drawable2D
implements ToolTipable {
    protected double x;
    protected double y;
    protected int size = 1;
    protected boolean tooltipenabled = false;
    protected String toolTip = null;
    protected String caption = null;

    public MathSquare2D() {
    }

    public MathSquare2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setCoordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setToolTipText(String tooltip) {
        this.toolTip = tooltip;
    }

    public void setTitel(String caption) {
        this.caption = caption;
    }

    public String getTitel() {
        return this.caption;
    }

    public void setCoordinates(Punkt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean b) {
        this.tooltipenabled = b;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public int getRadius() {
        return this.size;
    }

    public boolean tooltipcontains(int xm, int ym) {
        int yp;
        int xp = this.scene2d.xToPixel(this.x);
        return (xm - xp) * (xm - xp) + (ym - (yp = this.scene2d.yToPixel(this.y))) * (ym - yp) <= this.size * this.size;
    }

    public Punkt2D getPunkt2D() {
        return new Punkt2D(this.x, this.y);
    }

    public String getToolTipText(MouseEvent ev) {
        if (this.toolTip == null) {
            String str = "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
            return str;
        }
        return this.toolTip;
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        g2.fillRect(this.scene2d.xToPixel(this.x) - this.size, this.scene2d.yToPixel(this.y) - this.size, 2 * this.size + 1, 2 * this.size + 1);
        if (this.caption != null && this.caption != "") {
            g2.drawString(this.caption, this.scene2d.xToPixel(this.x) + 2 * this.size + 1, this.scene2d.yToPixel(this.y) + 2 * this.size + 1);
        }
    }
}

