/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.funktion2d;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import uibk.applets.funktion2d.AppletFunktion2d;
import uibk.applets.funktion2d.TableModel;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.objects.MathSquare2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;

public class ReportingTable
extends JTable {
    private final AppletFunktion2d main;
    TableModel tm;
    static String[] labels = new String[]{Messages.getString("uibk.applets.funktion2d.messages", "ReportingTable.1"), Messages.getString("uibk.applets.funktion2d.messages", "ReportingTable.2")};
    private Vector points = new Vector();

    public ReportingTable(AppletFunktion2d main) {
        super(new TableModel(0, labels.length));
        this.tm = (TableModel)this.dataModel;
        this.main = main;
        this.setDefaultRenderer(Object.class, new DateRenderer());
        this.tm.setColumnnames(labels);
        this.tm.fireTableStructureChanged();
        this.getColumn(this.getColumnName(0)).setMinWidth(30);
        this.getColumn(this.getColumnName(1)).setPreferredWidth(1000);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ReportingTable.this.printData();
            }
        });
    }

    public void cleardata() {
        this.tm.cleardata();
        this.points.removeAllElements();
        this.tm.fireTableStructureChanged();
    }

    public void add(Object[] data, MathPoint2D p, Interval i) {
        int j = 0;
        j = 0;
        while (j < this.points.size()) {
            if (this.points.get(j) instanceof MathPoint2D && p.getTitel() == ((MathPoint2D)this.points.get(j)).getTitel()) {
                ++j;
                break;
            }
            if (this.points.get(j) instanceof DataSingularitaet && p.getTitel() == ((DataSingularitaet)this.points.get((int)j)).s.getTitel()) {
                ++j;
                break;
            }
            ++j;
        }
        this.tm.addrow(j, data);
        this.tm.fireTableStructureChanged();
        this.getColumn(this.getColumnName(0)).setMinWidth(30);
        this.getColumn(this.getColumnName(1)).setPreferredWidth(1000);
        if (i == null) {
            this.points.add(j, p);
        } else {
            this.points.add(j, new DataSingularitaet(this.getSquareOfPoint(p), i));
        }
    }

    private MathSquare2D getSquareOfPoint(MathPoint2D p) {
        MathSquare2D s = new MathSquare2D(p.getX(), p.getY());
        s.setColor(p.getColor());
        s.setSize(p.getRadius());
        return s;
    }

    public void printData() {
        int row = this.getSelectedRow();
        String bez = this.tm.getValueAt(row, 0).toString();
        String typ = this.tm.getValueAt(row, 1).toString();
        Drawable2D Math2 = null;
        if (this.points.get(row) instanceof DataSingularitaet) {
            Interval i = ((DataSingularitaet)this.points.get((int)row)).i;
            Math2 = ((DataSingularitaet)this.points.get((int)row)).s;
            this.main.f2D.report(String.valueOf(bez) + ": " + typ + " im Intervall: [" + i.a + " , " + i.b + "]");
        } else if (this.points.get(row) instanceof MathPoint2D) {
            Math2 = (MathPoint2D)this.points.get(row);
            double x = ((MathPoint2D)Math2).getX();
            double y = ((MathPoint2D)Math2).getY();
            this.main.f2D.report(String.valueOf(bez) + "(" + typ + "): (x , f(x)) = (" + x + " , " + y + ")");
        }
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.points.get(i) instanceof MathPoint2D) {
                ((MathPoint2D)this.points.get(i)).setColor(Color.blue);
            }
            if (this.points.get(i) instanceof DataSingularitaet) {
                ((DataSingularitaet)this.points.get((int)i)).s.setColor(Color.blue);
            }
            ++i;
        }
        this.main.f2D.delete(Math2);
        Math2.setColor(Color.green);
        this.main.f2D.add(Math2);
        this.main.f2D.repaint();
    }

    private class DataSingularitaet {
        public MathSquare2D s;
        public Interval i;

        DataSingularitaet(MathSquare2D s, Interval i) {
            this.s = s;
            this.i = i;
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            super.setValue(value);
            Color b = this.getBackground();
            if (b.equals(Color.white)) {
                if (value.toString().getBytes()[0] == 102 || value.toString().getBytes()[0] == 73) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
        }
    }
}

