/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.funktion2d;

import java.util.Vector;
import uibk.applets.funktion2d.StatusAnzeige;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Settings;
import uibk.mtk.math.Interval;
import uibk.mtk.math.Rounder;
import uibk.mtk.math.SingularityChecker;
import uibk.mtk.math.functions.Function2D;
import uibk.mtk.math.functions.ParsedFunction1D;
import uibk.mtk.math.parsing.Function1DParser;
import uibk.mtk.math.parsing.Function2DParser;
import uibk.mtk.util.IntervalIterator;

public class MyFunction {
    private Function2D f = null;
    private Function2D fs = null;
    private Function2D fss = null;
    private Function2D fsss = null;
    private Vector f_sing = new Vector();
    private Vector fs_sing = new Vector();
    private Vector fss_sing = new Vector();
    private Vector fsss_sing = new Vector();
    private final double EPS = 1.0E-6;
    boolean chekSing = true;

    public MyFunction(String f) throws Exception {
        Function1DParser.parse("x", f);
        this.f = Function2DParser.parse("x", "h", f);
        f = f.replaceAll("exp", "tmp");
        String forward = "(" + f.replaceAll("x", "(x+h)") + ")";
        String backward = "(" + f.replaceAll("x", "(x-h)") + ")";
        String s = "(" + forward + "-" + backward + ")/(2*h)";
        s = s.replaceAll("tmp", "exp");
        this.fs = Function2DParser.parse("x", "h", s);
        forward = "(" + f.replaceAll("x", "(x+h)") + ")";
        backward = "(" + f.replaceAll("x", "(x-h)") + ")";
        s = "(" + forward + "-2*(" + f + ")+" + backward + ")/(h^2)";
        s = s.replaceAll("tmp", "exp");
        this.fss = Function2DParser.parse("x", "h", s);
        String forward3 = "(" + f.replaceAll("x", "(x+3*h)") + ")";
        forward = "3*(" + f.replaceAll("x", "(x+h)") + ")";
        backward = "3*(" + f.replaceAll("x", "(x-h)") + ")";
        String backward3 = "(" + f.replaceAll("x", "(x-3*h)") + ")";
        s = "(" + forward3 + "-" + forward + "+" + backward + "-" + backward3 + ")/((2*h)^3)";
        s = s.replaceAll("tmp", "exp");
        this.fsss = Function2DParser.parse("x", "h", s);
    }

    public double getValue(double x) throws Exception {
        this.checkSing(x, this.f_sing, Messages.getString("uibk.applets.funktion2d.messages", "MyFunction.1"));
        return this.f.getValue(x, 1.0);
    }

    public double getValueRound(double x, String label) throws Exception {
        if (label == Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.12")) {
            return 0.0;
        }
        if (label == Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.22") || label == Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.23")) {
            return Rounder.roundNumPlacesNext(this.getValue(x), 8);
        }
        if (label == Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.32")) {
            return Rounder.roundNumPlacesNext(this.getValue(x), 4);
        }
        return this.getValue(x);
    }

    public double getDerivation(double x) throws Exception {
        this.checkSing(x, this.fs_sing, Messages.getString("uibk.applets.funktion2d.messages", "MyFunction.2"));
        double s = Math.max(1.0, Math.abs(x));
        double h = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333) * s;
        return this.fs.getValue(x, h);
    }

    public double getDerivation2(double x) throws Exception {
        this.checkSing(x, this.fss_sing, Messages.getString("uibk.applets.funktion2d.messages", "MyFunction.3"));
        double s = Math.max(1.0, Math.abs(x));
        double h = Math.pow(Settings.getMachinePrecision(), 0.25) * s;
        return this.fss.getValue(x, h);
    }

    public double getDerivation3(double x) throws Exception {
        this.checkSing(x, this.fsss_sing, Messages.getString("uibk.applets.funktion2d.messages", "MyFunction.4"));
        double s = Math.max(1.0, Math.abs(x));
        double h = Math.pow(Settings.getMachinePrecision(), 0.2) * s;
        return this.fsss.getValue(x, h);
    }

    public Vector getPoints_f(double xstart, double xend, int n, StatusAnzeige s) {
        if (this.f != null) {
            this.f_sing = new Vector();
            return this.getPoints(this.f, xstart, xend, n, 1, s);
        }
        return null;
    }

    public Vector getPoints_fs(double xstart, double xend, int n, StatusAnzeige s) {
        if (this.fs != null) {
            this.fs_sing = new Vector();
            return this.getPoints(this.fs, xstart, xend, n, 2, s);
        }
        return null;
    }

    public Vector getPoints_fss(double xstart, double xend, int n, StatusAnzeige s) {
        if (this.fss != null) {
            this.fss_sing = new Vector();
            return this.getPoints(this.fss, xstart, xend, n, 3, s);
        }
        return null;
    }

    public Vector getPoints_fsss(double xstart, double xend, int n, StatusAnzeige s) {
        if (this.fsss != null) {
            this.fsss_sing = new Vector();
            return this.getPoints(this.fsss, xstart, xend, n, 4, s);
        }
        return null;
    }

    private Vector getPoints(Function2D f, double xstart, double xend, int n, int typ, StatusAnzeige s) {
        double h;
        double t;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        IntervalIterator it1 = new IntervalIterator(xstart, xend, n);
        while (it1.hasNext()) {
            t = it1.nextdouble();
            double y = f.getValue(t, h = this.getOptH(typ, t));
            if (y > max) {
                max = y;
            }
            if (!(y < min)) continue;
            min = y;
        }
        if (max - min < 9.999999999999999E-5) {
            max += 0.01;
            min -= 0.01;
        }
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        SingularityChecker sing = new SingularityChecker(min, max);
        IntervalIterator it = new IntervalIterator(xstart, xend, n);
        double last = 0.0;
        t = 0.0;
        double ta = 0.0;
        double tb = 0.0;
        if (it.hasNext()) {
            ta = t = it.nextdouble();
            tb = t;
        }
        while (it.hasNext()) {
            s.increase();
            ta = t;
            t = tb;
            tb = it.nextdouble();
            boolean singu = false;
            h = this.getOptH(typ, t);
            ParsedFunction1D f1D = null;
            try {
                f1D = Function1DParser.parse("x", f.toString().replaceAll("h", "" + h));
            }
            catch (Exception e) {
                return null;
            }
            singu = it.getPos() > 2 ? sing.hasSingularity(f1D, last, t) : sing.hasSingularity(f1D, t, t);
            if (singu) {
                double b;
                double a;
                if (typ == 1) {
                    a = Rounder.roundNumPlacesNext(ta, 8);
                    b = Rounder.roundNumPlacesNext(tb, 8);
                    this.f_sing.add(new Interval(a, b));
                } else if (typ == 2) {
                    a = Rounder.roundNumPlacesNext(ta, 6);
                    b = Rounder.roundNumPlacesNext(tb, 6);
                    this.fs_sing.add(new Interval(a, b));
                } else if (typ == 3) {
                    a = Rounder.roundNumPlacesNext(ta, 6);
                    b = Rounder.roundNumPlacesNext(tb, 6);
                    this.fss_sing.add(new Interval(a, b));
                } else if (typ == 4) {
                    a = Rounder.roundNumPlacesNext(ta, 6);
                    b = Rounder.roundNumPlacesNext(tb, 6);
                    this.fsss_sing.add(new Interval(a, b));
                }
                points.add(null);
            } else {
                double y = f.getValue(t, h);
                points.add(new Punkt2D(t, y));
            }
            last = t;
        }
        return points;
    }

    private void checkSing(double x, Vector v, String error) throws Exception {
        if (v == null) {
            return;
        }
        if (error == null) {
            return;
        }
        int j = 0;
        while (j < v.size()) {
            Interval i = (Interval)v.get(j);
            if (x > i.a && x < i.b) {
                throw new Exception(error);
            }
            ++j;
        }
    }

    public double getOptH(int typ, double x) {
        double s = Math.max(1.0, Math.abs(x));
        if (typ == 2) {
            return Math.pow(Settings.getMachinePrecision(), 0.3333333333333333) * s;
        }
        if (typ == 3) {
            return Math.pow(Settings.getMachinePrecision(), 0.25) * s;
        }
        if (typ == 4) {
            return Math.pow(Settings.getMachinePrecision(), 0.2) * s;
        }
        return 1.0;
    }

    public Vector getIntervall_fSing() {
        return this.f_sing;
    }

    public Vector getIntervall_fsSing() {
        return this.fs_sing;
    }

    public Vector getIntervall_fssSing() {
        return this.fss_sing;
    }

    public Vector getIntervall_fsssSing() {
        return this.fsss_sing;
    }
}

