/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.funktion2d;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import uibk.applets.funktion2d.AppletFunktion2d;
import uibk.applets.funktion2d.MyFunction;
import uibk.applets.funktion2d.PanelCommand;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathLine2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.objects.MathSquare2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.Rounder;
import uibk.mtk.util.IntervalIterator;

public class InteractionControl
implements ActionListener,
KeyListener,
Runnable {
    private final AppletFunktion2d main;
    private final PanelCommand command;
    public int anzahlPoints_Graph = 500;
    private Graph2D graphf2D = new Graph2D();
    private Graph2D graphfs2D = new Graph2D();
    private Graph2D graphfss2D = new Graph2D();
    private Vector pointf2D = new Vector();
    private Vector pointfs2D = new Vector();
    private Vector pointfss2D = new Vector();
    private int anzPkt = -1;
    private int anzPktCaption = 0;
    MathLine2D tangentef = new MathLine2D();
    MathLine2D tangentefs = new MathLine2D();
    private boolean isReady = false;
    public static final double EPS = 1.0E-6;
    ActionEvent event;

    InteractionControl(AppletFunktion2d main, PanelCommand command) {
        this.main = main;
        this.command = command;
        this.initComponents();
    }

    public void run() {
        Cursor c = new Cursor(3);
        this.main.setCursor(c);
        this.command.setPaintEnable(false);
        this.command.setDsikEnable(false);
        try {
            if (this.event.getActionCommand().equals("zeichnen")) {
                this.command.datenLesen();
                this.zeichnen();
                this.isReady = true;
            }
            if (this.event.getActionCommand().equals("loeschen")) {
                this.zeichnen();
            }
            if (this.event.getActionCommand().equals("kurvenDisk")) {
                this.command.status.setValue(0);
                this.command.status.setMaximum(1000);
                Thread t1 = new Thread(this.command.status);
                t1.start();
                this.kurvenDisk(true);
                t1.interrupt();
            }
            this.command.setDsikEnable(true);
        }
        catch (Exception e) {
            this.main.f2D.reportError(e);
            this.main.initMathPanel();
            this.initComponents();
            this.command.table.cleardata();
            this.isReady = false;
        }
        c = new Cursor(0);
        this.main.setCursor(c);
        this.main.graphRepaint();
        this.command.status.maxValue();
        this.command.setPaintEnable(true);
    }

    public void initComponents() {
        this.graphf2D.setVisible(false);
        this.graphfs2D.setVisible(false);
        this.graphfss2D.setVisible(false);
        this.graphf2D.setColor(Color.darkGray);
        this.graphfs2D.setColor(Color.darkGray);
        this.graphfss2D.setColor(Color.darkGray);
        this.main.f2D.addMouseMotionListener(new MyMouseMotionListener());
        this.tangentef.setVisible(false);
        this.tangentefs.setVisible(false);
    }

    private void newPoint() {
        ++this.anzPkt;
        MathPoint2D p1 = new MathPoint2D();
        p1.setRadius(5);
        p1.setVisible(true);
        this.main.f2D.add(p1);
        this.pointf2D.add(p1);
        MathPoint2D p2 = new MathPoint2D();
        p2.setRadius(4);
        p2.setVisible(true);
        this.main.fs2D.add(p2);
        this.pointfs2D.add(p2);
        MathPoint2D p3 = new MathPoint2D();
        p3.setRadius(4);
        p3.setVisible(true);
        this.main.fss2D.add(p3);
        this.pointfss2D.add(p3);
    }

    public void actionPerformed(ActionEvent ev) {
        this.event = ev;
        Thread t1 = new Thread(this);
        t1.start();
    }

    public void keyTyped(KeyEvent key) {
    }

    public void keyPressed(KeyEvent key) {
    }

    public void keyReleased(KeyEvent key) {
        if (key.getKeyChar() == '\n') {
            this.command.clickButtonPaint();
        }
    }

    private void zeichnen() throws Exception {
        this.main.initMathPanel();
        this.main.setMainPanelVisible(false);
        this.command.table.cleardata();
        this.anzPkt = -1;
        this.anzPktCaption = 0;
        this.pointf2D.removeAllElements();
        this.pointfs2D.removeAllElements();
        this.pointfss2D.removeAllElements();
        MyFunction f = this.command.getFunction();
        Interval i = this.command.getInterval();
        this.anzahlPoints_Graph = this.command.getAnzPunkte();
        this.command.status.setMaximum(this.anzahlPoints_Graph * 4 + 1000);
        this.command.status.setValue(0);
        Thread threadStatus = new Thread(this.command.status);
        threadStatus.start();
        this.check(f, i);
        Vector points = f.getPoints_f(i.a, i.b, this.anzahlPoints_Graph, this.command.status);
        boolean isSingulaer = true;
        boolean hatSingulaerPunkte = false;
        int j = 0;
        while (j < points.size()) {
            if (points.get(j) != null) {
                isSingulaer = false;
            } else {
                hatSingulaerPunkte = true;
            }
            ++j;
        }
        if (isSingulaer) {
            throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.5"));
        }
        this.paintFunktion(this.graphf2D, this.main.f2D, points);
        points = f.getPoints_fs(i.a, i.b, this.anzahlPoints_Graph, this.command.status);
        isSingulaer = true;
        j = 0;
        while (j < points.size()) {
            if (points.get(j) != null) {
                isSingulaer = false;
                break;
            }
            ++j;
        }
        if (isSingulaer) {
            throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.3"));
        }
        this.paintFunktion(this.graphfs2D, this.main.fs2D, points);
        points = f.getPoints_fss(i.a, i.b, this.anzahlPoints_Graph, this.command.status);
        isSingulaer = true;
        j = 0;
        while (j < points.size()) {
            if (points.get(j) != null) {
                isSingulaer = false;
                break;
            }
            ++j;
        }
        if (isSingulaer) {
            throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.4"));
        }
        this.paintFunktion(this.graphfss2D, this.main.fss2D, points);
        f.getPoints_fsss(i.a, i.b, this.anzahlPoints_Graph, this.command.status);
        if (hatSingulaerPunkte) {
            this.main.f2D.reportError(Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.7"));
        }
        this.newPoint();
        this.addSingIntervall(f.getIntervall_fSing(), Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.8"), f);
        this.addSingIntervall(f.getIntervall_fsSing(), Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.3"), f);
        this.addSingIntervall(f.getIntervall_fssSing(), Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.4"), f);
        this.kurvenDisk(false);
        this.main.f2D.add(this.graphf2D);
        this.main.fs2D.add(this.graphfs2D);
        this.main.fss2D.add(this.graphfss2D);
        this.main.f2D.add(this.tangentef);
        this.tangentef.setVisible(true);
        this.main.fs2D.add(this.tangentefs);
        this.tangentefs.setVisible(true);
        this.main.setMainPanelVisible(true);
        this.main.f2D.report(Messages.getString("uibk.applets.funktion2d.messages", "AppletFunktion2d.2"));
        threadStatus.interrupt();
    }

    private void kurvenDisk(boolean addPoints) throws Exception {
        MyFunction f = this.command.getFunction();
        Interval i = this.command.getInterval();
        this.check(f, i);
        int steps = 1000;
        IntervalIterator it1 = new IntervalIterator(i.a, i.b, steps);
        double x = 0.0;
        while (it1.hasNext()) {
            this.command.status.increase();
            x = it1.nextdouble();
            double a = x - i.getLength() / 499.0 > i.a ? x - i.getLength() / 499.0 : i.a;
            double b = x + i.getLength() / 499.0 < i.b ? x + i.getLength() / 499.0 : i.b;
            try {
                this.setPunkt(x, false, null, null, this.command.getFunction(), null);
                this.command.kurvenDisk.nullStelle(new Interval(a, b), addPoints);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPunkt(x, false, null, null, this.command.getFunction(), null);
                this.command.kurvenDisk.extrema(new Interval(a, b), addPoints);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPunkt(x, false, null, null, this.command.getFunction(), null);
                this.command.kurvenDisk.wendePkt(new Interval(a, b), addPoints);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void check(MyFunction f, Interval i) throws Exception {
        if (f == null) {
            throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.1"));
        }
        if (i == null) {
            throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "InteractionControl.1"));
        }
    }

    private void paintFunktion(Graph2D graph, MathPanel2D mathPanel, Vector points) {
        graph.setVisible(true);
        graph.clearpoints();
        graph.setPoints(points);
        CoordinateRect2D limits = (CoordinateRect2D)graph.getLimits().clone();
        if (Math.abs(graph.getLimits().getYRange()) < 1.0E-6) {
            limits.ymax += 0.01;
            limits.ymin -= 0.01;
        }
        mathPanel.getScene2d().setLimits(limits);
    }

    private void report(String text, double x, double y) {
        x = Rounder.roundNumPlaces(x, 2);
        y = Rounder.roundNumPlaces(y, 2);
        this.main.f2D.report(String.valueOf(text) + "(x,y)=( " + x + " , " + y + " )");
    }

    private void tangente(double x, double f_x, double steig, Scene2D scene2d, MathLine2D tangente) {
        double eps = scene2d.getXRange() > scene2d.getYRange() ? scene2d.getXRange() / 5.0 : scene2d.getYRange() / 5.0;
        double xt = 1.0 / this.norm(1.0, steig) * eps;
        double yt = steig / this.norm(1.0, steig) * eps;
        int xt1 = scene2d.xToPixel(x + xt);
        int yt1 = scene2d.yToPixel(f_x + yt);
        int xt2 = scene2d.xToPixel(x - xt);
        int yt2 = scene2d.yToPixel(f_x - yt);
        double lP = this.norm(xt1 - xt2, yt1 - yt2);
        xt = xt / lP * (double)scene2d.getCoordinatePixelRectangle().width / 5.0;
        yt = yt / lP * (double)scene2d.getCoordinatePixelRectangle().width / 5.0;
        tangente.setPoints(x + xt, f_x + yt, x - xt, f_x - yt);
    }

    private double norm(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public boolean isReady() {
        return this.isReady;
    }

    public Vector getPunkte() {
        return this.pointf2D;
    }

    public double getLastPunktX() {
        double x = ((MathPoint2D)this.pointf2D.get(this.anzPkt)).getX();
        return x;
    }

    public void setPunkt(double x, boolean neu, String label, String caption, MyFunction f, Interval SingI) throws Exception {
        Scene2D scene2d = this.main.f2D.getScene2d();
        if (f != null) {
            double f_x = 0.0;
            try {
                f_x = f.getValueRound(x, label);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((MathPoint2D)this.pointf2D.get(this.anzPkt)).setCoordinates(x, f_x);
            this.report("", x, f_x);
            double fs_x = 0.0;
            try {
                fs_x = f.getDerivation(x);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tangente(x, f_x, fs_x, scene2d, this.tangentef);
            ((MathPoint2D)this.pointfs2D.get(this.anzPkt)).setCoordinates(x, fs_x);
            double fss_x = 0.0;
            try {
                fss_x = f.getDerivation2(x);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tangente(x, fs_x, fss_x, this.main.fs2D.getScene2d(), this.tangentefs);
            ((MathPoint2D)this.pointfss2D.get(this.anzPkt)).setCoordinates(x, fss_x);
        }
        if (neu && label != null && label != "") {
            ((MathPoint2D)this.pointf2D.get(this.anzPkt)).setColor(Color.blue);
            ((MathPoint2D)this.pointf2D.get(this.anzPkt)).setToolTipText(label);
            ((MathPoint2D)this.pointfs2D.get(this.anzPkt)).setColor(Color.blue);
            ((MathPoint2D)this.pointfs2D.get(this.anzPkt)).setToolTipText(label);
            ((MathPoint2D)this.pointfss2D.get(this.anzPkt)).setColor(Color.blue);
            ((MathPoint2D)this.pointfss2D.get(this.anzPkt)).setToolTipText(label);
            if (caption == null || caption == "") {
                ++this.anzPktCaption;
                String cap = "P";
                if (SingI != null) {
                    cap = "I";
                }
                ((MathPoint2D)this.pointf2D.get(this.anzPkt)).setTitel(String.valueOf(cap) + this.anzPktCaption);
                ((MathPoint2D)this.pointfs2D.get(this.anzPkt)).setTitel(String.valueOf(cap) + this.anzPktCaption);
                ((MathPoint2D)this.pointfss2D.get(this.anzPkt)).setTitel(String.valueOf(cap) + this.anzPktCaption);
            } else {
                ((MathPoint2D)this.pointf2D.get(this.anzPkt)).setTitel(caption);
                ((MathPoint2D)this.pointfs2D.get(this.anzPkt)).setTitel(caption);
                ((MathPoint2D)this.pointfss2D.get(this.anzPkt)).setTitel(caption);
            }
            Object[] s = new String[]{((MathPoint2D)this.pointf2D.get(this.anzPkt)).getTitel(), ((MathPoint2D)this.pointf2D.get(this.anzPkt)).getToolTipText(null)};
            this.command.table.add(s, (MathPoint2D)this.pointf2D.get(this.anzPkt), SingI);
            if (SingI != null) {
                this.pointsReplace((MathPoint2D)this.pointf2D.get(this.anzPkt), (MathPoint2D)this.pointfs2D.get(this.anzPkt), (MathPoint2D)this.pointfss2D.get(this.anzPkt));
            }
            this.newPoint();
        }
    }

    private void pointsReplace(MathPoint2D pf, MathPoint2D pfs, MathPoint2D pfss) {
        MathSquare2D squaref2D = new MathSquare2D();
        squaref2D.setCoordinates(pf.getX(), pf.getY());
        squaref2D.setSize(pf.getRadius());
        squaref2D.setColor(pf.getColor());
        this.main.f2D.delete(pf);
        this.pointf2D.remove(pf);
        this.main.f2D.add(squaref2D);
        this.pointf2D.add(squaref2D);
        MathSquare2D squarefs2D = new MathSquare2D();
        squarefs2D.setCoordinates(pfs.getX(), pfs.getY());
        squarefs2D.setSize(pfs.getRadius());
        squarefs2D.setColor(pfss.getColor());
        this.main.fs2D.delete(pfs);
        this.pointfs2D.remove(pfs);
        this.main.fs2D.add(squarefs2D);
        this.pointfs2D.add(squarefs2D);
        MathSquare2D squarefss2D = new MathSquare2D();
        squarefss2D.setCoordinates(pfss.getX(), pfss.getY());
        squarefss2D.setSize(pfss.getRadius());
        squarefss2D.setColor(pfss.getColor());
        this.main.fss2D.delete(pfss);
        this.pointfss2D.remove(pfss);
        this.main.fss2D.add(squarefss2D);
        this.pointfss2D.add(squarefss2D);
    }

    public void checkNewPoint(double x, String lable, MyFunction f, Interval SingI) throws Exception {
        int anz = this.getPunkte().size() - 1;
        boolean newPoint = true;
        String caption = null;
        int i = 0;
        while (i < anz) {
            double xalt = 0.0;
            String label = null;
            String titel = null;
            if (this.pointf2D.get(i) instanceof MathSquare2D) {
                xalt = ((MathSquare2D)this.pointf2D.get(i)).getX();
                label = ((MathSquare2D)this.pointf2D.get(i)).getToolTipText(null);
                titel = ((MathSquare2D)this.pointf2D.get(i)).getTitel();
            }
            if (this.pointf2D.get(i) instanceof MathPoint2D) {
                xalt = ((MathPoint2D)this.pointf2D.get(i)).getX();
                label = ((MathPoint2D)this.pointf2D.get(i)).getToolTipText(null);
                titel = ((MathPoint2D)this.pointf2D.get(i)).getTitel();
            }
            if (xalt < x + Math.sqrt(1.0E-11) && xalt > x - Math.sqrt(1.0E-11)) {
                if (lable.compareTo(label) == 0) {
                    newPoint = false;
                } else {
                    caption = titel;
                }
            }
            ++i;
        }
        if (newPoint) {
            this.setPunkt(x, true, lable, caption, f, SingI);
            if (SingI == null) {
                this.main.f2D.report(String.valueOf(lable) + ": (x,f(x))=(" + x + " , " + f.getValue(x) + ")");
            }
        } else {
            this.main.f2D.report(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.40"));
        }
    }

    public void addSingIntervall(Vector intervalls, String typ, MyFunction f) throws Exception {
        Interval i = null;
        int j = 0;
        while (j < intervalls.size()) {
            i = (Interval)intervalls.get(j);
            while (j < intervalls.size() - 1) {
                Interval itmp = (Interval)intervalls.get(j + 1);
                if (!(itmp.a <= i.b) || !(itmp.a >= i.a)) break;
                i.b = itmp.b;
                ++j;
            }
            this.checkNewPoint(i.a + (i.b - i.a) / 2.0, typ, f, i);
            ++j;
        }
    }

    public void setFtop() {
        this.main.f2D.delete(this.graphf2D);
        this.main.f2D.add(this.graphf2D);
        this.main.f2D.delete(this.tangentef);
        this.main.f2D.add(this.tangentef);
        this.main.f2D.delete((MathPoint2D)this.pointf2D.get(this.anzPkt));
        this.main.f2D.add((MathPoint2D)this.pointf2D.get(this.anzPkt));
    }

    public void setFstop() {
        this.main.fs2D.delete(this.graphfs2D);
        this.main.fs2D.add(this.graphfs2D);
        this.main.fs2D.delete(this.tangentefs);
        this.main.fs2D.add(this.tangentefs);
        this.main.fs2D.delete((MathPoint2D)this.pointfs2D.get(this.anzPkt));
        this.main.fs2D.add((MathPoint2D)this.pointfs2D.get(this.anzPkt));
    }

    public void setFsstop() {
        this.main.fss2D.delete(this.graphfss2D);
        this.main.fss2D.add(this.graphfss2D);
        this.main.fss2D.delete((MathPoint2D)this.pointfss2D.get(this.anzPkt));
        this.main.fss2D.add((MathPoint2D)this.pointfss2D.get(this.anzPkt));
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent ev) {
            double x = ((InteractionControl)InteractionControl.this).main.f2D.getScene2d().pixelToX(ev.getX());
            Interval i = InteractionControl.this.command.getInterval();
            MyFunction f = InteractionControl.this.command.getFunction();
            if (i != null && i.a < x && i.b > x) {
                try {
                    InteractionControl.this.setPunkt(x, false, null, null, f, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InteractionControl.this.main.graphRepaint();
            }
        }
    }
}

