/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.PrepaintComputable;

public class MathArrow2D
extends Drawable2D
implements PrepaintComputable {
    protected Punkt2D base = new Punkt2D();
    protected Punkt2D head = new Punkt2D();
    protected Point basepix = new Point(0, 0);
    protected Point headpix = new Point(1, 0);
    protected Point leftwingpix = new Point();
    protected Point rightwingpix = new Point();
    Stroke stroke = new BasicStroke();
    protected static final int LENGTHARROWHEAD = 6;
    protected static final int OFFSETWINGS = 3;

    public MathArrow2D(Punkt2D base, Punkt2D head) {
        this.base.setLocation(base);
        this.head.setLocation(head);
    }

    public MathArrow2D() {
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Punkt2D getHead() {
        return this.head;
    }

    public Punkt2D getBase() {
        return this.base;
    }

    public void setBase(Punkt2D base) {
        this.base.setLocation(base);
    }

    public void setHead(Punkt2D head) {
        this.head.setLocation(head);
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        Stroke old = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.setColor(this.color);
        g2.drawLine(this.basepix.x, this.basepix.y, this.headpix.x, this.headpix.y);
        g2.drawLine(this.rightwingpix.x, this.rightwingpix.y, this.headpix.x, this.headpix.y);
        g2.drawLine(this.leftwingpix.x, this.leftwingpix.y, this.headpix.x, this.headpix.y);
        g2.setStroke(old);
    }

    public void prepaintcompute() throws Exception {
        this.draw = false;
        this.basepix = this.scene2d.project(this.base);
        this.headpix = this.scene2d.project(this.head);
        Punkt2D dir = this.head.sub(this.base);
        dir.normalize();
        if (Double.isNaN(dir.x) || Double.isInfinite(dir.x) || Double.isNaN(dir.y) || Double.isInfinite(dir.y) || dir.x == 0.0 && dir.y == 0.0) {
            this.draw = false;
            return;
        }
        double s = Math.max(this.scene2d.getXRange(), this.scene2d.getYRange()) / 10.0;
        dir.scaleself(s);
        Punkt2D zero = this.scene2d.projectdouble(new Punkt2D(0.0, 0.0));
        Punkt2D dirPix = this.scene2d.projectdouble(dir).sub(zero);
        dirPix.normalize();
        if (Double.isNaN(dirPix.x) || Double.isInfinite(dirPix.x) || Double.isNaN(dirPix.y) || Double.isInfinite(dirPix.y) || dirPix.x == 0.0 && dirPix.y == 0.0) {
            this.draw = false;
            return;
        }
        Punkt2D dirnormalPix = new Punkt2D(-dirPix.y, dirPix.x);
        this.leftwingpix.x = (int)((double)this.headpix.x - 6.0 * dirPix.x + 3.0 * dirnormalPix.x);
        this.leftwingpix.y = (int)((double)this.headpix.y - 6.0 * dirPix.y + 3.0 * dirnormalPix.y);
        this.rightwingpix.x = (int)((double)this.headpix.x - 6.0 * dirPix.x - 3.0 * dirnormalPix.x);
        this.rightwingpix.y = (int)((double)this.headpix.y - 6.0 * dirPix.y - 3.0 * dirnormalPix.y);
        this.draw = true;
    }
}

