/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.pendulum;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;
import uibk.applets.pendulum.AppletPendulum;
import uibk.applets.pendulum.InteractionControl;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.Label;
import uibk.mtk.swing.base.MPanel;

public class PanelFeder
extends MPanel {
    private InteractionControl control;
    private final AppletPendulum main;
    protected DoubleTextField textFederK;
    protected DoubleTextField textFederPos;
    protected double federK = 0.0;
    protected double federPos = 0.0;

    public PanelFeder(AppletPendulum main, InteractionControl control) {
        this.main = main;
        this.control = control;
        this.initComponents();
    }

    private MPanel createPanelDef() {
        MPanel panelDefPendel = new MPanel();
        panelDefPendel.setLayout(new GridBagLayout());
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.0"));
        panelDefPendel.setBorder(b);
        panelDefPendel.setMaximumSize(new Dimension(1000, 190));
        Label labelLaenge = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.10"));
        labelLaenge.setPreferredSize(new Dimension(120, 20));
        this.textFederK = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.20"));
        this.textFederK.setText("-1");
        this.textFederK.setActionCommand("laenge");
        this.textFederK.addActionListener(this.control);
        this.textFederK.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.21"));
        Label labelPos = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.11"));
        labelPos.setPreferredSize(new Dimension(120, 20));
        this.textFederPos = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.22"));
        this.textFederPos.setText("-1");
        this.textFederPos.setActionCommand("laenge");
        this.textFederPos.addActionListener(this.control);
        this.textFederPos.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.23"));
        panelDefPendel.add((Component)labelLaenge, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textFederK, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)labelPos, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textFederPos, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        return panelDefPendel;
    }

    void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelDef());
        this.add(Box.createVerticalGlue());
    }

    void leseDaten() throws InputException {
        if (!this.getFederK()) {
            throw new InputException();
        }
        if (!this.getFederPos()) {
            throw new InputException();
        }
    }

    private boolean getFederK() {
        try {
            String strfunc = this.textFederK.getText();
            this.federK = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.20"), null, null, Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }

    private boolean getFederPos() {
        try {
            String strfunc = this.textFederPos.getText();
            this.federPos = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelFeder.22"), null, null, Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }
}

