/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.pendulum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.pendulum.AppletPendulum;
import uibk.applets.pendulum.PanelSkale;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.RepaintThread;
import uibk.mtk.swing.base.CheckBox;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.RadioButton;

public class PanelDiagramm
implements ActionListener {
    private RepaintThread repaintThread;
    private final AppletPendulum main;
    private int konfig = 1;
    private MathPanel2D mathPanel2D = new MathPanel2D();
    private Axes2D axes = new Axes2D();
    private Graph2D[] graph = null;
    private MPanel panelGraph;
    private CheckBox zoom;
    private RadioButton x_y;
    private RadioButton phi_v;
    private RadioButton phi_a;
    private RadioButton v_a;
    private RadioButton phi_t;
    private RadioButton v_t;
    private RadioButton a_t;
    private boolean X_Y = true;
    private boolean PHI_V = false;
    private boolean PHI_A = false;
    private boolean V_A = false;
    private boolean PHI_T = false;
    private boolean V_T = false;
    private boolean A_T = false;
    private JSlider slider;
    private PanelSkale panelSkale;
    private static final int INTERVALL = 60;

    public PanelDiagramm(AppletPendulum main) {
        this.main = main;
        this.repaintThread = new RepaintThread(this.mathPanel2D);
        this.panelSkale = new PanelSkale(main, this.mathPanel2D);
    }

    public MPanel addPanelDiagramm() {
        this.panelGraph = new MPanel();
        this.panelGraph.setLayout(new BorderLayout());
        this.panelGraph.setBorder(BorderFactory.createLineBorder(Color.black));
        this.axes.setVisible(false);
        this.axes.setMathPanel2D(this.mathPanel2D);
        this.mathPanel2D.add(this.axes);
        this.mathPanel2D.getScene2d().enableRoundX(false);
        this.mathPanel2D.getScene2d().enableRoundY(false);
        this.mathPanel2D.setDoubleBuffered(false);
        this.panelGraph.add((Component)this.createPanelDarstellung(), "North");
        this.panelGraph.add((Component)this.mathPanel2D, "Center");
        this.panelGraph.add((Component)this.createPanelOption(), "South");
        return this.panelGraph;
    }

    public void addPunkt(double t, double phi, double x, double y, double v, double a, int i) {
        if (this.graph != null && this.graph.length > i) {
            if (this.X_Y) {
                this.graph[i].addPoint(new Punkt2D(x, y));
            } else if (this.PHI_V) {
                this.graph[i].addPoint(new Punkt2D(phi, v));
            } else if (this.PHI_A) {
                this.graph[i].addPoint(new Punkt2D(phi, a));
            } else if (this.V_A) {
                this.graph[i].addPoint(new Punkt2D(v, a));
            } else if (this.PHI_T || this.V_T || this.A_T) {
                Punkt2D p = new Punkt2D(t, 0.0);
                this.mathPanel2D.requestRecompute(true);
                if (this.PHI_T) {
                    p.y = phi;
                }
                if (this.V_T) {
                    p.y = v;
                }
                if (this.A_T) {
                    p.y = a;
                }
                this.graph[i].addPoint(p);
                if (this.graph[i].getFirstPoint() != null) {
                    if (t - this.graph[i].getFirstPoint().x > 60.0) {
                        while (t - 60.0 > this.graph[i].getFirstPoint().x) {
                            this.graph[i].clearFirstPoint();
                        }
                        this.mathPanel2D.getScene2d().setLimits(this.graph[i].getFirstPoint().x, t, this.panelSkale.yMin, this.panelSkale.yMax);
                    } else {
                        this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, this.panelSkale.yMin, this.panelSkale.yMax);
                    }
                }
            }
        }
    }

    public void neu(int anz, int konfig) {
        int i;
        this.axes.setVisible(true);
        this.konfig = konfig;
        this.repaintThread = new RepaintThread(this.mathPanel2D);
        if (this.graph != null) {
            i = 0;
            while (i < this.graph.length) {
                this.mathPanel2D.delete(this.graph[i]);
                ++i;
            }
        }
        this.graph = new Graph2D[anz];
        i = 0;
        while (i < anz) {
            this.graph[i] = new Graph2D();
            this.graph[i].clearpoints();
            this.graph[i].setVisible(true);
            this.graph[i].setColor(this.main.FARBE[i]);
            this.mathPanel2D.add(this.graph[i]);
            this.repaintThread.addGraph(this.graph[i]);
            ++i;
        }
        this.panelSkale.setGraph(this.graph);
        this.slider.setEnabled(true);
        int n = this.slider.getValue();
        this.main.pendel.setAufloesung((double)n / 100.0);
        this.mathPanel2D.repaint();
        if (this.X_Y) {
            this.x_y();
        }
        if (this.PHI_V) {
            this.phi_v();
        }
        if (this.PHI_A) {
            this.phi_a();
        }
        if (this.V_A) {
            this.v_a();
        }
        if (this.PHI_T) {
            this.phi_t();
        }
        if (this.V_T) {
            this.v_t();
        }
        if (this.A_T) {
            this.a_t();
        }
    }

    private MPanel createPanelDarstellung() {
        MPanel panelDarstel = new MPanel();
        panelDarstel.setLayout(new BorderLayout());
        panelDarstel.setMaximumSize(new Dimension(1000, 190));
        panelDarstel.add((Component)this.createPanelZoom(), "North");
        panelDarstel.add((Component)this.createPanelArt(), "South");
        return panelDarstel;
    }

    private MPanel createPanelArt() {
        MPanel panelDarstel = new MPanel();
        panelDarstel.setLayout(new GridLayout(2, 4, 5, 5));
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.29"));
        panelDarstel.setBorder(b);
        panelDarstel.setMaximumSize(new Dimension(1000, 190));
        this.x_y = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.30"));
        this.x_y.setSelected(true);
        this.x_y.setActionCommand("x_y");
        this.x_y.addActionListener(this);
        this.phi_v = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.31"));
        this.phi_v.setSelected(false);
        this.phi_v.setActionCommand("phi_v");
        this.phi_v.addActionListener(this);
        this.phi_a = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.32"));
        this.phi_a.setSelected(false);
        this.phi_a.setActionCommand("phi_a");
        this.phi_a.addActionListener(this);
        this.v_a = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.33"));
        this.v_a.setSelected(false);
        this.v_a.setActionCommand("v_a");
        this.v_a.addActionListener(this);
        this.phi_t = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.34"));
        this.phi_t.setSelected(false);
        this.phi_t.setActionCommand("phi_t");
        this.phi_t.addActionListener(this);
        this.v_t = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.35"));
        this.v_t.setSelected(false);
        this.v_t.setActionCommand("v_t");
        this.v_t.addActionListener(this);
        this.a_t = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.36"));
        this.a_t.setSelected(false);
        this.a_t.setActionCommand("a_t");
        this.a_t.addActionListener(this);
        panelDarstel.add(this.x_y);
        panelDarstel.add(this.phi_v);
        panelDarstel.add(this.phi_a);
        panelDarstel.add(this.v_a);
        panelDarstel.add(this.phi_t);
        panelDarstel.add(this.v_t);
        panelDarstel.add(this.a_t);
        return panelDarstel;
    }

    private MPanel createPanelZoom() {
        MPanel panelDarstel = new MPanel();
        panelDarstel.setLayout(new GridBagLayout());
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.41"));
        panelDarstel.setBorder(b);
        this.zoom = new CheckBox(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.0"));
        this.zoom.setSelected(false);
        this.zoom.setActionCommand("zoom");
        this.zoom.addActionListener(this);
        this.zoom.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.41"));
        panelDarstel.add((Component)this.zoom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panelDarstel;
    }

    private MPanel createPanelOption() {
        MPanel panelOption = new MPanel();
        panelOption.setLayout(new BorderLayout());
        this.panelSkale.setEnabledXY(false);
        panelOption.add((Component)this.createPanelAufloes(), "North");
        panelOption.add((Component)this.panelSkale, "South");
        return panelOption;
    }

    private MPanel createPanelAufloes() {
        MPanel panelButtons = new MPanel();
        panelButtons.setLayout(new GridLayout(0, 1, 30, 5));
        panelButtons.setMaximumSize(new Dimension(2000, 100));
        panelButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        this.slider = new JSlider();
        this.slider.setMinimum(1);
        this.slider.setValue(1);
        this.slider.setMaximum(20);
        this.slider.setEnabled(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                if (((PanelDiagramm)PanelDiagramm.this).main.pendel != null) {
                    ((PanelDiagramm)PanelDiagramm.this).main.pendel.setAufloesung((double)n / 100.0);
                }
            }
        });
        JLabel label = new JLabel(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.11"));
        panelButtons.add(label);
        panelButtons.add(this.slider);
        return panelButtons;
    }

    private void zoom() {
        this.main.mathpanel2D.setVisible(false);
        int w = this.main.mathpanel2D.getWidth();
        int h = this.main.mathpanel2D.getHeight();
        Point p = this.main.mathpanel2D.getLocation();
        this.mathPanel2D.setLocation(p);
        if (this.zoom.isSelected()) {
            this.main.setMainPanel(this.mathPanel2D);
            this.panelGraph.add(this.main.mathpanel2D);
        } else {
            this.main.setMainPanel(this.main.mathpanel2D);
            this.panelGraph.add(this.mathPanel2D);
        }
        this.mathPanel2D.setSize(new Dimension(w, h));
        this.main.mathpanel2D.setVisible(true);
        this.mathPanel2D.requestRecompute(true);
        this.panelSkale.copyCoordinates();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("zoom")) {
            this.zoom();
            this.main.mathpanel2D.report(Messages.getString("uibk.applets.pendulum.messages", "PanelDiagramm.40"));
        }
        if (ev.getActionCommand().equals("x_y")) {
            this.x_y();
        }
        if (ev.getActionCommand().equals("phi_v")) {
            this.phi_v();
        }
        if (ev.getActionCommand().equals("phi_a")) {
            this.phi_a();
        }
        if (ev.getActionCommand().equals("v_a")) {
            this.v_a();
        }
        if (ev.getActionCommand().equals("phi_t")) {
            this.phi_t();
        }
        if (ev.getActionCommand().equals("v_t")) {
            this.v_t();
        }
        if (ev.getActionCommand().equals("a_t")) {
            this.a_t();
        }
        this.x_y.setSelected(this.X_Y);
        this.phi_v.setSelected(this.PHI_V);
        this.phi_a.setSelected(this.PHI_A);
        this.v_a.setSelected(this.V_A);
        this.phi_t.setSelected(this.PHI_T);
        this.v_t.setSelected(this.V_T);
        this.a_t.setSelected(this.A_T);
        this.panelSkale.copyCoordinates();
    }

    public void clear() {
        if (this.graph != null) {
            int i = 0;
            while (i < this.graph.length) {
                this.graph[i].clearpoints();
                ++i;
            }
        }
        this.mathPanel2D.requestRecompute(true);
    }

    private void x_y() {
        this.X_Y = true;
        this.PHI_V = false;
        this.PHI_A = false;
        this.V_A = false;
        this.PHI_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("x(t)");
        this.axes.setCaptionYAxis("y(t)");
        double rand = this.main.panelPendel[0].laenge / 10.0;
        double min = -this.main.panelPendel[0].laenge - rand;
        double max = this.main.panelPendel[0].laenge + rand;
        this.mathPanel2D.getScene2d().setLimits(min, max, min, max);
        if (this.konfig == 2) {
            this.mathPanel2D.getScene2d().setLimits(min -= this.main.panelPendel[1].laenge, max += this.main.panelPendel[1].laenge, min, max);
        }
        if (this.konfig == 3) {
            double xmin = -2.0 * this.main.panelPendel[0].laenge - rand;
            double xmax = 2.0 * this.main.panelPendel[0].laenge + rand;
            double ymin = -this.main.panelPendel[0].laenge;
            this.mathPanel2D.getScene2d().setLimits(xmin, xmax, ymin, rand);
        }
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.mathPanel2D.repaint();
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    private void phi_v() {
        this.X_Y = false;
        this.PHI_V = true;
        this.PHI_A = false;
        this.V_A = false;
        this.PHI_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("\u03c6(t)");
        this.axes.setCaptionYAxis("\u03c6'(t)");
        this.mathPanel2D.getScene2d().axesequal(true);
        this.mathPanel2D.getScene2d().setLimits(Math.PI * -2, Math.PI * 2, Math.PI * -2, Math.PI * 2);
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.mathPanel2D.repaint();
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    private void phi_a() {
        this.X_Y = false;
        this.PHI_V = false;
        this.PHI_A = true;
        this.V_A = false;
        this.PHI_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("\u03c6(t)");
        this.axes.setCaptionYAxis("\u03c6''(t)");
        this.mathPanel2D.getScene2d().axesequal(true);
        this.mathPanel2D.getScene2d().setLimits(Math.PI * -2, Math.PI * 2, Math.PI * -2, Math.PI * 2);
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.mathPanel2D.repaint();
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    private void v_a() {
        this.X_Y = false;
        this.PHI_V = false;
        this.PHI_A = false;
        this.V_A = true;
        this.PHI_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("\u03c6'(t)");
        this.axes.setCaptionYAxis("\u03c6''(t)");
        this.mathPanel2D.getScene2d().axesequal(true);
        this.mathPanel2D.getScene2d().setLimits(Math.PI * -2, Math.PI * 2, Math.PI * -2, Math.PI * 2);
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.mathPanel2D.repaint();
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    private void phi_t() {
        this.X_Y = false;
        this.PHI_V = false;
        this.PHI_A = false;
        this.V_A = false;
        this.PHI_T = true;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("t");
        this.axes.setCaptionYAxis("\u03c6(t)");
        this.mathPanel2D.getScene2d().axesequal(false);
        if (this.graph != null && this.graph[0] != null && this.graph[0].getLastPoint() != null) {
            double t = this.graph[0].getLastPoint().x;
            this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, Math.PI * -2, Math.PI * 2);
        } else {
            this.mathPanel2D.getScene2d().setLimits(0.0, 80.0, Math.PI * -2, Math.PI * 2);
        }
        this.clear();
        this.panelSkale.setEnabledXY(false);
        this.mathPanel2D.repaint();
        this.mathPanel2D.requestRecompute(true);
    }

    private void v_t() {
        this.X_Y = false;
        this.PHI_V = false;
        this.PHI_A = false;
        this.V_A = false;
        this.PHI_T = false;
        this.V_T = true;
        this.A_T = false;
        this.axes.setCaptionXAxis("t");
        this.axes.setCaptionYAxis("\u03c6'(t)");
        this.mathPanel2D.getScene2d().axesequal(false);
        if (this.graph != null && this.graph[0] != null && this.graph[0].getLastPoint() != null) {
            double t = this.graph[0].getLastPoint().x;
            this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, Math.PI * -2, Math.PI * 2);
        } else {
            this.mathPanel2D.getScene2d().setLimits(0.0, 80.0, Math.PI * -2, Math.PI * 2);
        }
        this.clear();
        this.panelSkale.setEnabledXY(false);
        this.mathPanel2D.repaint();
        this.mathPanel2D.requestRecompute(true);
    }

    private void a_t() {
        this.X_Y = false;
        this.PHI_V = false;
        this.PHI_A = false;
        this.V_A = false;
        this.PHI_T = false;
        this.V_T = false;
        this.A_T = true;
        this.axes.setCaptionXAxis("t");
        this.axes.setCaptionYAxis("\u03c6''(t)");
        this.mathPanel2D.getScene2d().axesequal(false);
        if (this.graph != null && this.graph[0] != null && this.graph[0].getLastPoint() != null) {
            double t = this.graph[0].getLastPoint().x;
            this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, Math.PI * -2, Math.PI * 2);
        } else {
            this.mathPanel2D.getScene2d().setLimits(0.0, 80.0, Math.PI * -2, Math.PI * 2);
        }
        this.clear();
        this.panelSkale.setEnabledXY(false);
        this.mathPanel2D.repaint();
        this.mathPanel2D.requestRecompute();
    }

    public void start() {
        this.repaintThread.start();
        this.mathPanel2D.setAutoRepaint(false);
        this.mathPanel2D.requestRecompute(true);
    }

    public void stop() {
        this.repaintThread.stop();
        while (!this.repaintThread.isStop()) {
            this.repaintThread.stop();
        }
        this.mathPanel2D.setAutoRepaint(true);
    }

    public void setDelay(int delay) {
        this.repaintThread.setDelay(delay);
    }
}

