/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.pendulum;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import uibk.applets.pendulum.AppletPendulum;
import uibk.applets.pendulum.Pendel;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.ODEParser;

public class InteractionControl
implements ActionListener {
    private AppletPendulum main;
    private boolean neuStart = true;
    private int konfig = 1;
    private int anzPendel = 1;
    public static final int _1PENDEL = 1;
    public static final int _2PENDELSER = 2;
    public static final int _2PENDELPAR = 3;

    public InteractionControl(AppletPendulum main) {
        this.main = main;
    }

    private boolean setFunction(String[] f, char[] v) {
        try {
            ParsedFunction fu = ODEParser.parse(f, v, true);
            this.main.odeSolver.setDGL(fu);
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
        return true;
    }

    public void start() {
        this.main.mathpanel2D.report(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.2"));
        this.main.pendel.start();
        this.main.diagramm.start();
        this.neuStart = false;
    }

    public void stop() {
        this.main.pendel.stop();
        this.main.diagramm.stop();
        this.main.mathpanel2D.report(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.3"));
    }

    private void neu() {
        this.main.diagramm.stop();
        this.neuStart = true;
        this.main.pendel = new Pendel(this.main, this, this.konfig);
        this.main.pendel.anzPendel = this.anzPendel;
        int i = 0;
        while (i < this.anzPendel) {
            try {
                this.main.panelPendel[i].leseDaten();
            }
            catch (Exception e) {
                return;
            }
            ++i;
        }
        try {
            this.main.panelMain.leseDaten();
        }
        catch (Exception e) {
            return;
        }
        this.main.basis[0].setVisible(true);
        i = 0;
        while (i < this.anzPendel) {
            this.main.masse[i].setVisible(true);
            this.main.schnur[i].setVisible(true);
            this.main.basis[i].setVisible(true);
            this.main.basis[i].setCoordinates(0.0, 0.0);
            ++i;
        }
        i = this.anzPendel;
        while (i < 2) {
            this.main.masse[i].setVisible(false);
            this.main.schnur[i].setVisible(false);
            this.main.basis[i].setVisible(false);
            this.main.beschlV[i].setVisible(false);
            this.main.geschwV[i].setVisible(false);
            ++i;
        }
        this.main.feder.setVisible(false);
        switch (this.konfig) {
            case 1: {
                this.def1Pendel();
                break;
            }
            case 2: {
                this.def2PendelSer();
                break;
            }
            case 3: {
                try {
                    this.main.panelFeder.leseDaten();
                }
                catch (Exception e) {
                    return;
                }
                if (this.main.panelFeder.federPos > this.main.panelPendel[0].laenge || this.main.panelFeder.federPos > this.main.panelPendel[1].laenge) {
                    this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.10"));
                    i = 0;
                    while (i < 2) {
                        this.main.masse[i].setVisible(false);
                        this.main.schnur[i].setVisible(false);
                        this.main.basis[i].setVisible(false);
                        this.main.beschlV[i].setVisible(false);
                        this.main.geschwV[i].setVisible(false);
                        this.main.mathpanel2D.repaint();
                        ++i;
                    }
                    return;
                }
                this.def2PendelPar();
            }
        }
        this.geschw();
        this.beschl();
        this.main.diagramm.neu(this.anzPendel, this.konfig);
        this.main.pendel.start();
        this.main.pendel.stop();
        while (!this.main.pendel.isStop()) {
        }
        this.main.mathpanel2D.report(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.4"));
        this.neuStart = false;
    }

    private void def1Pendel() {
        String g = Double.toString(this.main.panelMain.fallBeschleun);
        String l = Double.toString(this.main.panelPendel[0].laenge);
        String d = Double.toString(this.main.panelMain.daempfung);
        String[] funk = new String[]{new String("y"), new String("-(" + g + "/" + l + "*sin(x))-" + d + "*y*abs(y)")};
        char[] v = new char[]{'x', 'y'};
        if (!this.setFunction(funk, v)) {
            return;
        }
        this.main.pendel.position = new double[2];
        this.main.pendel.position[0] = this.main.panelPendel[0].amplitude * Math.PI;
        this.main.pendel.position[1] = this.main.panelPendel[0].geschw;
        Scene2D scene2d = this.main.mathpanel2D.getScene2d();
        double rand = this.main.panelPendel[0].laenge / 10.0;
        double min = -this.main.panelPendel[0].laenge - rand;
        double max = this.main.panelPendel[0].laenge + rand;
        scene2d.setLimits(min, max, min, max);
    }

    private void def2PendelSer() {
        String g = Double.toString(this.main.panelMain.fallBeschleun);
        String l1 = Double.toString(this.main.panelPendel[0].laenge);
        String l2 = Double.toString(this.main.panelPendel[1].laenge);
        String m1 = Double.toString(this.main.panelPendel[0].masse);
        String m2 = Double.toString(this.main.panelPendel[1].masse);
        String d = Double.toString(this.main.panelMain.daempfung);
        String[] funk = new String[]{new String("z"), new String("w"), new String("-(-" + g + "*sin(x)*" + m2 + "-" + m2 + "*" + l2 + "*w^2*sin(x-y)-" + g + "*sin(x)*" + m1 + "-" + m2 + "*cos(x-y)*" + l1 + "*z^2*sin(x-y)+" + m2 + "*cos(x-y)*" + g + "*sin(y))/" + l1 + "/(-" + m1 + "-" + m2 + "+" + m2 + "*cos(x-y)^2)-" + d + "*z*abs(z)"), new String("-(cos(x-y)*" + g + "*sin(x)*" + m2 + "+cos(x-y)*" + m2 + "*" + l2 + "*w^2*sin(x-y)+cos(x-y)*" + g + "*sin(x)*" + m1 + "+" + l1 + "*z^2*sin(x-y)*" + m1 + "+" + m2 + "*" + l1 + "*z^2*sin(x-y)-" + g + "*sin(y)*" + m1 + "-" + m2 + "*" + g + "*sin(y))/" + l2 + "/(-" + m1 + "-" + m2 + "+" + m2 + "*cos(x-y)^2)-" + d + "*w*abs(w)")};
        char[] v = new char[]{'x', 'y', 'z', 'w'};
        if (!this.setFunction(funk, v)) {
            return;
        }
        this.main.pendel.position = new double[4];
        this.main.pendel.position[0] = this.main.panelPendel[0].amplitude * Math.PI;
        this.main.pendel.position[1] = this.main.panelPendel[1].amplitude * Math.PI;
        this.main.pendel.position[2] = this.main.panelPendel[0].geschw;
        this.main.pendel.position[3] = this.main.panelPendel[1].geschw;
        Scene2D scene2d = this.main.mathpanel2D.getScene2d();
        double rand = this.main.panelPendel[0].laenge / 10.0;
        double min = -this.main.panelPendel[0].laenge - this.main.panelPendel[1].laenge - rand;
        double max = this.main.panelPendel[0].laenge + this.main.panelPendel[1].laenge + rand;
        scene2d.setLimits(min, max, min, max);
    }

    private void def2PendelPar() {
        this.main.feder.setVisible(true);
        String g = Double.toString(this.main.panelMain.fallBeschleun);
        String l1 = Double.toString(this.main.panelPendel[0].laenge);
        String l2 = Double.toString(this.main.panelPendel[1].laenge);
        String m1 = Double.toString(this.main.panelPendel[0].masse);
        String m2 = Double.toString(this.main.panelPendel[1].masse);
        String d = Double.toString(this.main.panelMain.daempfung);
        String k = Double.toString(this.main.panelFeder.federK);
        String r = Double.toString(this.main.panelFeder.federPos);
        String[] funk = new String[]{new String("z"), new String("w"), new String("-" + g + "/" + l1 + "*sin(x)-" + k + "/" + m1 + "*" + r + "^2/" + l1 + "^2*sin(-y+x)-" + d + "*z*abs(z)"), new String("-" + g + "/" + l2 + "*sin(y)+" + k + "/" + m2 + "*" + r + "^2/" + l2 + "^2*sin(-y+x)-" + d + "*w*abs(w)")};
        char[] v = new char[]{'x', 'y', 'z', 'w'};
        if (!this.setFunction(funk, v)) {
            return;
        }
        this.main.pendel.position = new double[4];
        this.main.pendel.position[0] = this.main.panelPendel[0].amplitude * Math.PI;
        this.main.pendel.position[1] = this.main.panelPendel[1].amplitude * Math.PI;
        this.main.pendel.position[2] = this.main.panelPendel[0].geschw;
        this.main.pendel.position[3] = this.main.panelPendel[1].geschw;
        Scene2D scene2d = this.main.mathpanel2D.getScene2d();
        double rand = this.main.panelPendel[0].laenge / 10.0;
        double xmin = -2.0 * this.main.panelPendel[0].laenge - rand;
        double xmax = 2.0 * this.main.panelPendel[1].laenge + rand;
        double ymin = this.main.panelPendel[0].laenge > this.main.panelPendel[0].laenge ? -this.main.panelPendel[0].laenge : -this.main.panelPendel[1].laenge;
        scene2d.setLimits(xmin, xmax, ymin, rand);
        this.main.basis[0].setX(-this.main.panelPendel[0].laenge);
        this.main.basis[1].setX(this.main.panelPendel[1].laenge);
        this.main.pendel.start();
        this.main.pendel.stop();
        while (!this.main.pendel.isStop()) {
        }
        double r1 = 1.5 * (double)this.main.masse[0].getRadius() * this.main.mathpanel2D.getScene2d().getXPixelScale();
        double r2 = (1.5 * (double)this.main.masse[1].getRadius() + 10.0) * this.main.mathpanel2D.getScene2d().getXPixelScale();
        scene2d.setLimits(xmin -= r1, xmax += r2, ymin, rand);
        this.main.basis[0].setX(-this.main.panelPendel[0].laenge - r1);
        this.main.basis[1].setX(this.main.panelPendel[1].laenge + r2);
    }

    private void geschw() {
        if (this.main.panelMain.geschw.isSelected()) {
            int i = 0;
            while (i < this.anzPendel) {
                this.main.geschwV[i].setVisible(true);
                ++i;
            }
            i = this.anzPendel;
            while (i < 2) {
                this.main.geschwV[i].setVisible(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 2) {
                this.main.geschwV[i].setVisible(false);
                ++i;
            }
        }
    }

    private void beschl() {
        if (this.main.panelMain.beschl.isSelected()) {
            int i = 0;
            while (i < this.anzPendel) {
                this.main.beschlV[i].setVisible(true);
                ++i;
            }
            i = this.anzPendel;
            while (i < 2) {
                this.main.beschlV[i].setVisible(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 2) {
                this.main.beschlV[i].setVisible(false);
                ++i;
            }
        }
    }

    protected void _1Pendel() {
        this.main.panelMain._1Pendel.setSelected(true);
        this.main.panelMain._2Pendel.setSelected(false);
        this.main.panelPendel[1].setEnabled(false);
        this.main.panelFeder.setEnabled(false);
        this.main.panelMain.seriell.setEnabled(false);
        this.main.panelMain.parallel.setEnabled(false);
        this.anzPendel = 1;
        this.konfig = 1;
    }

    protected void _2Pendel() {
        this.main.panelMain._2Pendel.setSelected(true);
        this.main.panelMain._1Pendel.setSelected(false);
        this.main.panelPendel[1].setEnabled(true);
        this.main.panelMain.seriell.setEnabled(true);
        this.main.panelMain.parallel.setEnabled(true);
        if (this.main.panelMain.parallel.isSelected()) {
            this.parallel();
        }
        if (this.main.panelMain.seriell.isSelected()) {
            this.seriell();
        }
        this.anzPendel = 2;
    }

    protected void seriell() {
        this.main.panelMain.seriell.setSelected(true);
        this.main.panelMain.parallel.setSelected(false);
        this.main.panelFeder.setEnabled(false);
        this.main.panelPendel[1].textLaenge.setEnabled(true);
        this.konfig = 2;
    }

    public void parallel() {
        this.main.panelMain.parallel.setSelected(true);
        this.main.panelMain.seriell.setSelected(false);
        this.main.panelFeder.setEnabled(true);
        this.konfig = 3;
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("start")) {
            if (this.neuStart) {
                this.neu();
            }
            if (!this.neuStart) {
                this.start();
            }
        }
        if (ev.getActionCommand().equals("stop") && !this.neuStart) {
            this.stop();
        }
        if (ev.getActionCommand().equals("neu")) {
            if (!this.neuStart) {
                this.main.pendel.stop();
                while (!this.main.pendel.isStop()) {
                    this.main.pendel.stop();
                }
            }
            this.neu();
        }
        if (ev.getActionCommand().equals("geschw")) {
            this.geschw();
        }
        if (ev.getActionCommand().equals("beschl")) {
            this.beschl();
        }
        if (ev.getActionCommand().equals("_1Pendel")) {
            this._1Pendel();
        }
        if (ev.getActionCommand().equals("_2Pendel")) {
            this._2Pendel();
        }
        if (ev.getActionCommand().equals("seriell")) {
            this.seriell();
        }
        if (ev.getActionCommand().equals("parallel")) {
            this.parallel();
        }
    }
}

