%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010         
%  R. Sitzenfrei, M. Mderl 
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function GenM=twoDim_branched(Vertical,Horizontal)

mdstypes

[BDR_loop BDR_branched C C0 C1 C2 C3]=getHelpModules();





% helpmodule M0
M0=mds(3,3);
M0(1,1) =  C0;
M0(2,2) =  C1;
M0(2,1) =  C2;
M0(1,2) =  C3;

% helpmodule M1
%
%   J-J-J
%   |   |  
%   J J J 
%     |     
%   J-J-J
%     |    
%   J J J 
%   |   | 
%   J-J-J
M1=mds(5,3);
M1(1,1)=M0;
M1(3,1)=rotate(M0,2);

%
MDS=mds(Vertical*(size(BDR_branched,1)-1)+1,Horizontal*(size(BDR_branched,2)-1)+1);



for j=1:(size(BDR_branched,1)-1):((size(BDR_branched,1)-1)*(Horizontal))
    MDS(1,j)=rotate(BDR_branched,3);
    for i=1:(size(BDR_branched,2)-1):((size(BDR_branched,2)-1)*(Vertical))
        MDS(i+2,j)=rotate(M1,1);
        MDS(i,j)=rotate(M1,1);
    end
end



X = 500*(0:1:size(MDS,2)-1);
Y = 500*(size(MDS,1)-1:-1:0);
[X,Y] = meshgrid(X,Y);



MDS.nodes.x = X;
MDS.nodes.y = Y;

GenM=MDS;

