%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010         
%  R. Sitzenfrei, M. Mderl 
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function GenM=twoDim(Vertical,Horizontal,layoutStructure,basicDemand)
mdstypes


if nargin<4
    basicDemand=1;
elseif nargin<3
    layoutStructure='loop';
end


if strcmp(layoutStructure,'branch')
    GenM=twoDim_branched(Vertical,Horizontal);
else
    GenM=twoDim_looped(Vertical,Horizontal);
end


% demand variation between 75% and 125%
variation =0.75 +  0.5*rand(size(GenM,1),size(GenM,2));
for i=1:size(GenM,1)
    for j=1:size(GenM,2)
        GenM.junctions.demand(i,j) =basicDemand*variation(i,j);
    end
end