%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010
%  R. Sitzenfrei, M. Mderl
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% script to generate 2280 water supply systems with MDS
%
% start this script in the folder in which the generated MDS should be
% saved. Make sure that one folder above there are the folders 'mds'and
% 'mfigures_download' available
clear all;clc;
cd_old=cd;
cd('..')
projectPath=cd;
cd(cd_old);

addpath([projectPath '\mds']);
addpath([projectPath '\mfigures_download']);


% make EPANET input files
makeEPANETinp=false;
% make emf pictures of each WSS
makePICfile=true;
% save the entire set as MATLAB-file
saveSet=true;

%% initialize parameters

R0=getReservoir(0);
R1=getReservoir(1);
R2=getReservoir(2);
qV=[0.1 1 5];
pipeLength=500;

WSS_Set_2280=[];
WSS_Set_2280_prop=[];
cprop=[];
iwss=1;

%% one-dimensional expansion
% 3 demand distributions (de) x
% 60 spatial variations (di) x
% 4 source variations (so) x
% 2 layout structures (ne) =
% 1440 scenarios


% index for demand variation
for iqV=1:3
    % index for layout structure variation
    % netztyp==1: loop; netztyp==2: branch
    for netztyp=1:2
        % index for spatial variation
        for i=1:60
            t=[];
            % intitialize empty MDS with according size
            t=mds(4*i+3+2,9);
            X = pipeLength*(0:1:size(t,2)-1);
            Y = pipeLength*(size(t,1)-1:-1:0);
            [X,Y] = meshgrid(X,Y);
            t.nodes.x=X;
            t.nodes.y=Y;
            t(1,5)=rotate(R2,0); %uppersource
            for q=1:4 % index of source variation
                tic
                if q==2 % lower source
                    t(size(t.graph,1)-2,5)=rotate(R2,2);
                    t(size(t.graph,1)-6,3)=rotate(twoDim(1,1,'branch',qV(iqV)),2);
                end
                if q==3 % left source
                    t((size(t.graph,1)+1)/2,1)=rotate(R2,1);
                end
                if q==4 % right source
                    t((size(t.graph,1)+1)/2,7)=rotate(R2,3);
                end
                
                if netztyp==1 %loop network sturcture
                    t(3,3)=twoDim(i,1,'loop',qV(iqV));
                end
                if netztyp==2 %branch network sturcture
                    t(3,3)=twoDim(i,1,'branch',qV(iqV));
                end
                t.pipes.roughness = 1.5;
                
                WDS.MDS=t;
                % export block
                if makeEPANETinp
                    mdsName=['id' num2str(iwss) '.inp'];
                    printmds2(WDS.MDS,mdsName,'options.inp');
                end
                if makePICfile
                    figure
                    set(gcf,'visible','off')
                    plotmds(t)
                    print('-dmeta',['id' num2str(iwss)])
                    close all
                end
                
                WSS_Set_2280{iwss}=WDS.MDS;
                
                % save current properties
                cprop=[];
                cprop.variation='1dV';
                cprop.ne=netztyp;
                cprop.so=q;
                cprop.de=qV(iqV);
                cprop.di=i;
                WSS_Set_2280_prop{iwss}=cprop;
                tt=toc;
                ['run' num2str(iwss) ' ' num2str(tt) ]
                iwss=iwss+1;
            end
        end
    end
end



%% two-dimensional expansion
% 3 demand distributions (de) x
% 11 spatial variations (di) x
% 4 source variations (so) x
% 2 layout structures (ne) =
% 264 scenarios
iwss=1441; % continuing from one-dimensional expansion

% index for demand variation
for iqV=1:3
    % index for layout structure variation
    % netztyp==1: loop; netztyp==2: branch
    for netztyp=1:2
        % index for spatial variation
        for i=1:11
            t=[];
            % intitialize empty MDS with according size
            t=mds(4*i+3+2,4*i+3+2);
            X = pipeLength*(0:1:size(t,2)-1);
            Y = pipeLength*(size(t,1)-1:-1:0);
            [X,Y] = meshgrid(X,Y);
            t.nodes.x=X;
            t.nodes.y=Y;
            t(1,(size(t.graph,2)+1)/2)=rotate(R2,0);
            for q=1:4
                tic
                if q==2 % lower source
                    t(size(t.graph,1)-2,(size(t.graph,2)+1)/2)=rotate(R2,2);
                    if netztyp==2
                        for k=2+1:4:size(t.graph,2)-4;
                            t(size(t.graph,1)-6,k)=rotate(twoDim(1,1,'branch',qV(iqV)),2);
                        end
                    end
                end
                if q==3 % left source
                    t((size(t.graph,1)+1)/2,1)=rotate(R2,1);
                end
                if q==4 % right source
                    t((size(t.graph,1)+1)/2,size(t.graph,2)-2)=rotate(R2,3);
                end
                
                if netztyp==1 %loop network sturcture
                    t(3,3)=twoDim(i,i,'loop',qV(iqV));
                end
                if netztyp==2 %branch network sturcture
                    t(3,3)=rotate(twoDim(i,i,'branch',qV(iqV)),0);
                end
                
                t.pipes.roughness = 1.5;
                
                WDS.MDS=t;
                % export block
                mdsName=['id' num2str(iwss) '.inp'];
                if makeEPANETinp
                    printmds2(WDS.MDS,mdsName,'options.inp');
                end
                if makePICfile
                    figure
                    set(gcf,'visible','off')
                    plotmds(t)
                    print('-dmeta',['id' num2str(iwss)])
                    close all
                end
                
                
                WSS_Set_2280{iwss}=WDS.MDS;
                cprop=[];
                
                cprop.variation='2dV';
                cprop.netztyp=netztyp;
                cprop.so=q;
                cprop.de=qV(iqV);
                cprop.di=i;
                WSS_Set_2280_prop{iwss}=cprop;
                tt=toc;
                ['run' num2str(iwss) ' ' num2str(tt) ]
                iwss=iwss+1;
            end
            
        end
    end
end

%% complex spatial distribuition
%
% demand variation (de1 de2 de3)
% 3x

% distance (dic):
% 3x
% 1km 5km 10km
D=[1 5 10];

% number of complexes (co1 co2 co4 co6)
% 4x
% 1 2 4 6
G=[1 2 4 6];


% GF: spatial distribution (di)
% 4x
% 1 2 4 6
GF=[1 2 4 6];


% linking structure (li1 li2)
% 2x

% network structure ne1 ne2
% 2x

% 3x3x4x4x2x2=576


% in(2,3);
iwss=1705;

% index for demand variation
for iqV=1:3
    % index for layout structure variation
    % netztyp==1: loop; netztyp==2: branch
    for netztyp=1:2
        % index for linking structure
        for contyp=1:2
            % index for distance between complexes
            for iD=1:length(D)
                % number of complexes
                for iG=1:length(G)
                    % size of complexes
                    for iGF=1:length(GF)
                        tic
                        cprop=[];
                        if contyp==1
                            if netztyp==1
                                t=in(G(iG),D(iD)*2,GF(iGF),'loop',qV(iqV));
                            elseif netztyp==2
                                t=in(G(iG),D(iD)*2,GF(iGF),'branch',qV(iqV));
                            end
                           
                            cprop.variation='li1';
                        end
                        if contyp==2
                            if netztyp==1
                                t=li(G(iG),D(iD)*2,GF(iGF),'loop',qV(iqV));
                            elseif netztyp==2
                                t=li(G(iG),D(iD)*2,GF(iGF),'branch',qV(iqV));
                            end
                            
                            cprop.variation='li2';
                        end
                        
                        t.pipes.roughness = 1.5;
                        
                        
                        WDS.MDS=t;
                        
                        % export block
                        mdsName=['id' num2str(iwss) '.inp'];
                        if makeEPANETinp
                            printmds2(WDS.MDS,mdsName,'options.inp');
                        end
                        if makePICfile
                            figure
                            set(gcf,'visible','off')
                            plotmds(t)
                            print('-dmeta',['id' num2str(iwss)])
                            close all
                            
                        end
                        
                        
                        WSS_Set_2280{iwss}=WDS.MDS;
                        cprop.ne=netztyp;
                        cprop.so=-1;
                        cprop.de=qV(iqV);
                        cprop.co=i;
                        WSS_Set_2280_prop{iwss}=cprop;
                        tt=toc;
                        
                        ['run' num2str(iwss) ' ' num2str(tt) ]
                        iwss=iwss+1;
                    end
                end
            end
        end
    end
end
%%

if saveSet
    save('WSS_Set_2280','WSS_Set_2280');
    save('WSS_Set_2280_prop','WSS_Set_2280_prop');
end
