%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010         
%  R. Sitzenfrei, M. Mderl 
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function li=li(numberOfCO,distance,SizeFactor,layoutStructure, basicDemand)
%call: in(numberOfCO,distance,SizeFactor,layoutStructure, basicDemand)
%variation of intermediate distance  
%integer distance>=2 
%number of complexes >=2

if nargin<5
    basicDemand=1;
end
if nargin<4   
    layoutStructure='loop';
end
if nargin<3
    SizeFactor=1;
end
if nargin<2
    distance=2;
end
if nargin<1
    numberOfCO=2;
end

%check expand
if distance<2
    distance=2;
end

if numberOfCO<2
    numberOfCO=2;
end

[BDR_loop BDR_branched C C0 C1 C2 C3 CON]=getHelpModules();


MDS=twoDim(SizeFactor,SizeFactor,layoutStructure,basicDemand);

%estimate size steps
ver=size(MDS,1);
hor=size(MDS,2);


%create empty modul
li=mds(ver+2,numberOfCO*(hor)+(numberOfCO-1)*(distance-1));

%fill empty modul 
%first BDR
li(1,(size(MDS,1)+1)/2)=getReservoir(2);
li(3,1)=MDS;

%additional BDR
 for j=1:1:numberOfCO-1
     li(1,(size(MDS,1)+1)/2+(distance+hor-1)*j)=getReservoir(2);
     
     li(2+(size(MDS,2)+1)/2+floor((size(MDS,2)+1)/4),-1+1+(distance+hor-1)*j)=rotate(CON,3);
     li(2+(size(MDS,2)+1)/2-floor((size(MDS,2)+1)/4),-1+1+(distance+hor-1)*j)=rotate(CON,3);
     
     li(3,1+(distance+hor-1)*j)=MDS;
 end


%autoconnect
 li = connect(li);

    
%plot device
X = 500*(0:1:size(li,2)-1);
Y = 500*(size(li,1)-1:-1:0);
[X,Y] = meshgrid(X,Y);



li.nodes.x = X;
li.nodes.y = Y;

% plot  module
% plotmds(li);












