%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010         
%  R. Sitzenfrei, M. Mderl 
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function R=getReservoir(whichone)
% getReservoir(whichone)
% help file to create R0, R1, R2
%  R0=getReservoir(0)
%  R1=getReservoir(1)
%  R2=getReservoir(2)

switch whichone
    case 0
        R=getR0();
    case 1 
        R=getR1();
    case 2
        R=getR2();
    otherwise
        R=[];
        'check arguments'
        'getReservoir(int), int=0,1,2'
end
        



function R0=getR0()
mdstypes
% reservoir and connections type R0
% ---------------------------------
%
% [1] graph matrix for module R0
%
%    R
%    |
%  A-J
%    |
%    J

GR0 = [0 8
       1 14 
       0 2];
    
% [2] generating the module R1
R0 = mds(GR0);    

% [3] setting the types of the nodes
R0.nodes.type = [NONE   RESERVOIRS;
                AUTOCONNECT    JUNCTIONS ;
                NONE    JUNCTIONS];


% [4] setting the properties	
	       
% setting the pipe properties affecting ALL PIPES
R0.pipes.roughness = 0.4;
R0.pipes.diam = 80;
R0.hpipes.diam(2,1)=500;

% setting the junction properties affecting ALL JUNCTIONS
R0.junctions.demand = 0;    
R0.junctions.elev = 0;    

% setting the reservoir property
R0.reservoirs.head = 100;




function R1=getR1()
mdstypes
% reservoir and connections type R1
% ---------------------------------
%
% [1] graph matrix for module R1
%
%    R
%    |
%    J-A
%    |
%    J

GR1 = [8 0
      11 4 
       2 0];
    
% [2] generating the module R1
R1 = mds(GR1);    

% [3] setting the types of the nodes
R1.nodes.type = [RESERVOIRS    NONE;
                 JUNCTIONS AUTOCONNECT;
		 JUNCTIONS     NONE];

% [4] setting the properties	
	       
% setting the pipe properties affecting ALL PIPES
R1.pipes.roughness = 0.4;
R1.pipes.diam = 80;
R1.hpipes.diam(2,1)=500;

% setting the junction properties affecting ALL JUNCTIONS
R1.junctions.demand = 0;    
R1.junctions.elev = 0;    

% setting the reservoir property
R1.reservoirs.head = 100;




function R2=getR2()
mdstypes
% reservoir and connections type R2
% ---------------------------------
%
% [1] graph matrix for module R2
%
%    R
%    |
%    J
%    |
%    J

GR2 = [8
       10 
       2];
    
% [2] generating the module R1
R2 = mds(GR2);    

% [3] setting the types of the nodes
R2.nodes.type = [RESERVOIRS;
                 JUNCTIONS ;
                JUNCTIONS];
            
            % setting the pipe properties affecting ALL PIPES
R2.pipes.roughness = 0.4;
R2.pipes.diam = 80;

% setting the junction properties affecting ALL JUNCTIONS
R2.junctions.demand = 0;    
R2.junctions.elev = 0;    

% setting the reservoir property
R2.reservoirs.head = 100;
