%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010         
%  R. Sitzenfrei, M. Mderl 
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [BDR_loop BDR_branched C C0 C1 C2 C3 CON]=getHelpModules()
% [BDR_loop BDR_branched C C0 C1 C2 C3 CON]=getHelpModules()
mdstypes



%corner
%
%   J-J
%   |
%   J
C0=[9   4
    2   0];

C0=mds(C0);
C1=rotate(C0,1);
C2=rotate(C0,2);
C3=rotate(C0,3);

%3x3 square 
%
%   J-J-J
%   |   |
%   J   J
%   |   |
%   J J-J
C=mds(3,3);


C(1,1) =  C0;
C(2,1) =  C1;
C(2,2) =  C2;
C(1,2) =  C3;


% BDR_loop basic demand raster
%
%   J-J-J-J-J
%   |   |   |
%   J J-J-J J
%   | | | | |
%   J-J-J-J-J
%   | | | | |
%   J J-J-J J
%   |   |   |
%   J-J-J-J-J

BDR_loop=mds(5,5);

BDR_loop(1,1)=C;
BDR_loop(1,3)=C;
BDR_loop(3,1)=C;
BDR_loop(3,3)=C;
BDR_loop(2,2)=C;


% set parameters
% ---------------------------------

BDR_loop.pipes.roughness = 0.4;
BDR_loop.pipes.diam = 80;


BDR_loop.junctions.elev = 0;

% basic demands
% 0.1 l/s; 1 l/s; 5 l/s
basicDemand=1;

% demand variation between 75% and 125%
variation =0.75 +  0.5*rand(5,5);
for i=1:size(BDR_loop,1)
    for j=1:size(BDR_loop,2)
        BDR_loop.junctions.demand(i,j) =basicDemand*variation(i,j);
    end
end
% ---------------------------------


X = 100*(0:1:size(BDR_loop,2)-1);
Y = 100*(size(BDR_loop,1)-1:-1:0);
[X,Y] = meshgrid(X,Y);



BDR_loop.nodes.x = X;
BDR_loop.nodes.y = Y;





% BDR_branched basic demand raster
%
%   J-J-J-J-J
%   |   |   |
%   J J-J-J J
%   |   |   |
%   J-J J J-J
%   |   |   |
%   J J-J-J J
%   |   |   |
%   J-J J J-J
    bdr_branched=...
    [9     5    13     5    12
    10     8     2     8     2
    11    15     5    15     4
    10     2     8     2     8
     3     5     7     5     6];




BDR_branched=mds(bdr_branched);



% parameters
% ---------------------------------

BDR_branched.pipes.roughness = 1.5;
BDR_branched.pipes.diam = 80;


BDR_branched.junctions.elev = 0;

% basic demands
% 0.1 l/s; 1l/s; 5 l/s
basicDemand=1;

% demand variation between 75% and 125%
variation =0.75 +  0.5*rand(size(BDR_branched.graph));

for i=1:size(BDR_branched.graph,1)
    for j=1:size(BDR_branched.graph,2)
        BDR_branched.junctions.demand(i,j) =basicDemand*variation(i,j);
    end
end
% ---------------------------------


X = 500*(0:1:size(BDR_branched,2)-1);
Y = 500*(size(BDR_branched,1)-1:-1:0);
[X,Y] = meshgrid(X,Y);



BDR_branched.nodes.x = X;
BDR_branched.nodes.y = Y;

mdstypes
% autoConnector
% ---------
% 
%  J
%  |
%  A

CON = [8
     2];
CON = mds(CON);

% setting the types
CON.nodes.type = [JUNCTIONS; 
                AUTOCONNECT];
CON.arc.type  = PIPES;

% setting the properties
CON.reservoirs.head = 100;
CON.junctions.demand = 0;  % the autoconnecting node is always a junction!
CON.junctions.elev = 0;

CON.pipes.roughness = 0.4;
CON.pipes.diam = 200;





