%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  MDS - Additional functions 1.04 2010         
%  R. Sitzenfrei, M. Mderl 
%  http://www.hydro-it.com/extern/IUT/mds_app/
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function returnMDS=de2(basicDemand)
if nargin==0
    basicDemand=1;
end

[BDR_loop BDR_branched C C0 C1 C2 C3]=getHelpModules();


% demand variation between 75% and 125%
variation =0.75 +  0.5*rand(5,5);
for i=1:size(BDR_loop,1)
    for j=1:size(BDR_loop,2)
        BDR.junctions.demand(i,j) =basicDemand*variation(i,j);
    end
end



R2=getReservoir(2);

%estimate size
ver=size(BDR_loop,1);
hor=size(BDR_loop,2);


%create empty modul
de2=mds(ver+2,hor);
%fill empty modul 
de2(1,3)=R2;
de2(3,1)=BDR_loop;


X = 100*(0:1:size(de2,2)-1);
Y = 100*(size(de2,1)-1:-1:0);
[X,Y] = meshgrid(X,Y);

de2.nodes.x = X;
de2.nodes.y = Y;

% plot  module
plotmds(de2)
% print -dpdf pic


returnMDS=de2;

